/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.cdf.util;

import com.ibm.neo.dataimport.cdf.sheet.ICDFCell;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRow;
import com.ibm.neo.dataimport.cdf.sheet.ICDFRowCursor;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheet;
import com.ibm.neo.dataimport.cdf.sheet.ICDFSheetReader;
import com.ibm.neo.dataimport.cdf.sheet.RuntimeSheetException;
import com.ibm.neo.dataimport.nodel.EDataType;
import com.ibm.neo.util.FrequencyCounter;
import java.io.IOException;

public class CDFUtils {
    private CDFUtils() {
    }

    public static int[] updateMaxStringLengths(ICDFRow row, int[] maxStringLengths) {
        return CDFUtils.updateMaxStringLengths(row.getCells(null), maxStringLengths);
    }

    public static int[] updateMaxStringLengths(ICDFCell[] cells, int[] maxStringLengths) {
        return CDFUtils.updateMaxStringLengths(cells, maxStringLengths, null);
    }

    public static int[] updateMaxStringLengths(ICDFCell[] cells, int[] maxStringLengths, FrequencyCounter<EDataType>[] typeCounts) {
        if (cells.length > maxStringLengths.length) {
            int[] old = maxStringLengths;
            maxStringLengths = new int[cells.length];
            System.arraycopy(old, 0, maxStringLengths, 0, old.length);
        }
        if (typeCounts != null && cells.length > typeCounts.length) {
            FrequencyCounter<EDataType>[] oldCounts = typeCounts;
            typeCounts = new FrequencyCounter[cells.length];
            System.arraycopy(oldCounts, 0, typeCounts, 0, oldCounts.length);
        }
        for (int i = 0; i < cells.length; ++i) {
            ICDFCell cell = cells[i];
            if (typeCounts != null && typeCounts[i] == null) {
                typeCounts[i] = new FrequencyCounter();
            }
            if (cell == null || cell.isNull() || cell.getDataType() == null) continue;
            switch (cell.getDataType()) {
                case STRING: {
                    String strVal = cell.stringValue();
                    if (null == strVal) break;
                    maxStringLengths[i] = Math.max(maxStringLengths[i], strVal.length());
                    break;
                }
                default: {
                    maxStringLengths[i] = Math.max(maxStringLengths[i], cell.getDataType().maxStringLength());
                }
            }
            if (typeCounts == null) continue;
            typeCounts[i].increment((Object)cell.getDataType());
        }
        return maxStringLengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] computeMaxStringLengths(ICDFSheet sheet) {
        ICDFSheetReader reader = null;
        int[] maxStringLengths = new int[]{};
        try {
            try {
                reader = sheet.openReader();
                ICDFRowCursor cursor = reader.cursor();
                while (cursor.next()) {
                    maxStringLengths = CDFUtils.updateMaxStringLengths(cursor.getRow(), maxStringLengths);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeSheetException(e);
        }
        return maxStringLengths;
    }
}

