/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;

public class AnonymoustHelper {
    public static final String ANONYMOUS_ACCOUNT_ID = "000000000000000000000000";
    public static final String ANONYMOUS_ACCOUNT_NAME = "__anonymous_account__";
    public static final String ANONYMOUS_USER_ID = "000000000000000000000000";
    public static final String ANONYMOUS_USER_NAME = "__anonymous_user__";
    public static final String ANONYMOUS_USER_EMAIL = "anonymous@ibm.com";
    public static final String ANONYMOUS_TENANT_ID = "000000000000000000000000";
    public static final String ANONYMOUS_TENANT_NAME = "__anonymous_tenant__";
    private final SecurityManager mSecurityManager;
    private SubjectThreadState mSubjectBinding = null;

    public AnonymoustHelper() {
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory();
        this.mSecurityManager = (SecurityManager)factory.getInstance();
    }

    public AnonymoustHelper(SecurityManager securityManager) {
        this.mSecurityManager = securityManager;
    }

    public void bind() {
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)"__anonymous__", "AnonymousRealm");
        Subject subject = new Subject.Builder(this.mSecurityManager).principals((PrincipalCollection)principals).authenticated(true).sessionCreationEnabled(true).buildSubject();
        Session session = subject.getSession(true);
        session.setAttribute((Object)"account.id", (Object)"000000000000000000000000");
        session.setAttribute((Object)"account.name", (Object)ANONYMOUS_ACCOUNT_NAME);
        session.setAttribute((Object)"user.id", (Object)"000000000000000000000000");
        session.setAttribute((Object)"user.name", (Object)ANONYMOUS_USER_NAME);
        session.setAttribute((Object)"user.email", (Object)ANONYMOUS_USER_EMAIL);
        session.setAttribute((Object)"tenant.id", (Object)"000000000000000000000000");
        session.setAttribute((Object)"tenant.name", (Object)ANONYMOUS_TENANT_NAME);
        session.setAttribute((Object)"tenant.content.model", (Object)"PRIVATE");
        this.mSubjectBinding = new SubjectThreadState(subject);
        this.mSubjectBinding.bind();
    }

    public void unbind() {
        if (null == this.mSubjectBinding) {
            throw new IllegalStateException("No Subject was bound!");
        }
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        this.mSubjectBinding.clear();
    }
}

