/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security;

import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class SubjectHelper {
    public static void requireAuthenticated(Subject subject) throws UnauthenticatedException {
        if (!subject.isAuthenticated()) {
            throw new UnauthenticatedException();
        }
    }

    public static boolean hasAnyOfTheseRoles(Subject subject, String ... roles) {
        for (String role : roles) {
            if (!subject.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNoneOfTheseRoles(Subject subject, String ... roles) {
        for (String role : roles) {
            if (!subject.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public static void checkAnyOfTheseRoles(Subject subject, String ... roles) throws UnauthorizedException {
        if (!SubjectHelper.hasAnyOfTheseRoles(subject, roles)) {
            throw new UnauthorizedException();
        }
    }

    public static Serializable getSessionId(Subject subject, boolean isRequired) {
        Session session = subject.getSession(false);
        if (null == session) {
            if (isRequired) {
                throw new IllegalStateException("Session does not exist");
            }
            return null;
        }
        return session.getId();
    }

    public static String getSessionIdAsString(Subject subject, boolean isRequired) {
        Serializable sessionId = SubjectHelper.getSessionId(subject, isRequired);
        if (null == sessionId) {
            return null;
        }
        return String.valueOf(sessionId);
    }

    public static <T> T getSessionAttribute(Subject subject, String name, Class<T> returnType, boolean isRequired) {
        try {
            Session session = subject.getSession(false);
            if (null == session) {
                if (isRequired) {
                    throw new IllegalStateException("Session does not exist");
                }
                return null;
            }
            T value = returnType.cast(session.getAttribute((Object)name));
            if (null == value && isRequired) {
                throw new IllegalStateException("Missing required session attribute: " + name);
            }
            return value;
        }
        catch (RuntimeException e) {
            if (isRequired) {
                throw e;
            }
            return null;
        }
    }

    public static <T> void setSessionAttribute(Subject subject, String name, Object value) {
        Session session = subject.getSession(false);
        if (null == session) {
            throw new IllegalStateException("Session does not exist");
        }
        session.setAttribute((Object)name, value);
    }

    public static void touchCurrentSession() {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession(false);
        if (null != session) {
            session.touch();
        }
    }

    private SubjectHelper() {
    }
}

