/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.EmptyResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.resultset.MetadataResultSet;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractAdaptor {
    public static final String OVERRIDE_PROP_PREFIX = "adaptor.method.override.sql";
    public static final String REPLACE_NULL_WITH_EMPTY_STR = "adaptor.method.override.sql.replaceNullWithEmptyString";
    private static final Pattern OPTIONAL_STRING_PATTERN = Pattern.compile("(\\[|\\])");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("(?<=\\%)(\\d+)(?=\\$)");
    protected AdaptorFactory factory;

    public AbstractAdaptor(AdaptorFactory adaptorFactory) {
        this.factory = adaptorFactory;
    }

    protected ResultSet executeSqlStatement(String m, Object ... args) throws SQLException {
        String sqlStmt;
        String formatStr = this.findSQLOverride(m);
        if (formatStr == null) {
            return null;
        }
        if (formatStr.isEmpty()) {
            return new EmptyResultSetAdaptor();
        }
        String[] parts = OPTIONAL_STRING_PATTERN.split(formatStr);
        StringBuilder frmtBldr = new StringBuilder();
        if (args != null) {
            Object[] fixedArgs = new Object[args.length];
            for (String str : parts) {
                if (str.startsWith(":")) {
                    Matcher matcher = FORMAT_PATTERN.matcher(str);
                    if (!matcher.find()) {
                        throw new SQLException("Invalid optional parameter: " + str + " in sql statement: " + formatStr);
                    }
                    int paramNum = -1;
                    try {
                        paramNum = Integer.parseInt(matcher.group(1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Invalid optional parameter: " + str + "(not a number) in sql statement: " + formatStr);
                    }
                    if (paramNum >= args.length || args[paramNum] == null) continue;
                    str = str.substring(1);
                }
                frmtBldr.append(str);
            }
            args = this.replaceNullsIfRequired(args);
            for (int i = 0; i < fixedArgs.length; ++i) {
                fixedArgs[i] = args[i] instanceof String[] ? this.buildString((String[])args[i]) : args[i];
            }
            sqlStmt = String.format(frmtBldr.toString(), fixedArgs);
        } else {
            sqlStmt = formatStr;
        }
        Connection connection = this.getConnection();
        return connection.createStatement().executeQuery(sqlStmt);
    }

    private String buildString(String[] strings) {
        StringBuilder bldr = new StringBuilder();
        boolean isFirst = true;
        for (String string : strings) {
            if (!isFirst) {
                bldr.append(", ");
            } else {
                isFirst = false;
            }
            bldr.append(string);
        }
        return bldr.toString();
    }

    private String findSQLOverride(String m) {
        return this.factory.getAdaptorProperties().getProperty("adaptor.method.override.sql." + m);
    }

    protected Object wrapReturnObject(Object toWrap) {
        if (toWrap == null) {
            return toWrap;
        }
        Object retVal = toWrap;
        if (toWrap instanceof Connection) {
            retVal = this.factory.wrapConnection((Connection)toWrap);
        } else if (toWrap instanceof DatabaseMetaData) {
            retVal = this.factory.wrapDatabaseMetadata((DatabaseMetaData)toWrap);
        } else if (toWrap instanceof CallableStatement) {
            retVal = this.factory.wrapCallableStatement((CallableStatement)toWrap);
        } else if (toWrap instanceof PreparedStatement) {
            retVal = this.factory.wrapPreparedStatement((PreparedStatement)toWrap);
        } else if (toWrap instanceof Statement) {
            retVal = this.factory.wrapStatement((Statement)toWrap);
        } else if (toWrap instanceof ResultSet) {
            String wrapMetadataRS = this.findProperty(String.format("adaptor.wrap.metadata.resultset.%1$s", "getObject"));
            if (wrapMetadataRS != null) {
                toWrap = MetadataResultSet.wrapResultSet((ResultSet)toWrap, this.factory, new MetadataResultSet.RSInfo(wrapMetadataRS));
            }
            retVal = this.factory.wrapResultSet((ResultSet)toWrap);
        } else if (toWrap instanceof ResultSetMetaData) {
            retVal = this.factory.wrapResultSetMetaData((ResultSetMetaData)toWrap);
        }
        return retVal;
    }

    private Object[] replaceNullsIfRequired(Object[] args) {
        String replace = this.getAdaptorFactory().getAdaptorProperties().getProperty(REPLACE_NULL_WITH_EMPTY_STR);
        if (replace != null && !Boolean.parseBoolean(replace)) {
            return args;
        }
        Object[] replaced = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            replaced[i] = args[i] == null && args[i] instanceof String ? "" : args[i];
        }
        return replaced;
    }

    public AdaptorFactory getAdaptorFactory() {
        return this.factory;
    }

    public final String findProperty(String key) {
        return this.factory.getAdaptorProperties().getProperty(key);
    }

    public abstract Connection getConnection() throws SQLException;
}

