/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.FilePropertyLoader;
import com.ibm.cognos.jdbc.adaptor.JarFilePropertyLoader;
import com.ibm.cognos.jdbc.adaptor.SDKAdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.util.AdaptorException;
import com.ibm.cognos.jdbc.adaptor.util.UncertifiedAdaptorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractPropertyLoader {
    private static final String CLASS = ".class";
    protected static final String RES = "res/";
    private static final String SEP = "_";
    private static final String DOT = ".";
    private static final String FILE_PREFIX = "file:";
    protected static final String PROPERTY_FILENAME_MATCHER = ".*AdaptorFactory.*\\.xml$";
    protected static final String XML = ".xml";
    protected static final String SLASH = "/";
    protected static final String EXCLAMATION = "!";
    protected static final String DRIVER = "_DRIVER";
    protected HashMap<String, Properties> propertiesCache = new HashMap();

    public static AbstractPropertyLoader getInstance(Class<?> clazz) {
        if (System.getProperty("AdaptorFactory.resources") != null) {
            return new FilePropertyLoader(System.getProperty("AdaptorFactory.resources"));
        }
        String name = clazz.getName().replace(DOT, SLASH) + CLASS;
        URL classURL = clazz.getClassLoader().getResource(name);
        if (clazz.equals(SDKAdaptorFactory.class)) {
            String location = AbstractPropertyLoader.getJarLocation(classURL);
            return new FilePropertyLoader(location);
        }
        return new JarFilePropertyLoader(AbstractPropertyLoader.getJarFileName(classURL));
    }

    protected AbstractPropertyLoader() {
    }

    protected abstract InputStream getPropertyInputStream(String var1);

    protected abstract String getResourceLocation();

    public abstract String getResourceVersion();

    private String getName(String baseName, String major, String minor, String subMinor, String subtype) {
        String bestName = null;
        boolean isDriverName = baseName.endsWith(DRIVER);
        if (this.propertiesCache.containsKey(baseName)) {
            bestName = baseName;
        }
        String name = baseName + SEP;
        if (subtype != null) {
            if (this.propertiesCache.containsKey(name = name + subtype)) {
                bestName = name;
            }
        } else if (isDriverName) {
            name = baseName;
        }
        if (isDriverName) {
            name = name + SLASH;
        }
        if (major != null && this.propertiesCache.containsKey(name = name + major)) {
            bestName = name;
        }
        if (minor != null && this.propertiesCache.containsKey(name = name + DOT + minor)) {
            bestName = name;
        }
        if (subMinor != null && this.propertiesCache.containsKey(name = name + DOT + subMinor)) {
            bestName = name;
        }
        if (bestName == null && !baseName.endsWith(DRIVER)) {
            throw new UncertifiedAdaptorException();
        }
        return bestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String name) {
        HashMap<String, Properties> hashMap = this.propertiesCache;
        synchronized (hashMap) {
            Properties props = this.propertiesCache.get(name);
            if (props == null) {
                AdaptorException exception;
                block10: {
                    props = new Properties();
                    InputStream is = null;
                    exception = null;
                    try {
                        is = this.getPropertyInputStream(name);
                        props.loadFromXML(is);
                    }
                    catch (Exception e) {
                        exception = new AdaptorException(e);
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (exception != null) break block10;
                            exception = new AdaptorException(e);
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                this.propertiesCache.put(name, props);
            }
        }
    }

    public Properties getProperties(String baseName, String serverMajor, String serverMinor, String serverSubMinor, String subtype, HashMap<String, Object> info, String driverMajor, String driverMinor, String driverSubMinor) {
        String bestName = this.getName(baseName, serverMajor, serverMinor, serverSubMinor, subtype);
        String bestDriverName = this.getName(baseName + DRIVER, driverMajor, driverMinor, driverSubMinor, subtype);
        Properties props = this.propertiesCache.get(bestName);
        if (props == null) {
            this.loadProperties(bestName);
            props = this.propertiesCache.get(bestName);
        }
        if (bestDriverName != null && this.propertiesCache.containsKey(bestDriverName)) {
            Properties drprops = this.propertiesCache.get(bestDriverName);
            if (drprops == null) {
                this.loadProperties(bestDriverName);
            }
            drprops = this.propertiesCache.get(bestDriverName);
            this.propertiesCache.get(bestName).putAll((Map<?, ?>)drprops);
        }
        if (info != null) {
            info.put("adaptorLocation", this.getResourceLocation());
            info.put("propertyFile", bestName);
        }
        return props;
    }

    public Properties getProperties(String baseName, String serverMajor, String serverMinor, String subtype, HashMap<String, Object> info, String driverMajor, String driverMinor, String driverSubMinor) {
        Properties props = this.getProperties(baseName, serverMajor, serverMinor, null, subtype, info, driverMajor, driverMinor, driverSubMinor);
        return props;
    }

    private static String getJarLocation(URL classURL) {
        File jarFile = new File(AbstractPropertyLoader.getJarFileName(classURL));
        return jarFile.getParentFile().getAbsolutePath();
    }

    private static String getJarFileName(URL classURL) {
        String path = classURL.getFile();
        String[] parts = path.split(EXCLAMATION);
        try {
            return URLDecoder.decode(parts[0].replace(FILE_PREFIX, ""), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

