/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.BaseCallableStatementAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseMetadataMapper;
import com.ibm.cognos.jdbc.adaptor.BasePreparedStatementAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetMetaDataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseStatementAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosInvalidLogonException;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosUnrecoverableConnectionException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;

public abstract class AdaptorFactory {
    private static final String UNRECOVERABLE_CONNECTION = "UNRECOVERABLE_CONNECTION";
    private static final String ERROR_FULLKEY_FORMAT = "error.%1$s.%2$d";
    private static final String ERROR_STATEKEY_FORMAT = "error.%1$s";
    private static final String ERROR_CODEKEY_FORMAT = "error..%1$d";
    private static final String INVALID_CREDENTIALS = "INVALID_CREDENTIALS";
    private static final String[] KNOWN_MESSAGES_FOR_INVALID_CREDENTIALS = new String[]{"authentication error: The username or password is incorrect", "AWS accessId/secretKey or AWS credentials provider must be provided"};
    private static final String XML_TAG_FAULT = "XML_TAG_FAULT";
    private static final String INVALID_CUBE_PWD = "INVALID_CUBE_PWD";
    private static final String MAX_CONNECTIONS = "MAX_CONNECTIONS";
    private static final String NO_CONNECTION = "NO_CONNECTION";
    private static final String INVALID_SERVER = "INVALID_SERVER";
    private static final String INVALID_CONN_STRING = "INVALID_CONN_STRING";
    private static final String SQLSTATE_INVALID_AUTHORIZATION = "28000";
    private IWrapper connectionWrapper;
    private IWrapper statementWrapper;
    private IWrapper callableStmtWrapper;
    private IWrapper preparedStmtWrapper;
    private IWrapper resultSetWrapper;
    private IWrapper databaseMetadataWrapper;
    private IWrapper resultSetMetadataWrapper;
    private BaseMetadataMapper metadataMapper;
    private String subType;
    private Properties adaptorProperties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdaptorFactory() {
        this.connectionWrapper = new BaseConnectionAdaptor.Wrapper();
        this.databaseMetadataWrapper = new BaseDatabaseMetadataAdaptor.Wrapper();
        this.callableStmtWrapper = new BaseCallableStatementAdaptor.Wrapper();
        this.preparedStmtWrapper = new BasePreparedStatementAdaptor.Wrapper();
        this.statementWrapper = new BaseStatementAdaptor.Wrapper();
        this.resultSetWrapper = new BaseResultSetAdaptor.Wrapper();
        this.resultSetMetadataWrapper = new BaseResultSetMetaDataAdaptor.Wrapper();
        this.metadataMapper = new BaseMetadataMapper(this);
        this.registerWrappers();
        if (this.getPropertyLoader() == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.getPropertyLoader() == null) {
                    this.setPropertyLoader(AbstractPropertyLoader.getInstance(this.getClass()));
                }
            }
        }
    }

    protected abstract void setPropertyLoader(AbstractPropertyLoader var1);

    protected abstract AbstractPropertyLoader getPropertyLoader();

    protected void registerWrappers() {
    }

    public String getVersion() {
        return this.getPropertyLoader().getResourceVersion();
    }

    public void setConnectionWrapper(IWrapper wrapper) {
        this.connectionWrapper = wrapper;
    }

    public IWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    public IWrapper getStatementWrapper() {
        return this.statementWrapper;
    }

    public void setStatementWrapper(IWrapper stmtWrapper) {
        this.statementWrapper = stmtWrapper;
    }

    public IWrapper getCallableStmtWrapper() {
        return this.callableStmtWrapper;
    }

    public void setCallableStmtWrapper(IWrapper cStmtWrapper) {
        this.callableStmtWrapper = cStmtWrapper;
    }

    public IWrapper getPreparedStmtWrapper() {
        return this.preparedStmtWrapper;
    }

    public void setPreparedStmtWrapper(IWrapper pStmtWrapper) {
        this.preparedStmtWrapper = pStmtWrapper;
    }

    public IWrapper getResultSetWrapper() {
        return this.resultSetWrapper;
    }

    public void setResultSetWrapper(IWrapper rsWrapper) {
        this.resultSetWrapper = rsWrapper;
    }

    public IWrapper getDatabaseMetadataWrapper() {
        return this.databaseMetadataWrapper;
    }

    public void setDatabaseMetadataWrapper(IWrapper dbMetadataWrapper) {
        this.databaseMetadataWrapper = dbMetadataWrapper;
    }

    public IWrapper getResultSetMetadataWrapper() {
        return this.resultSetMetadataWrapper;
    }

    public void setResultSetMetadataWrapper(IWrapper rsMetadataWrapper) {
        this.resultSetMetadataWrapper = rsMetadataWrapper;
    }

    public final Properties getAdaptorProperties() {
        return this.adaptorProperties;
    }

    public void setAdaptorProperties(String baseName, String serverMajor, String serverMinor, String serverSubMinor, String subtype, HashMap<String, Object> info, String driverMajor, String driverMinor, String driverSubMinor) {
        this.adaptorProperties = (Properties)this.getPropertyLoader().getProperties(baseName, serverMajor, serverMinor, serverSubMinor, subtype, info, driverMajor, driverMinor, driverSubMinor).clone();
    }

    public Connection wrapConnection(Connection toWrap) {
        return (Connection)((Object)this.connectionWrapper.wrap(toWrap, this));
    }

    public DatabaseMetaData wrapDatabaseMetadata(DatabaseMetaData dbMetadata) {
        return (DatabaseMetaData)((Object)this.databaseMetadataWrapper.wrap(dbMetadata, this));
    }

    public CallableStatement wrapCallableStatement(CallableStatement stmt) {
        return (CallableStatement)((Object)this.callableStmtWrapper.wrap(stmt, this));
    }

    public PreparedStatement wrapPreparedStatement(PreparedStatement stmt) {
        return (PreparedStatement)((Object)this.preparedStmtWrapper.wrap(stmt, this));
    }

    public ResultSet wrapResultSet(ResultSet rs) {
        return (ResultSet)((Object)this.resultSetWrapper.wrap(rs, this));
    }

    public ResultSetMetaData wrapResultSetMetaData(ResultSetMetaData metadata) {
        return (ResultSetMetaData)((Object)this.resultSetMetadataWrapper.wrap(metadata, this));
    }

    public Statement wrapStatement(Statement stmt) {
        return (Statement)((Object)this.statementWrapper.wrap(stmt, this));
    }

    public SQLException processSQLException(SQLException t) {
        String message;
        String state = t.getSQLState();
        int code = t.getErrorCode();
        if (state != null || code != 0) {
            String fullKey = String.format(ERROR_FULLKEY_FORMAT, state, code);
            String shortStateKey = String.format(ERROR_STATEKEY_FORMAT, state);
            String shortErrorKey = String.format(ERROR_CODEKEY_FORMAT, code);
            String value = this.adaptorProperties.getProperty(fullKey);
            if (value == null && (value = this.adaptorProperties.getProperty(shortStateKey)) == null) {
                value = this.adaptorProperties.getProperty(shortErrorKey);
            }
            if (value != null) {
                if (value.equalsIgnoreCase(UNRECOVERABLE_CONNECTION)) {
                    return new SQLCognosUnrecoverableConnectionException(t);
                }
                if (value.equalsIgnoreCase(INVALID_CREDENTIALS)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS);
                }
                if (value.equalsIgnoreCase(INVALID_CONN_STRING)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_CONN_STRING);
                }
                if (value.equalsIgnoreCase(INVALID_SERVER)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_SERVER);
                }
                if (value.equalsIgnoreCase(NO_CONNECTION)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.NO_CONNECTION);
                }
                if (value.equalsIgnoreCase(MAX_CONNECTIONS)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.MAX_CONNECTIONS);
                }
                if (value.equalsIgnoreCase(INVALID_CUBE_PWD)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_CUBE_PWD);
                }
                if (value.equalsIgnoreCase(XML_TAG_FAULT)) {
                    return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.XML_TAG_FAULT);
                }
            } else if (SQLSTATE_INVALID_AUTHORIZATION.equals(state)) {
                return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS);
            }
        }
        if (null != (message = t.getMessage()) && this.isKnownInvalidLogonMessage(message, KNOWN_MESSAGES_FOR_INVALID_CREDENTIALS)) {
            return new SQLCognosInvalidLogonException(t, SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS);
        }
        return t;
    }

    public void setMetadataMapper(BaseMetadataMapper metadataMapper) {
        this.metadataMapper = metadataMapper;
    }

    public BaseMetadataMapper getMetadataMapper() {
        return this.metadataMapper;
    }

    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection = null;
        connection = driver.connect(url, driverProperties);
        if (connection == null) {
            SQLCognosInvalidLogonException ex = new SQLCognosInvalidLogonException("The connection object was not initialized properly.", SQLCognosInvalidLogonException.SubCode.INVALID_CONN_STRING);
            throw ex;
        }
        return connection;
    }

    protected void determineSubType(Connection connection) throws SQLException {
        DatabaseMetaData dmd = connection.getMetaData();
        for (Object o : this.adaptorProperties.keySet()) {
            String[] parts;
            String key = (String)o;
            if (!key.startsWith("subType.") || (parts = key.split("\\.")).length != 3 || !this.getDataForSubypeMatch(dmd, parts[2]).matches(this.adaptorProperties.getProperty(key))) continue;
            this.setSubType(parts[1]);
            return;
        }
    }

    private String getDataForSubypeMatch(DatabaseMetaData dmd, String name) {
        String rc = "";
        if (name.equalsIgnoreCase("ProductVersion")) {
            try {
                rc = dmd.getDatabaseProductVersion();
            }
            catch (Throwable throwable) {}
        } else if (name.equalsIgnoreCase("ProductName")) {
            try {
                rc = dmd.getDatabaseProductName();
            }
            catch (Throwable throwable) {}
        } else if (name.equalsIgnoreCase("DriverVersion")) {
            try {
                rc = dmd.getDriverVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rc;
    }

    protected void setSubType(String s) {
        this.subType = s;
    }

    public String getSubType() {
        return this.subType;
    }

    private boolean isKnownInvalidLogonMessage(String errMsg, String[] knownMessages) {
        for (String msg : knownMessages) {
            if (!errMsg.equals(msg)) continue;
            return true;
        }
        return false;
    }
}

