/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BaseCallableStatementAdaptor
extends AbstractAdaptor
implements CallableStatement {
    public static final String METHOD_NOT_SUPPORTED = "Method not supported";
    protected CallableStatement cstmt;
    public static final String REVERSE_MAPPING_PREFIX = "reverse.data.type.mapping";
    public static final String REVERSE_MAPPING_PREFIX_FRMT = "reverse.data.type.mapping.%1$s";
    private static final String REVERSE_MAPPING_DUMMY = String.format("reverse.data.type.mapping.%1$s", "dummy");

    public BaseCallableStatementAdaptor(CallableStatement statement, AdaptorFactory factory) {
        super(factory);
        this.cstmt = statement;
    }

    private Properties getProperties() {
        Properties props = this.getAdaptorFactory().getAdaptorProperties();
        if (!props.containsKey(REVERSE_MAPPING_DUMMY)) {
            String prefix = String.format("data.type.mapping.%1$s", "");
            Set<Map.Entry<Object, Object>> entries = props.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.startsWith(prefix)) continue;
                String vendorDT = key.substring(prefix.length());
                String reverseKey = String.format(REVERSE_MAPPING_PREFIX_FRMT, value);
                try {
                    Integer.parseInt(vendorDT);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (props.containsKey(reverseKey)) continue;
                props.setProperty(reverseKey, vendorDT);
            }
            props.setProperty(REVERSE_MAPPING_DUMMY, "");
        }
        return props;
    }

    @Override
    public void addBatch() throws SQLException {
        this.cstmt.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.cstmt.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.cstmt.execute();
    }

    @Override
    public final ResultSet executeQuery() throws SQLException {
        ResultSet rs = this.executeSqlStatement("executeQuery", new Object[0]);
        if (null == rs) {
            rs = this.executeQueryImpl();
        }
        if (null == rs) {
            return rs;
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet executeQueryImpl() throws SQLException {
        return this.cstmt.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.cstmt.executeUpdate();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData rsmd = this.getMetaDataImpl();
        if (null == rsmd) {
            return rsmd;
        }
        return this.factory.wrapResultSetMetaData(rsmd);
    }

    protected ResultSetMetaData getMetaDataImpl() throws SQLException {
        return this.cstmt.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.cstmt.getParameterMetaData();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.cstmt.setArray(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.cstmt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cstmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.cstmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.cstmt.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.cstmt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cstmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.cstmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.cstmt.setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.cstmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.cstmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.cstmt.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.cstmt.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.cstmt.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.cstmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.cstmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cstmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.cstmt.setClob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.cstmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cstmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.cstmt.setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.cstmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.cstmt.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.cstmt.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.cstmt.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.cstmt.setLong(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.cstmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.cstmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.cstmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.cstmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cstmt.setNCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.cstmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.cstmt.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.cstmt.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.cstmt.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.cstmt.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.cstmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.cstmt.setRef(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.cstmt.setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.cstmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.cstmt.setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.cstmt.setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.cstmt.setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.cstmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.cstmt.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.cstmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.cstmt.setURL(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cstmt.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.cstmt.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.cstmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.cstmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.cstmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.cstmt.close();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.cstmt.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.cstmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.cstmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.cstmt.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.cstmt.executeBatch();
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        ResultSet rs = this.executeSqlStatement("executeQuery", sql);
        if (null == rs) {
            rs = this.executeQueryImpl(sql);
        }
        if (null == rs) {
            return rs;
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet executeQueryImpl(String sql) throws SQLException {
        return this.cstmt.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.cstmt.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.cstmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.cstmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.cstmt.executeUpdate(sql, columnNames);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.cstmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.cstmt.getFetchSize();
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getGeneratedKeys", new Object[0]);
        if (null == rs) {
            rs = this.getGeneratedKeysImpl();
        }
        if (null == rs) {
            return rs;
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getGeneratedKeysImpl() throws SQLException {
        return this.cstmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.cstmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.cstmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.cstmt.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.cstmt.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.cstmt.getQueryTimeout();
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.executeSqlStatement("getResultSet", new Object[0]);
        if (null == rs) {
            rs = this.getResultSetImpl();
        }
        if (null == rs) {
            return rs;
        }
        return this.factory.wrapResultSet(rs);
    }

    protected ResultSet getResultSetImpl() throws SQLException {
        return this.cstmt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.cstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.cstmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.cstmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.cstmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.cstmt.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.cstmt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.cstmt.isPoolable();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cstmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.cstmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.cstmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.cstmt.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.cstmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.cstmt.setMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.cstmt.setPoolable(poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.cstmt.setQueryTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.cstmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.cstmt.unwrap(iface);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.cstmt.getArray(parameterIndex);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.cstmt.getArray(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.cstmt.getBigDecimal(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.cstmt.getBigDecimal(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.cstmt.getBigDecimal(parameterIndex, scale);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.cstmt.getBlob(parameterIndex);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.cstmt.getBlob(parameterName);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.cstmt.getBoolean(parameterIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.cstmt.getBoolean(parameterName);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.cstmt.getByte(parameterIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.cstmt.getByte(parameterName);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.cstmt.getBytes(parameterIndex);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.cstmt.getBytes(parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.cstmt.getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.cstmt.getCharacterStream(parameterName);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.cstmt.getClob(parameterIndex);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.cstmt.getClob(parameterName);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.cstmt.getDate(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.cstmt.getDate(parameterName);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.cstmt.getDate(parameterIndex, cal);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.cstmt.getDate(parameterName, cal);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.cstmt.getDouble(parameterIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.cstmt.getDouble(parameterName);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.cstmt.getFloat(parameterIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.cstmt.getFloat(parameterName);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.cstmt.getInt(parameterIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.cstmt.getInt(parameterName);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.cstmt.getLong(parameterIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.cstmt.getLong(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.cstmt.getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.cstmt.getNCharacterStream(parameterName);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.cstmt.getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.cstmt.getNClob(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.cstmt.getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.cstmt.getNString(parameterName);
    }

    @Override
    public final Object getObject(int parameterIndex) throws SQLException {
        Object obj = this.getObjectImpl(parameterIndex);
        return this.wrapReturnObject(obj);
    }

    protected Object getObjectImpl(int parameterIndex) throws SQLException {
        return this.cstmt.getObject(parameterIndex);
    }

    @Override
    public final Object getObject(String parameterName) throws SQLException {
        Object obj = this.getObjectImpl(parameterName);
        return this.wrapReturnObject(obj);
    }

    protected Object getObjectImpl(String parameterName) throws SQLException {
        return this.cstmt.getObject(parameterName);
    }

    @Override
    public final Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        Object obj = this.getObjectImpl(parameterIndex, map);
        return this.wrapReturnObject(obj);
    }

    protected Object getObjectImpl(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.cstmt.getObject(parameterIndex, map);
    }

    @Override
    public final Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        Object obj = this.getObjectImpl(parameterName, map);
        return this.wrapReturnObject(obj);
    }

    protected Object getObjectImpl(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.cstmt.getObject(parameterName, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.cstmt.getRef(parameterIndex);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.cstmt.getRef(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.cstmt.getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.cstmt.getRowId(parameterName);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.cstmt.getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.cstmt.getSQLXML(parameterName);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.cstmt.getShort(parameterIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.cstmt.getShort(parameterName);
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.cstmt.getString(parameterIndex);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.cstmt.getString(parameterName);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.cstmt.getTime(parameterIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.cstmt.getTime(parameterName);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.cstmt.getTime(parameterIndex, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.cstmt.getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.cstmt.getTimestamp(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.cstmt.getTimestamp(parameterName);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.cstmt.getTimestamp(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.cstmt.getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.cstmt.getURL(parameterIndex);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.cstmt.getURL(parameterName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        Properties props = this.getProperties();
        String vendorDT = props.getProperty(String.format(REVERSE_MAPPING_PREFIX_FRMT, sqlType));
        if (vendorDT != null) {
            sqlType = Integer.parseInt(vendorDT);
        }
        this.cstmt.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        Properties props = this.getProperties();
        String vendorDT = props.getProperty(String.format(REVERSE_MAPPING_PREFIX_FRMT, sqlType));
        if (vendorDT != null) {
            sqlType = Integer.parseInt(vendorDT);
        }
        this.cstmt.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.cstmt.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.cstmt.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        Properties props = this.getProperties();
        String vendorDT = props.getProperty(String.format(REVERSE_MAPPING_PREFIX_FRMT, sqlType));
        if (vendorDT != null) {
            sqlType = Integer.parseInt(vendorDT);
        }
        this.cstmt.registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.cstmt.registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.cstmt.setAsciiStream(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.cstmt.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.cstmt.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.cstmt.setBigDecimal(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.cstmt.setBinaryStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.cstmt.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.cstmt.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.cstmt.setBlob(parameterName, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.cstmt.setBlob(parameterName, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.cstmt.setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.cstmt.setBoolean(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.cstmt.setByte(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.cstmt.setBytes(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.cstmt.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.cstmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.cstmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.cstmt.setClob(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.cstmt.setClob(parameterName, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.cstmt.setClob(parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.cstmt.setDate(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.cstmt.setDate(parameterName, x, cal);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.cstmt.setDouble(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.cstmt.setFloat(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.cstmt.setInt(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.cstmt.setLong(parameterName, x);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.cstmt.setNCharacterStream(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.cstmt.setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.cstmt.setNClob(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.cstmt.setNClob(parameterName, reader);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.cstmt.setNClob(parameterName, reader, length);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.cstmt.setNString(parameterName, value);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.cstmt.setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.cstmt.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.cstmt.setObject(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.cstmt.setObject(parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.cstmt.setObject(parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.cstmt.setRowId(parameterName, x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.cstmt.setSQLXML(parameterName, xmlObject);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.cstmt.setShort(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.cstmt.setString(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.cstmt.setTime(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.cstmt.setTime(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.cstmt.setTimestamp(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.cstmt.setTimestamp(parameterName, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.cstmt.setURL(parameterName, val);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.cstmt.wasNull();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.cstmt.getConnection();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    public static final class Wrapper
    implements IWrapper {
        @Override
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new BaseCallableStatementAdaptor((CallableStatement)toWrap, factory);
        }
    }
}

