/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.adaptor.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class LoggingProxyBuilder {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Logger logger;
    private final Pattern proxyFilter;
    private final InterfaceCache interfaceCache;
    private final Pattern loggingFilter;
    private final InterfaceLoggingCache loggingCache;

    private LoggingProxyBuilder(Logger aLogger, Pattern aProxyFilter, Pattern aLoggingFilter) {
        this.logger = aLogger;
        this.proxyFilter = aProxyFilter;
        this.loggingFilter = aLoggingFilter;
        this.interfaceCache = new InterfaceCache();
        this.loggingCache = new InterfaceLoggingCache();
    }

    public static Object getProxy(Logger aLogger, Pattern aProxyFilter, Pattern aLoggingFilter, Class<?> theClass, Object ... constructorArgs) throws Exception {
        Class[] parameterTypes = new Class[constructorArgs.length];
        int i = 0;
        for (Object arg : constructorArgs) {
            parameterTypes[i++] = arg.getClass();
        }
        Constructor<?> constructor = theClass.getConstructor(parameterTypes);
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalAccessException();
        }
        String className = theClass.getCanonicalName();
        String methodName = theClass.getSimpleName();
        aLogger.entering(className, methodName, constructorArgs);
        Object result = null;
        try {
            result = constructor.newInstance(constructorArgs);
        }
        catch (Exception e) {
            aLogger.throwing(className, className, e);
            throw e;
        }
        aLogger.exiting(className, methodName, result);
        return LoggingProxyBuilder.getProxy(aLogger, aProxyFilter, aLoggingFilter, result);
    }

    public static Object getProxy(Logger aLogger, Pattern aProxyFilter, Pattern aLoggingFilter, Class<?> theClass) throws Exception {
        return LoggingProxyBuilder.getProxy(aLogger, aProxyFilter, aLoggingFilter, theClass, new Object[0]);
    }

    public static Object getProxy(Logger aLogger, Pattern aProxyFilter, Pattern aLoggingFilter, Object o) throws Exception {
        return new LoggingProxyBuilder(aLogger, aProxyFilter, aLoggingFilter).makeProxy(o);
    }

    private Object makeProxy(Object o) throws Exception {
        Class<?> klass = o.getClass();
        Object rc = o;
        Class<?>[] interfaces = this.filterInterfaces(klass);
        if (interfaces.length > 0) {
            NonLoggingInvocationHandler handler = (Boolean)this.loggingCache.get(klass) != false ? new LoggingInvocationHandler(o) : new NonLoggingInvocationHandler(o);
            rc = Proxy.newProxyInstance(klass.getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return rc;
    }

    private HashSet<Class<?>> getAllInterfaces(Class<?> aClass) {
        HashSet interfaces = new HashSet();
        if (aClass != null) {
            for (Class<?> i : aClass.getInterfaces()) {
                interfaces.add(i);
                interfaces.addAll(this.getAllInterfaces(i));
            }
            interfaces.addAll(this.getAllInterfaces(aClass.getSuperclass()));
        }
        return interfaces;
    }

    private Class<?>[] filterInterfaces(Class<?> aClass) {
        Class[] interfaces = (Class[])this.interfaceCache.get(aClass);
        if (interfaces == null) {
            HashSet<Class<?>> allInterfaces = this.getAllInterfaces(aClass);
            if (allInterfaces.size() > 0) {
                boolean isProxyMatch = false;
                boolean isLoggingMatch = false;
                for (Class<?> i : allInterfaces) {
                    String iName = i.getName();
                    if (!isProxyMatch && this.proxyFilter.matcher(iName).matches()) {
                        isProxyMatch = true;
                    }
                    if (!isLoggingMatch && this.loggingFilter.matcher(iName).matches()) {
                        isLoggingMatch = true;
                    }
                    if (!isLoggingMatch || !isProxyMatch) continue;
                    break;
                }
                if (isProxyMatch) {
                    interfaces = allInterfaces.toArray(EMPTY_CLASS_ARRAY);
                    this.loggingCache.put(aClass, isLoggingMatch);
                } else {
                    interfaces = EMPTY_CLASS_ARRAY;
                }
            }
            this.interfaceCache.put(aClass, interfaces);
        }
        return interfaces;
    }

    private class LoggingInvocationHandler
    extends NonLoggingInvocationHandler {
        private static final String ELAPSED_FORMAT = "ELAPSED %d ms";
        private String proxiedClassName;
        private final boolean objectIsProxy;

        protected LoggingInvocationHandler(Object proxiedObject) {
            super(proxiedObject);
            Class<?> c = this.proxied.getClass();
            this.objectIsProxy = Proxy.isProxyClass(c);
            if (!this.objectIsProxy) {
                this.proxiedClassName = c.getCanonicalName() + this.getId(proxiedObject);
            }
        }

        private String getId(Object o) {
            return "@" + Integer.toHexString(System.identityHashCode(o));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (this.objectIsProxy) {
                this.proxiedClassName = method.getDeclaringClass().getCanonicalName() + this.getId(proxy);
            }
            String methodName = method.getName();
            LoggingProxyBuilder.this.logger.entering(this.proxiedClassName, methodName, args);
            try {
                try {
                    long start = System.currentTimeMillis();
                    result = method.invoke(this.proxied, args);
                    long elapsed = System.currentTimeMillis() - start;
                    LoggingProxyBuilder.this.logger.logp(Level.FINER, this.proxiedClassName, methodName, String.format(ELAPSED_FORMAT, elapsed));
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (SQLException e) {
                this.logSQLException(this.proxiedClassName, methodName, e);
                throw e;
            }
            catch (Exception e) {
                LoggingProxyBuilder.this.logger.throwing(this.proxiedClassName, methodName, e);
                throw e;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                LoggingProxyBuilder.this.logger.exiting(this.proxiedClassName, methodName);
            } else {
                LoggingProxyBuilder.this.logger.exiting(this.proxiedClassName, methodName, result);
            }
            if (result != null) {
                result = LoggingProxyBuilder.this.makeProxy(result);
            }
            return result;
        }

        private void logSQLException(String className, String methodName, SQLException e) {
            String state = null;
            try {
                state = String.valueOf(e.getSQLState());
            }
            catch (Exception e2) {
                LoggingProxyBuilder.this.logger.log(Level.FINER, "logging SQLException, getting state: ");
                LoggingProxyBuilder.this.logger.log(Level.FINER, e2.getMessage());
                state = "";
            }
            String code = null;
            try {
                code = String.valueOf(e.getErrorCode());
            }
            catch (Exception e2) {
                LoggingProxyBuilder.this.logger.log(Level.FINER, "logging SQLException, getting error code: ");
                LoggingProxyBuilder.this.logger.log(Level.FINER, e2.getMessage());
                state = "";
            }
            LoggingProxyBuilder.this.logger.logp(Level.FINER, className, methodName, "THROW SQLException (SQLstate:" + state + ", ErrorCode:" + code + ")", e);
        }
    }

    private class NonLoggingInvocationHandler
    implements InvocationHandler {
        protected final Object proxied;

        protected NonLoggingInvocationHandler(Object proxiedObject) {
            this.proxied = proxiedObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                result = method.invoke(this.proxied, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (result != null) {
                result = LoggingProxyBuilder.this.makeProxy(result);
            }
            return result;
        }
    }

    private static final class InterfaceLoggingCache
    extends HashMap<Class<?>, Boolean> {
        private InterfaceLoggingCache() {
        }
    }

    private static final class InterfaceCache
    extends HashMap<Class<?>, Class<?>[]> {
        private InterfaceCache() {
        }
    }
}

