/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.jdbc.cognos.adaptor.HiveSchemaResultSet;

public class HiveDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    public HiveDatabaseMetadataAdaptor(DatabaseMetaData obj, AdaptorFactory factory) {
        super(obj, factory);
    }

    protected ResultSet getCatalogsImpl() throws SQLException {
        ResultSet catalogs = this.dmd.getCatalogs();
        while (catalogs.next()) {
        }
        return catalogs;
    }

    protected ResultSet getSchemasImpl() throws SQLException {
        ResultSet schemas = this.dmd.getSchemas();
        return new HiveSchemaResultSet(this.getCatalogName(), schemas);
    }

    protected String getCatalogTermImpl() throws SQLException {
        return null;
    }

    protected ResultSet getTablesImpl(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String catalogName = this.getCatalogName();
        return this.dmd.getTables(catalogName, catalogName, tableNamePattern, types);
    }

    protected ResultSet getColumnsImpl(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String catalogName = this.getCatalogName();
        return this.dmd.getColumns(catalogName, schemaPattern, tableNamePattern, columnNamePattern);
    }

    private String getCatalogName() {
        return this.factory.getAdaptorProperties().getProperty("databaseName");
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        return 0;
    }

    protected int getDatabaseMinorVersionImpl() throws SQLException {
        return 8;
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new HiveDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

