/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Hive2ConnectionAdaptor
extends BaseConnectionAdaptor {
    public Hive2ConnectionAdaptor(Connection connection, AdaptorFactory factory) {
        super(connection, factory);
    }

    public void setConnectionURL(String connectionURL) {
        super.setConnectionURL(connectionURL);
        URI u = URI.create(connectionURL.substring("jdbc:".length()));
        int fromIndex = u.getPath().lastIndexOf(47) + 1;
        int endIndex = u.getPath().indexOf(59, fromIndex);
        String databaseName = null;
        databaseName = endIndex == -1 ? u.getPath().substring(fromIndex) : u.getPath().substring(fromIndex, endIndex);
        this.factory.getAdaptorProperties().setProperty("databaseName", databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdaptorMethodOverride
    public String getQueryPlan(String query) throws SQLException {
        String plan = null;
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = this.getConnection().createStatement();
            result = stmt.executeQuery("EXPLAIN " + query);
            StringBuilder builder = new StringBuilder();
            if (result.getMetaData().getColumnCount() > 0) {
                while (result.next()) {
                    builder.append(result.getString(1));
                    builder.append("\n");
                }
            }
            plan = builder.toString();
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return plan;
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new Hive2ConnectionAdaptor((Connection)toWrap, factory);
        }
    }
}

