/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.AbstractConnectionProperty;
import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.HttpProcessor;
import com.ibm.cognos.jdbc.twc.QueryStatus;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCResultSet;
import com.ibm.cognos.jdbc.twc.TWCResultSetMetaData;
import com.ibm.cognos.jdbc.twc.avro.AvroRowWalker;
import com.ibm.cognos.jdbc.twc.avro.AvroRowWriter;
import com.ibm.cognos.jdbc.twc.csv.CSVParser;
import com.ibm.cognos.jdbc.twc.csv.CSVSchema;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.apache.commons.compress.utils.IOUtils;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserWrapper;
import com.ibm.cognos.jdbc.twc.univocity.parsers.common.DataProcessingException;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class CacheableHttpCSVToAvroProcessor
extends HttpProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheableHttpCSVToAvroProcessor.class);
    private final CloseableHttpClient httpClient;
    private final CacheManager cacheMgr;

    CacheableHttpCSVToAvroProcessor(CloseableHttpClient theHttpClient, CacheManager cacheManager) {
        this.httpClient = theHttpClient;
        this.cacheMgr = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TWCResultSet execute(String connectionId, Statement statement, QueryStatus status, TWCConnectionString connStr, TWCSQLParserWrapper parser) throws Exception {
        boolean success = false;
        HttpProcessor.ResponseEntityStruct responseEntityStruct = null;
        FosStruct[] fosStruct = new FosStruct[1];
        String[] avroId = new String[]{null};
        String[] avroPath = new String[]{null};
        AvroRowWriter avroWriter = null;
        long[] rowCount = new long[]{0L};
        try {
            Object object;
            CacheManager.CacheEntry cacheEntry = this.constructCacheEntry(parser);
            TWCResultSet twcRS = this.retrieveCachedResultSet(connectionId, status.getRequestId(), statement, cacheEntry, avroId, avroPath, rowCount, parser);
            if (null != twcRS) {
                TWCResultSet tWCResultSet = twcRS;
                return tWCResultSet;
            }
            CSVSchema csvSchema = CSVParser.toCSVSchema(parser.getCommonColumns(), parser.getBoundedTables());
            avroWriter = this.constructAvroWriter(connectionId, status, csvSchema, avroId, avroPath, fosStruct);
            for (String uriSTR : parser.getURIs()) {
                boolean[] requiresPagination = new boolean[]{false};
                if (status.isNotRunning()) {
                    TWCResultSet tWCResultSet = null;
                    return tWCResultSet;
                }
                URI uri = HttpProcessor.constructURI(uriSTR, connStr);
                try {
                    LOGGER.info("QueryId: {} - Accessing '{}' for results.", (Object)status.getRequestId(), (Object)uriSTR);
                    responseEntityStruct = this.executeRequest(this.httpClient, uri, requiresPagination, uriSTR, connStr.isStrictMode());
                    CSVParser csvParser = new CSVParser(csvSchema, parser.getTreatColumnsAs(), avroWriter, connStr.isStrictMode());
                    this.parseResponse(csvParser, responseEntityStruct, avroWriter, uriSTR);
                    while (requiresPagination[0]) {
                        if (status.isNotRunning()) {
                            TWCResultSet tWCResultSet = null;
                            return tWCResultSet;
                        }
                        LOGGER.info("QueryId: {} - Accessing with pagination '{}' for results.", (Object)status.getRequestId(), (Object)uriSTR);
                        responseEntityStruct = this.executeRequest(this.httpClient, uri, requiresPagination, uriSTR, connStr.isStrictMode());
                        this.parseResponse(csvParser, responseEntityStruct, avroWriter, uriSTR);
                    }
                    rowCount[0] = rowCount[0] + csvParser.getRowCount();
                }
                finally {
                    if (null == responseEntityStruct) continue;
                    responseEntityStruct.closeQuietly();
                }
            }
            if (status.isNotRunning()) {
                object = null;
                return object;
            }
            LOGGER.info("QueryId: {} - Constructing result set - Number of retrieved rows: {}", (Object)status.getRequestId(), (Object)rowCount[0]);
            twcRS = this.constructResultSet(connectionId, status.getRequestId(), statement, avroId, avroPath, rowCount[0], csvSchema, parser);
            if (null != cacheEntry && rowCount[0] > 0L) {
                LOGGER.info("QueryId: {} - Requesting avro result files to be cacheable.", (Object)status.getRequestId());
                this.cacheAvroResultFile(connectionId, avroId, avroPath, cacheEntry, rowCount[0]);
            }
            success = true;
            object = twcRS;
            return object;
        }
        finally {
            if (null != avroWriter) {
                try {
                    avroWriter.close();
                }
                catch (Exception exception) {}
            }
            if (null != fosStruct[0]) {
                fosStruct[0].closeQuietly();
            }
            if (!success || rowCount[0] == 0L) {
                LOGGER.info("QueryId: {} - Deregistering avro result files.", (Object)status.getRequestId());
                this.deregisterAvroFiles(connectionId, status.getRequestId(), avroId);
            }
        }
    }

    private CacheManager.CacheEntry constructCacheEntry(TWCSQLParserWrapper parser) {
        if (AbstractConnectionProperty.SchemaValues.FORECAST.getValue().equals(parser.getSchema().getName().value())) {
            return null;
        }
        List<String> tables = parser.getBoundedTables().values().stream().map(bt -> bt.getTable().getName()).collect(Collectors.toList());
        List<String> postalCodes = parser.getPostalCodes();
        List<LocalDate> dateValues = parser.getDateValues();
        return tables.isEmpty() || null == postalCodes || postalCodes.isEmpty() || null == dateValues || dateValues.isEmpty() ? null : new CacheManager.CacheEntry(tables, postalCodes, dateValues);
    }

    private AvroRowWriter constructAvroWriter(String connId, QueryStatus status, CSVSchema csvSchema, String[] avroIdArr, String[] avroPathArr, FosStruct[] fosStruct) throws SQLException {
        AvroRowWriter avroWriter;
        String[] avroIdAndAvroPath = this.cacheMgr.registerAvroFile(connId, status.getRequestId(), csvSchema);
        String avroId = avroIdAndAvroPath[0];
        Path avroPath = Paths.get(avroIdAndAvroPath[1], new String[0]);
        avroIdArr[0] = avroId;
        avroPathArr[0] = avroPath.toString();
        File avroF = avroPath.toFile();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(avroF);
            avroWriter = new AvroRowWriter(csvSchema, fos);
            fosStruct[0] = new FosStruct(fos);
        }
        catch (Exception e) {
            IOUtils.closeQuietly(fos);
            throw new SQLException(TWCMessageUtil.getMessage("0041"), e);
        }
        return avroWriter;
    }

    private void parseResponse(CSVParser csvParser, HttpProcessor.ResponseEntityStruct responseEntityStruct, AvroRowWriter avroWriter, String uri) throws SQLException {
        if (null == responseEntityStruct) {
            return;
        }
        try {
            csvParser.parse(responseEntityStruct.getEntity().getContent(), StandardCharsets.UTF_8.toString());
            avroWriter.flush();
        }
        catch (IllegalStateException ise) {
            throw new SQLException(String.format("Request Failed - Status Code: %d - URI: '%s'", 200, uri));
        }
        catch (DataProcessingException dpe) {
            throw new SQLException(TWCMessageUtil.getMessage("0040", dpe.getMessage()), dpe);
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0039"), e);
        }
        finally {
            responseEntityStruct.closeQuietly();
        }
    }

    private void deregisterAvroFiles(String connId, String requestId, String[] avroIdArr) {
        for (String avroId : avroIdArr) {
            this.cacheMgr.deregisterAvroFile(connId, requestId, avroId);
        }
    }

    private void cacheAvroResultFile(String connId, String[] avroIdArr, String[] avroPathArr, CacheManager.CacheEntry cacheEntry, long rowCount) {
        for (int i = 0; i < avroIdArr.length; ++i) {
            String avroId = avroIdArr[i];
            String avroPath = avroPathArr[i];
            long size = Paths.get(avroPath, new String[0]).toFile().length();
            this.cacheMgr.cacheAvroFile(connId, avroId, cacheEntry, size, rowCount);
        }
    }

    private TWCResultSet retrieveCachedResultSet(String connId, String requestId, Statement statement, CacheManager.CacheEntry cacheEntry, String[] avroId, String[] avroPath, long[] rowCount, TWCSQLParserWrapper parser) throws SQLException {
        if (null == cacheEntry) {
            return null;
        }
        LOGGER.info("QueryId: {} - Search for a compatible cached avro file", (Object)requestId);
        Object[] idPathRowsCSVSchemaTuple = this.cacheMgr.retrieveCachedAvroFile(connId, cacheEntry, requestId);
        if (null != idPathRowsCSVSchemaTuple[0] && null != idPathRowsCSVSchemaTuple[1] && null != idPathRowsCSVSchemaTuple[2] && null != idPathRowsCSVSchemaTuple[3]) {
            avroId[0] = (String)idPathRowsCSVSchemaTuple[0];
            avroPath[0] = (String)idPathRowsCSVSchemaTuple[1];
            rowCount[0] = (Long)idPathRowsCSVSchemaTuple[2];
            CSVSchema csvSchema = (CSVSchema)idPathRowsCSVSchemaTuple[3];
            LOGGER.info("QueryId: {} - Compatible avro file found.", (Object)requestId);
            return this.constructResultSet(connId, requestId, statement, avroId, avroPath, rowCount[0], csvSchema, parser);
        }
        LOGGER.info("QueryId: {} - No compatible cached avro file found.", (Object)requestId);
        return null;
    }

    private TWCResultSet constructResultSet(String connId, String requestId, Statement statement, String[] avroIdArr, String[] avroPathArr, long rowCount, CSVSchema csvSchema, TWCSQLParserWrapper parser) throws SQLException {
        TWCResultSet twcRS;
        boolean errorThrown = false;
        AvroRowWalker rowWalker = null;
        try {
            List<BoundedColumn> boundedColumns = parser.getBoundedColumns();
            TWCResultSetMetaData rsMeta = TWCResultSetMetaData.fromBoundedColumns(parser.getCatalog(), parser.getSchema(), boundedColumns);
            int[] projectedColsMapping = csvSchema.boundedColumnsMapping(boundedColumns);
            Map<String, Integer> csvColsMapping = csvSchema.csvColumnNames2RowIdxs();
            if (rowCount == 0L) {
                List emptyResult = Collections.emptyList();
                twcRS = new TWCResultSet(requestId, connId, rsMeta, emptyResult.iterator(), statement, rowWalker, parser, projectedColsMapping, csvColsMapping, parser.getProjectedLiterals(), parser.getProjectedLiteralsOrdinalPositions(), this.cacheMgr, Arrays.asList(avroIdArr));
            } else {
                rowWalker = new AvroRowWalker(Arrays.asList(avroPathArr), csvSchema);
                twcRS = new TWCResultSet(requestId, connId, rsMeta, rowWalker.iterator(), statement, rowWalker, parser, projectedColsMapping, csvColsMapping, parser.getProjectedLiterals(), parser.getProjectedLiteralsOrdinalPositions(), this.cacheMgr, Arrays.asList(avroIdArr));
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e) {
            errorThrown = true;
            throw new SQLException(TWCMessageUtil.getMessage("0046", "Failed to construct avro-row-walker."), e);
        }
        finally {
            if (errorThrown && null != rowWalker) {
                try {
                    rowWalker.close();
                }
                catch (Exception exception) {}
            }
        }
        return twcRS;
    }

    private static final class FosStruct {
        private final FileOutputStream fos;

        private FosStruct(FileOutputStream fileOut) {
            this.fos = fileOut;
        }

        void closeQuietly() {
            IOUtils.closeQuietly(this.fos);
        }
    }
}

