/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;
import java.util.Objects;

class ColumnInfo
implements TWCMessageKeys {
    private static final String EMPTY_STR = "";
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final String columnAlias;
    private final int displaySize;
    private final Column.Datatype type;
    private final String columnTypeName;
    private final int columnTypeJDBC;
    private final int precision;
    private final int scale;
    private final NullConstraint nullConstraint;
    private final boolean signed;
    private final boolean searchable;

    private ColumnInfo(Column.Datatype dataType, int precision, int scale, NullConstraint nullConstraint, boolean signed, String catalog, String schema, String table, String columnName, String columnAlias, int displaySize, boolean isSearchable) {
        if (Objects.isNull((Object)dataType)) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "dataType"));
        }
        if (Objects.isNull((Object)nullConstraint)) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "nullConstraint"));
        }
        if (Objects.isNull(catalog)) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "catalog"));
        }
        if (Objects.isNull(schema)) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "schema"));
        }
        if (Objects.isNull(table)) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "table"));
        }
        if (Objects.isNull(columnName) || columnName.trim().isEmpty()) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0007", "columnName"));
        }
        this.type = dataType;
        this.precision = precision;
        this.scale = scale;
        this.nullConstraint = nullConstraint;
        this.signed = signed;
        this.catalogName = catalog;
        this.schemaName = schema;
        this.tableName = table;
        this.columnName = columnName;
        this.columnAlias = null == columnAlias || columnAlias.isEmpty() ? columnName : columnAlias;
        this.displaySize = displaySize;
        this.searchable = isSearchable;
        this.columnTypeName = MetadataUtils.inferDatatypeName(dataType, precision, scale, displaySize);
        this.columnTypeJDBC = MetadataUtils.inferDatatypeAsJDBC(this.type);
    }

    public Column.Datatype getDataType() {
        return this.type;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public int getColumnTypeJDBC() {
        return this.columnTypeJDBC;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public NullConstraint getNullContraint() {
        return this.nullConstraint;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    static class Builder {
        Column.Datatype theType;
        int thePrecision = -1;
        int theScale = -1;
        NullConstraint theNullConstraint;
        boolean theSigned = false;
        String theCatalog = "";
        String theSchema = "";
        String theTable = "";
        String theColumnName = "";
        String theColumnAlias = "";
        int theDisplaySize = -1;
        boolean theSearchable = true;

        Builder() {
        }

        public Builder setDataType(Column.Datatype type) {
            this.theType = type;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.thePrecision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.theScale = scale;
            return this;
        }

        public Builder setNullConstraint(NullConstraint nullConstraint) {
            this.theNullConstraint = nullConstraint;
            return this;
        }

        public Builder setSigned(boolean signed) {
            this.theSigned = signed;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.theCatalog = catalog;
            return this;
        }

        public Builder setSchema(String schema) {
            this.theSchema = schema;
            return this;
        }

        public Builder setTable(String table) {
            this.theTable = table;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.theColumnName = columnName;
            return this;
        }

        public Builder setColumnAlias(String columnAlias) {
            this.theColumnAlias = columnAlias;
            return this;
        }

        public Builder setDisplaySize(int displaySize) {
            this.theDisplaySize = displaySize;
            return this;
        }

        public Builder setSearchable(boolean isSearchable) {
            this.theSearchable = isSearchable;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.theType, this.thePrecision, this.theScale, this.theNullConstraint, this.theSigned, this.theCatalog, this.theSchema, this.theTable, this.theColumnName, this.theColumnAlias, this.theDisplaySize, this.theSearchable);
        }
    }

    public static enum NullConstraint {
        NO_NULLS(0),
        NULLABLE(1),
        NULLSUNKNOWN(2);

        private final int constraint;

        private NullConstraint(int constraint) {
            this.constraint = constraint;
        }

        public int getNullConstraint() {
            return this.constraint;
        }
    }
}

