/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.ConnectionProperties;
import com.ibm.cognos.jdbc.twc.QueryProcessor;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.org.apache.http.Header;
import com.ibm.cognos.jdbc.twc.org.apache.http.HttpEntity;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.CloseableHttpResponse;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.HttpGet;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.HttpUriRequest;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.utils.HttpClientUtils;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cognos.jdbc.twc.org.apache.http.protocol.BasicHttpContext;
import com.ibm.cognos.jdbc.twc.org.apache.http.util.EntityUtils;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

abstract class HttpProcessor
implements QueryProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProcessor.class);
    protected static final String UNAUTHORIZED_ERROR_FORMATTER = "Unauthorized - Status Code: %d - URI '%s'";
    protected static final String REQUEST_ERROR_FORMATTER = "Request Failed - Status Code: %d - URI: '%s'";
    protected static final String REQUEST_ERROR_REASON_FORMATTER = "Request Failed - Status Code: %d - URI: '%s' %nReason: %s";
    private static final String X_NEXT_TOKEN_HEADER = "X-Next-Token";
    private static final int ONE_MB = 0x100000;
    private static final String QUESTIONMARK_STR = "?";
    private static final String AMPERSAND_STR = "&";
    private static final String EQUAL_STR = "=";

    HttpProcessor() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResponseEntityStruct executeRequest(CloseableHttpClient httpClient, URI uri, boolean[] requiresPagination, String uriSTR, boolean strictMode) throws SQLException {
        boolean fail = false;
        ResponseEntityStruct responseEntityStruct = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        try {
            HttpGet httpGet = new HttpGet(uri);
            if (requiresPagination[0]) {
                httpGet.addHeader(X_NEXT_TOKEN_HEADER, "true");
            }
            BasicHttpContext basicContext = new BasicHttpContext();
            response = httpClient.execute((HttpUriRequest)httpGet, basicContext);
            int statusCode = response.getStatusLine().getStatusCode();
            Header nextTokenHeader = response.getFirstHeader(X_NEXT_TOKEN_HEADER);
            entity = response.getEntity();
            if (200 == statusCode) {
                requiresPagination[0] = null != nextTokenHeader && "true".compareToIgnoreCase(nextTokenHeader.getValue()) == 0;
                responseEntityStruct = new ResponseEntityStruct(response, entity);
            } else {
                if (401 == statusCode) {
                    LOGGER.error("Unauthorized - Request '{}' failed with status code: {}", (Object)uriSTR, (Object)statusCode);
                    throw new SQLException(String.format(UNAUTHORIZED_ERROR_FORMATTER, statusCode, uriSTR));
                }
                SQLException t = this.handleErroneousResponse(entity, statusCode, uriSTR, strictMode);
                if (null != t) {
                    LOGGER.error("Request '{}' failed with status code: {}", (Object)uriSTR, (Object)statusCode);
                    throw t;
                }
                requiresPagination[0] = false;
            }
            if (!fail) return responseEntityStruct;
        }
        catch (IOException cpe) {
            try {
                fail = true;
                requiresPagination[0] = false;
                throw HttpProcessor.stripOutApiKeyFromException(cpe);
                catch (SQLException sqle) {
                    fail = true;
                    requiresPagination[0] = false;
                    throw sqle;
                }
            }
            catch (Throwable throwable) {
                if (!fail) throw throwable;
                EntityUtils.consumeQuietly(entity);
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly(entity);
        HttpClientUtils.closeQuietly(response);
        return responseEntityStruct;
    }

    static SQLException stripOutApiKeyFromException(Exception e) {
        int apiKeyIndx;
        String message = e.getMessage();
        if (null != message && (apiKeyIndx = message.indexOf("&apiKey")) != -1) {
            message = message.substring(0, apiKeyIndx);
        }
        return null == message ? new SQLException(e) : new SQLException(message, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SQLException handleErroneousResponse(HttpEntity entity, int statusCode, String uri, boolean strictMode) {
        try (BufferedInputStream bis = new BufferedInputStream(entity.getContent());){
            byte[] byteArray = new byte[524288];
            int length = bis.read(byteArray);
            String reason = new String(byteArray, 0, length, StandardCharsets.UTF_8);
            if (reason.contains("postalKey") && !strictMode) {
                SQLException sQLException2 = null;
                return sQLException2;
            }
            SQLException sQLException = new SQLException(String.format(REQUEST_ERROR_REASON_FORMATTER, statusCode, uri, reason));
            return sQLException;
        }
        catch (Exception e) {
            LOGGER.info("Failed parsing json payload from erroneous response.", e);
            return new SQLException(String.format(REQUEST_ERROR_FORMATTER, statusCode, uri));
        }
    }

    static URI constructURI(String uriSTR, TWCConnectionString connectionString) throws SQLException {
        try {
            String apiKey = uriSTR.contains(Schema.Name.HISTORICAL.name().toLowerCase()) ? connectionString.getHistoricalKey() : connectionString.getForecastKey();
            String delimiter = uriSTR.contains(AMPERSAND_STR) ? AMPERSAND_STR : QUESTIONMARK_STR;
            String sb = uriSTR + delimiter + ConnectionProperties.PASSWORD_PROPERTY.getQueryParameterKey() + EQUAL_STR + apiKey;
            return new URI(sb);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected static final class ResponseEntityStruct {
        private final CloseableHttpResponse response;
        private final HttpEntity entity;

        private ResponseEntityStruct(CloseableHttpResponse theResponse, HttpEntity theEntity) {
            this.response = theResponse;
            this.entity = theEntity;
        }

        HttpEntity getEntity() {
            return this.entity;
        }

        void closeQuietly() {
            EntityUtils.consumeQuietly(this.entity);
            HttpClientUtils.closeQuietly(this.response);
        }
    }
}

