/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.HttpClientMonitoringTask;
import com.ibm.cognos.jdbc.twc.HttpProcessor;
import com.ibm.cognos.jdbc.twc.QueryMonitoringStruct;
import com.ibm.cognos.jdbc.twc.QueryResult;
import com.ibm.cognos.jdbc.twc.QueryTaskFactory;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCStatement;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import com.ibm.cognos.jdbc.twc.org.apache.http.HttpEntity;
import com.ibm.cognos.jdbc.twc.org.apache.http.HttpHost;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.config.RequestConfig;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.CloseableHttpResponse;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.HttpGet;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.methods.HttpUriRequest;
import com.ibm.cognos.jdbc.twc.org.apache.http.client.utils.HttpClientUtils;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.HttpClients;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.ibm.cognos.jdbc.twc.org.apache.http.protocol.BasicHttpContext;
import com.ibm.cognos.jdbc.twc.org.apache.http.util.EntityUtils;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import java.net.URI;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class QueryExecutor
implements TWCMessageKeys {
    private static final String NOPROXY = "NOPROXY";
    static final Logger LOGGER = LoggerFactory.getLogger(QueryExecutor.class);
    static final int SCALE_FACTOR = 5;
    static final int SIXTY_SECONDS = (int)TimeUnit.SECONDS.toSeconds(60L);
    static final int TIMEOUT_IN_MILLIS = (int)TimeUnit.MINUTES.toMillis(5L);
    private final AtomicBoolean closed;
    private PoolingHttpClientConnectionManager httpClientConnectionMgr;
    private CloseableHttpClient httpClient;
    private ExecutorService dataExecutor;
    private final ConcurrentMap<String, QueryMonitoringStruct> ongoingQueries;
    private final int maxRunningTasks;
    private final int maxPendingTasks;
    private ScheduledExecutorService scheduler;
    private final QueryTaskFactory queryTaskFactory;
    private int timeoutMillis = TIMEOUT_IN_MILLIS;

    QueryExecutor(int parallelism, QueryTaskFactory taskFactory) {
        this(parallelism, taskFactory, NOPROXY, -1, SIXTY_SECONDS);
    }

    QueryExecutor(int parallelism, QueryTaskFactory taskFactory, String proxyHost, Integer proxyPort, int queryTimeout) {
        int queryTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(queryTimeout);
        this.queryTaskFactory = Objects.requireNonNull(taskFactory, TWCMessageUtil.getMessage("0007", "taskFactory"));
        if (parallelism <= 0) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0074", "parallelism"));
        }
        this.httpClientConnectionMgr = new PoolingHttpClientConnectionManager();
        this.httpClientConnectionMgr.setMaxTotal(parallelism);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(queryTimeoutMillis).setConnectTimeout(queryTimeoutMillis).setConnectionRequestTimeout(queryTimeoutMillis).build();
        if (!proxyHost.equalsIgnoreCase(NOPROXY)) {
            HttpHost proxy = new HttpHost(proxyHost, (int)proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            this.httpClient = HttpClients.custom().setConnectionManager(this.httpClientConnectionMgr).setDefaultRequestConfig(requestConfig).setRoutePlanner(routePlanner).build();
        } else {
            this.httpClient = HttpClients.custom().setConnectionManager(this.httpClientConnectionMgr).setDefaultRequestConfig(requestConfig).build();
        }
        this.maxRunningTasks = parallelism;
        this.maxPendingTasks = 4 * parallelism;
        this.dataExecutor = Executors.newFixedThreadPool(parallelism, r -> {
            Thread t = new Thread(r);
            t.setName("TWCDataExecutor.DataExecutor-" + t.getId());
            return t;
        });
        this.ongoingQueries = new ConcurrentHashMap<String, QueryMonitoringStruct>();
        this.scheduler = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("TWCQueryExecutor.MonitoringScheduler-" + t.getId());
            return t;
        });
        HttpClientMonitoringTask r2 = new HttpClientMonitoringTask(this.httpClientConnectionMgr);
        this.scheduler.scheduleWithFixedDelay(r2, 0L, 1L, TimeUnit.MINUTES);
        this.closed = new AtomicBoolean();
    }

    private SQLException validateQueryExecute(String queryId, String connectionId, Server metadata, String sql, TWCStatement statement, TWCConnectionString connStr, CacheManager cacheMgr) {
        if (null == queryId) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "queryId"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_QUERY_ID.getErrorCode());
        }
        if (null == connectionId) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "connectionId"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_CONNECTION_ID.getErrorCode());
        }
        if (null == metadata) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "metadata"), TWCSQLState.INVALID_SQL.getState(), TWCSQLErrorCode.NULL_METADATA.getErrorCode());
        }
        if (null == sql) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "SQL query"), TWCSQLState.INVALID_SQL.getState(), TWCSQLErrorCode.NULL_SQL_STATEMENT.getErrorCode());
        }
        if (null == statement) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "statement"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_STATEMENT.getErrorCode());
        }
        if (null == connStr) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "connStr"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_CONNECTION_STRING.getErrorCode());
        }
        if (null == cacheMgr) {
            return new SQLException(TWCMessageUtil.getMessage("0007", "cacheMgr"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_CACHE_MANAGER.getErrorCode());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    QueryResult executeQuery(String queryId, String connectionId, Server twcMD, String sql, TWCStatement statement, TWCConnectionString connStr, CacheManager cacheMgr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String executePlainRequest(String uriSTR, TWCConnectionString connStr) throws SQLException {
        String result;
        block20: {
            if (this.closed.get()) {
                throw new SQLException(TWCMessageUtil.getMessage("0042"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.QUERY_EXECUTOR_CLOSED.getErrorCode());
            }
            if (null == uriSTR) {
                throw new SQLException(TWCMessageUtil.getMessage("0007", "uriSTR"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_URI.getErrorCode());
            }
            if (null == connStr) {
                throw new SQLException(TWCMessageUtil.getMessage("0007", "connStr"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.NULL_CONNECTION_STRING.getErrorCode());
            }
            try {
                URI uri = HttpProcessor.constructURI(uriSTR, connStr);
                HttpGet httpGet = new HttpGet(uri);
                BasicHttpContext basicContext = new BasicHttpContext();
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, basicContext);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (200 == statusCode) {
                        result = EntityUtils.toString(entity);
                        break block20;
                    }
                    if (401 == statusCode) {
                        LOGGER.error("Unauthorized - Request '{}' failed with status code: {}", (Object)uriSTR, (Object)statusCode);
                        EntityUtils.consumeQuietly(entity);
                        throw new SQLException(TWCMessageUtil.getMessage("0084", statusCode, uriSTR));
                    }
                    LOGGER.error("Request '{}' failed with status code: {}", (Object)uriSTR, (Object)statusCode);
                    EntityUtils.consumeQuietly(entity);
                    throw new SQLException(TWCMessageUtil.getMessage("0083", statusCode, uriSTR));
                }
            }
            catch (SQLException sqle) {
                throw sqle;
            }
            catch (Exception e) {
                LOGGER.error(String.format("Request '%s' failed.", uriSTR), e);
                throw new SQLException(TWCMessageUtil.getMessage("0085", uriSTR), e);
            }
        }
        return result;
    }

    void cancelQuery(String queryId) throws SQLException {
        if (this.closed.get()) {
            throw new SQLException(TWCMessageUtil.getMessage("0042"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.QUERY_EXECUTOR_ERROR.getErrorCode());
        }
        if (null == queryId) {
            return;
        }
        this.ongoingQueries.computeIfPresent(queryId, (uuid, monitoringStruct) -> {
            monitoringStruct.getStatus().start();
            monitoringStruct.getStatus().fail(new SQLException(TWCMessageUtil.getMessage("0047"), TWCSQLState.TRANSACTION_STATE.getState(), TWCSQLErrorCode.CANCELLED.getErrorCode()));
            monitoringStruct.getPromise().cancel(false);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.closed.compareAndSet(false, true)) {
            boolean schedulerShutdown = false;
            boolean dataExecutorShutdown = false;
            try {
                long wait = TimeUnit.SECONDS.toNanos(30L);
                long begin = System.nanoTime();
                this.dataExecutor.shutdown();
                this.scheduler.shutdown();
                dataExecutorShutdown = this.dataExecutor.awaitTermination(wait, TimeUnit.NANOSECONDS);
                wait = System.nanoTime() - begin;
                if (wait > 0L) {
                    schedulerShutdown = this.scheduler.awaitTermination(wait, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (!dataExecutorShutdown) {
                    this.dataExecutor.shutdownNow();
                }
                if (!schedulerShutdown) {
                    this.scheduler.shutdownNow();
                }
                HttpClientUtils.closeQuietly(this.httpClient);
            }
            this.dataExecutor = null;
            this.scheduler = null;
            this.httpClient = null;
            this.httpClientConnectionMgr = null;
        }
    }

    int getPendingAndRunning() {
        return this.ongoingQueries.size();
    }

    void setTimeoutMillis(int timeout) {
        this.timeoutMillis = timeout;
    }
}

