/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.ConnectionProperties;
import com.ibm.cognos.jdbc.twc.ConnectionProperty;
import com.ibm.cognos.jdbc.twc.TWCDriver;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;

final class TWCConnectionString {
    private static final String JDBC_CONNECTION_STR_PREFIX = "jdbc:twc://";
    private static final String SEMICOLON_STR = ";";
    private static final String EQUAL_STR = "=";
    private static final String EMPTY_STR = "";
    private static final String COMMA_STR = ",";
    private static final String PRODUCTS_STR = "products";
    private static final String FORWARD_SLASH_STR = "/";
    private static final String DOUBLE_FORWARD_SLASH_STR = "//";
    private final URI uri;
    private final Properties properties;
    private final String catalog;
    private final String schema;
    private final int maxStatements;
    private final String language;
    private final String units;
    private final Path cacheDir;
    private final long cacheTTL;
    private final long cacheSize;
    private final boolean strictMode;
    private final String proxyHost;
    private final int proxyPort;
    private final int queryTimeout;
    private final boolean filterMode;
    private final String apiKeyHistorical;
    private final String apiKeyForecast;

    public TWCConnectionString(String url, Properties props) throws SQLException {
        String[] connStrProperties = TWCConnectionString.validateURL(url);
        this.uri = TWCConnectionString.parseURL(connStrProperties, TWCDriver.TWC_METADATA);
        this.properties = TWCConnectionString.mergeConnectionProperties(connStrProperties, props);
        TWCConnectionString.validateProperties(this.properties);
        this.catalog = TWCConnectionString.extractCatalog(this.properties);
        this.schema = TWCConnectionString.extractSchema(this.properties);
        this.maxStatements = TWCConnectionString.extractMaxStatements(this.properties);
        this.language = TWCConnectionString.extractLanguage(this.properties);
        this.units = TWCConnectionString.extractUnits(this.properties);
        this.cacheDir = TWCConnectionString.extractCacheDir(this.properties);
        this.cacheTTL = TWCConnectionString.extractCacheTTL(this.properties);
        this.cacheSize = TWCConnectionString.extractCacheSize(this.properties);
        this.strictMode = TWCConnectionString.extractStrictMode(this.properties);
        this.proxyHost = TWCConnectionString.extractProxyHost(this.properties);
        this.proxyPort = TWCConnectionString.extractProxyPort(this.properties);
        this.queryTimeout = TWCConnectionString.extractQueryTimeout(this.properties);
        this.filterMode = TWCConnectionString.extractFilterMode(this.properties);
        this.apiKeyHistorical = TWCConnectionString.extractHistoricalApiKey(this.properties);
        this.apiKeyForecast = TWCConnectionString.extractForecastApiKey(this.properties);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public URI getURI() {
        return this.uri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getUnits() {
        return this.units;
    }

    public Path getCacheDir() {
        return this.cacheDir;
    }

    public long getCacheTTL() {
        return this.cacheTTL;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public boolean isFilterMode() {
        return this.filterMode;
    }

    public String getHistoricalKey() {
        return this.apiKeyHistorical;
    }

    public String getForecastKey() {
        return this.apiKeyForecast;
    }

    public URI getProductDiscoveryURI(Catalog providedCatalog, Schema providedSchema) throws Exception {
        Catalog twcCatalog = TWCConnectionString.validateCatalog(providedCatalog, TWCDriver.TWC_METADATA);
        Schema twcSchema = TWCConnectionString.validateSchema(providedSchema, twcCatalog);
        if (!this.catalog.equals(twcCatalog.getName().value())) {
            throw new SQLException(TWCMessageUtil.getMessage("0038", twcCatalog.getName().value(), this));
        }
        StringJoiner sj = new StringJoiner(FORWARD_SLASH_STR, FORWARD_SLASH_STR, EMPTY_STR);
        String path = sj.add(twcCatalog.getRelativePath().value()).add(twcSchema.getRelativePath().value()).add(PRODUCTS_STR).toString();
        return new URI(this.uri.getScheme(), this.uri.getAuthority(), path, ConnectionProperties.PASSWORD_PROPERTY.getQueryParameterString(this.properties), null);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(SEMICOLON_STR, JDBC_CONNECTION_STR_PREFIX + this.uri.getAuthority() + SEMICOLON_STR, EMPTY_STR);
        TreeSet<String> keys = new TreeSet<String>(this.properties.stringPropertyNames());
        for (String key : keys) {
            if (ConnectionProperties.AUTHORITY_PROPERTY.getKey().compareTo(key) == 0) continue;
            sj.add(key + EQUAL_STR + this.properties.getProperty(key));
        }
        return sj.toString();
    }

    static Catalog validateCatalog(Catalog providedCatalog, Server fullTWCMDSpec) throws SQLException {
        Objects.requireNonNull(providedCatalog, TWCMessageUtil.getMessage("0007", "providedCatalog"));
        Objects.requireNonNull(fullTWCMDSpec, TWCMessageUtil.getMessage("0007", "fullTWCMDSpec"));
        List retrievedCatalogs = fullTWCMDSpec.getCatalogs().stream().filter(c -> c.getName().equals((Object)providedCatalog.getName())).collect(Collectors.toList());
        if (retrievedCatalogs.size() != 1) {
            throw new SQLException(TWCMessageUtil.getMessage("0037", "Catalog", providedCatalog.getName().value()), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_CATALOG.getErrorCode());
        }
        return (Catalog)retrievedCatalogs.get(0);
    }

    static Schema validateSchema(Schema providedSchema, Catalog fullTWCCatalog) throws SQLException {
        Objects.requireNonNull(providedSchema, TWCMessageUtil.getMessage("0007", "providedSchema"));
        Objects.requireNonNull(fullTWCCatalog, TWCMessageUtil.getMessage("0007", "fullTWCCatalog"));
        List retrievedSchemas = fullTWCCatalog.getSchemas().stream().filter(s -> s.getName().equals((Object)providedSchema.getName())).collect(Collectors.toList());
        if (retrievedSchemas.size() != 1) {
            throw new SQLException(TWCMessageUtil.getMessage("0037", "Schema", providedSchema.getName().value()), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_SCHEMA.getErrorCode());
        }
        return (Schema)retrievedSchemas.get(0);
    }

    static boolean isTWCSubprotocol(String url) throws SQLException {
        if (null == url) {
            throw new SQLException(TWCMessageUtil.getMessage("0036"));
        }
        return url.startsWith(JDBC_CONNECTION_STR_PREFIX);
    }

    static String[] validateURL(String url) throws SQLException {
        if (!TWCConnectionString.isTWCSubprotocol(url)) {
            throw new SQLException(TWCMessageUtil.getMessage("0035"), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_URL.getErrorCode());
        }
        String urlNoSignature = url.trim().substring(JDBC_CONNECTION_STR_PREFIX.length());
        String[] connStrProperties = urlNoSignature.split(SEMICOLON_STR);
        if (connStrProperties.length == 0) {
            throw new SQLException(TWCMessageUtil.getMessage("0034"), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.NO_PROPERTIES.getErrorCode());
        }
        return connStrProperties;
    }

    static URI parseURL(String[] connStrProperties, Server twcMetadataSpec) throws SQLException {
        Objects.requireNonNull(connStrProperties, "'connStrProperties' cannot be null.");
        Objects.requireNonNull(twcMetadataSpec, "'twcMetadataSpec' cannot be null.");
        if (connStrProperties.length == 0) {
            throw new SQLException(TWCMessageUtil.getMessage("0034"), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.NO_PROPERTIES.getErrorCode());
        }
        String connStrURL = connStrProperties[0];
        if (connStrURL.isEmpty()) {
            connStrProperties[0] = connStrURL = twcMetadataSpec.getAuthority().value();
        }
        try {
            return new URI((Object)((Object)twcMetadataSpec.getScheme()) + DOUBLE_FORWARD_SLASH_STR + connStrURL);
        }
        catch (URISyntaxException e) {
            throw new SQLException(String.format("Invalid TWC JDBC connection string: Invalid URI detected '%s'.", (Object)((Object)twcMetadataSpec.getScheme()) + DOUBLE_FORWARD_SLASH_STR + connStrURL), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_URL.getErrorCode(), e);
        }
    }

    static Properties mergeConnectionProperties(String[] connStrProperties, Properties props) throws SQLException {
        Objects.requireNonNull(connStrProperties, TWCMessageUtil.getMessage("0007", "connStrProperties"));
        Map<String, String> defaults = ConnectionProperties.getDefaults();
        HashMap<String, String> urlProperties = new HashMap<String, String>();
        urlProperties.put(ConnectionProperties.AUTHORITY_PROPERTY.getKey(), connStrProperties[0]);
        for (int i = 1; i < connStrProperties.length; ++i) {
            String[] keyValuePair = connStrProperties[i].split(EQUAL_STR);
            if (keyValuePair.length != 2) {
                throw new SQLException(TWCMessageUtil.getMessage("0031", connStrProperties[i]), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_PROPERTY.getErrorCode());
            }
            urlProperties.put(((String)keyValuePair[0]).toUpperCase(), (String)keyValuePair[1]);
        }
        Map<Object, Object> suppliedProperties = Collections.emptyMap();
        if (null != props) {
            suppliedProperties = props.keySet().stream().collect(Collectors.toMap(o -> o.toString().toUpperCase(), o -> String.valueOf(props.get(o))));
        }
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(TWCMessageUtil.getMessage("0032", key), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.DUPLICATED_PROPERTY.getErrorCode());
        }
        Properties result = new Properties();
        TWCConnectionString.setProperties(result, defaults);
        TWCConnectionString.setProperties(result, urlProperties);
        TWCConnectionString.setProperties(result, suppliedProperties);
        result.remove("USER");
        return result;
    }

    static void setProperties(Properties props, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
    }

    static void validateProperties(Properties props) throws SQLException {
        for (String string : props.stringPropertyNames()) {
            if (ConnectionProperties.getConnectionProperty(string) != null) continue;
            throw new SQLException(TWCMessageUtil.getMessage("0031", string), TWCSQLState.CONNECTION_INVALID_OPTION.getState(), TWCSQLErrorCode.INVALID_PROPERTY_NAME.getErrorCode());
        }
        for (ConnectionProperty connectionProperty : ConnectionProperties.getAllProperties()) {
            connectionProperty.validate(props);
        }
    }

    static String extractProxyHost(Properties props) {
        return props.getProperty(ConnectionProperties.PROXY_HOST_PROPERTY.getKey());
    }

    static int extractProxyPort(Properties props) {
        return Integer.parseInt(props.getProperty(ConnectionProperties.PROXY_PORT_PROPERTY.getKey()));
    }

    static int extractQueryTimeout(Properties props) {
        return Integer.parseInt(props.getProperty(ConnectionProperties.QUERY_TIMEOUT_PROPERTY.getKey()));
    }

    static String extractCatalog(Properties props) {
        return props.getProperty(ConnectionProperties.CATALOG_PROPERTY.getKey());
    }

    static String extractSchema(Properties props) {
        return props.getProperty(ConnectionProperties.SCHEMA_PROPERTY.getKey());
    }

    static int extractMaxStatements(Properties props) {
        return Integer.parseInt(props.getProperty(ConnectionProperties.MAX_STATEMENTS_PROPERTY.getKey()));
    }

    static String extractLanguage(Properties props) {
        return props.getProperty(ConnectionProperties.LANGUAGE_PROPERTY.getKey());
    }

    static String extractUnits(Properties props) {
        return props.getProperty(ConnectionProperties.UNITS_PROPERTY.getKey());
    }

    static Path extractCacheDir(Properties props) {
        return Paths.get(props.getProperty(ConnectionProperties.CACHE_DIR_PROPERTY.getKey()), new String[0]);
    }

    static long extractCacheTTL(Properties props) {
        return Long.parseLong(props.getProperty(ConnectionProperties.CACHE_TTL_PROPERTY.getKey()));
    }

    static long extractCacheSize(Properties props) {
        return Long.parseLong(props.getProperty(ConnectionProperties.CACHE_SIZE_PROPERTY.getKey()));
    }

    static boolean extractStrictMode(Properties props) {
        return Boolean.valueOf(props.getProperty(ConnectionProperties.STRICT_MODE_PROPERTY.getKey()));
    }

    static boolean extractFilterMode(Properties props) {
        return Boolean.valueOf(props.getProperty(ConnectionProperties.FILTER_METADATA_PROPERTY.getKey()));
    }

    static String extractHistoricalApiKey(Properties props) {
        String compositeKey = props.getProperty(ConnectionProperties.PASSWORD_PROPERTY.getKey());
        String[] keyParts = compositeKey.split(COMMA_STR);
        return keyParts[0];
    }

    static String extractForecastApiKey(Properties props) {
        String compositeKey = props.getProperty(ConnectionProperties.PASSWORD_PROPERTY.getKey());
        String[] keyParts = compositeKey.split(COMMA_STR);
        if (keyParts.length == 1) {
            return keyParts[0];
        }
        return keyParts[1];
    }
}

