/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.ColumnInfo;
import com.ibm.cognos.jdbc.twc.ConnectionProperties;
import com.ibm.cognos.jdbc.twc.TWCConnection;
import com.ibm.cognos.jdbc.twc.TWCDriver;
import com.ibm.cognos.jdbc.twc.TWCResultSet;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;

public class TWCDatabaseMetaData
implements DatabaseMetaData,
TWCMessageKeys {
    public static final String EMPTY_STR = "";
    public static final String SEARCH_STRING_ESCAPE = "";
    static final String PROCEDURES_TABLE_NAME = "PROCEDURES";
    static final String PROCEDURE_COLUMNS_TABLE_NAME = "PROCEDURE_COLUMNS";
    static final String INDEXES_TABLE_NAME = "INDEXES";
    static final String CLIENT_INFO_TABLE_NAME = "CLIENTINFO";
    static final String FUNCTIONS_TABLE_NAME = "FUNCTIONS";
    static final String FUNCTION_COLUMNS_TABLE_NAME = "FUNCTION_COLUMNS";
    static final String PSEUDOCOLUMNS_TABLE_NAME = "PSEUDOCOLUMNS";
    static final String ATTRIBUTES_TABLE_NAME = "ATTRIBUTES";
    static final String SUPERTABLES_TABLE_NAME = "SUPERTABLES";
    static final String SUPERTYPES_TABLE_NAME = "SUPERTYPES";
    static final String USER_DEFINED_TYPES_TABLE_NAME = "USER_DEFINED_TYPES";
    static final String VERSION_COLUMNS_TABLE_NAME = "VERSION_COLUMNS";
    static final String PRIMARY_KEYS_TABLE_NAME = "PRIMARY_KEYS";
    static final String IMPORTED_EXPORTED_KEYS_TABLE_NAME = "IMPORTED_EXPORTED_KEYS";
    static final String ROW_IDENTIFIERS_TABLE_NAME = "ROW_IDENTIFIERS";
    static final String TABLES_TABLE_NAME = "TABLES";
    static final String SCHEMAS_TABLE_NAME = "SCHEMAS";
    static final String CATALOGS_TABLE_NAME = "CATALOGS";
    static final String TABLE_TYPES_TABLE_NAME = "TABLETYPES";
    static final String TYPES_TABLE_NAME = "TYPES";
    static final String COLUMNS_TABLE_NAME = "COLUMNS";
    static final String REMARKS_STR = "REMARKS";
    static final String SPECIFIC_NAME_STR = "SPECIFIC_NAME";
    static final String COLUMN_NAME_STR = "COLUMN_NAME";
    static final String NULLABLE_STR = "NULLABLE";
    static final String TYPE_NAME_STR = "TYPE_NAME";
    static final String ORDINAL_POSITION_STR = "ORDINAL_POSITION";
    static final String DATA_TYPE_STR = "DATA_TYPE";
    static final String IS_NULLABLE_STR = "IS_NULLABLE";
    static final String CHAR_OCTET_LENGTH_STR = "CHAR_OCTET_LENGTH";
    static final String TABLE_SCHEM_STR = "TABLE_SCHEM";
    static final String TABLE_CAT_STR = "TABLE_CAT";
    static final String TABLE_CATALOG_STR = "TABLE_CATALOG";
    static final String TABLE_NAME_STR = "TABLE_NAME";
    static final String TYPE_CAT_STR = "TYPE_CAT";
    static final String TYPE_SCHEM_STR = "TYPE_SCHEM";
    static final String DECIMAL_DIGITS_STR = "DECIMAL_DIGITS";
    static final String COLUMN_SIZE_STR = "COLUMN_SIZE";
    static final String PRECISION_STR = "PRECISION";
    static final String NUM_PREC_RADIX_STR = "NUM_PREC_RADIX";
    static final String SQL_DATETIME_SUB_STR = "SQL_DATETIME_SUB";
    static final String SQL_DATA_TYPE_STR = "SQL_DATA_TYPE";
    static final String BUFFER_LENGTH_STR = "BUFFER_LENGTH";
    static final ColumnInfo[] getProceduresColumnInfo = TWCDatabaseMetaData.constructGetProceduresColumnInfo();
    static final ColumnInfo[] getProcedureColumnsColumnInfo = TWCDatabaseMetaData.constructGetProcedureColumnsColumnInfo();
    static final ColumnInfo[] getTablesColumnInfo = TWCDatabaseMetaData.constructGetTablesColumnInfo();
    static final ColumnInfo[] getSchemasColumnInfo = TWCDatabaseMetaData.constructGetSchemasColumnInfo();
    static final ColumnInfo[] getCatalogsColumnInfo = TWCDatabaseMetaData.constructGetCatalogsColumnInfo();
    static final ColumnInfo[] getTableTypesColumnInfo = TWCDatabaseMetaData.constructGetTableTypesColumnInfo();
    static final ColumnInfo[] getBestRowIdentifierColumnInfo = TWCDatabaseMetaData.constructGetBestRowIdentifierColumnInfo();
    static final ColumnInfo[] getVersionColumnsColumnInfo = TWCDatabaseMetaData.constructGetVersionColumns();
    static final ColumnInfo[] getPrimaryKeysColumnInfo = TWCDatabaseMetaData.constructGetPrimaryKeysColumnInfo();
    static final ColumnInfo[] getImportedKeysColumnInfo = TWCDatabaseMetaData.constructGetImportedKeysColumnInfo();
    static final ColumnInfo[] getTypeInfoColumnInfo = TWCDatabaseMetaData.constructGetTypeInfoColumnInfo();
    static final ColumnInfo[] getIndexInfoColumnInfo = TWCDatabaseMetaData.constructGetIndexInfoColumnInfo();
    static final ColumnInfo[] getUDTsColumnInfo = TWCDatabaseMetaData.constructGetUDTsColumnInfo();
    static final ColumnInfo[] getSuperTypesColumnInfo = TWCDatabaseMetaData.constructGetSuperTypesColumnInfo();
    static final ColumnInfo[] getSuperTablesColumnInfo = TWCDatabaseMetaData.constructGetSuperTablesColumnInfo();
    static final ColumnInfo[] getAttributesColumnInfo = TWCDatabaseMetaData.constructGetAttributesColumnInfo();
    static final ColumnInfo[] getClientInfoPropertiesColumnInfo = TWCDatabaseMetaData.constructGetClientInfoPropertiesColumnInfo();
    static final ColumnInfo[] getFunctionsColumnInfo = TWCDatabaseMetaData.constructGetFunctionsColumnInfo();
    static final ColumnInfo[] getFunctionColumnsColumnInfo = TWCDatabaseMetaData.constructGetFunctionColumnsColumnInfo();
    static final ColumnInfo[] getPseudoColumnsColumnInfo = TWCDatabaseMetaData.constructGetPseudoColumnsColumnInfo();
    static final ColumnInfo[] getTablePrivilegesColumnInfo = TWCDatabaseMetaData.constructGetTablePrivilegesColumnInfo();
    static final ColumnInfo[] getColumnsColumnInfo = TWCDatabaseMetaData.constructGetColumnsColumnInfo();
    static final ColumnInfo[] getColumnPrivilegesColumnInfo = TWCDatabaseMetaData.constructGetColumnPrivilegesColumnInfo();
    private final TWCConnection connection;

    public TWCDatabaseMetaData(TWCConnection conn) {
        this.connection = Objects.requireNonNull(conn, TWCMessageUtil.getMessage("0007", "connection"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(TWCMessageUtil.getMessage("0009", iface), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getTWCURI().toString();
    }

    @Override
    public String getUserName() throws SQLException {
        throw TWCDatabaseMetaData.notSupported("getUserName");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "The Weather Company";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return String.valueOf(TWCDriver.DRIVER_VERSION_MAJOR) + '.' + TWCDriver.DRIVER_VERSION_MINOR;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "The Weather Company JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return TWCDriver.DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return TWCDriver.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getDriverMinorVersion() {
        return TWCDriver.DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return ConnectionProperties.CATALOG_PROPERTY.getKey();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 1024;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getProceduresColumnInfo);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getProcedureColumnsColumnInfo);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructTablesResultSet(getTablesColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructSchemasResultSet(getSchemasColumnInfo, this.connection.getMetadataView().getCatalogs(), null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructCatalogsResultSet(getCatalogsColumnInfo, this.connection.getMetadataView().getCatalogs());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructTableTypesResultSet(getTableTypesColumnInfo);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructColumnsResultSet(getColumnsColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructColumnPrivilegesResultSet(getColumnPrivilegesColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructTablePrivilegesResultSet(getTablePrivilegesColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getBestRowIdentifierColumnInfo);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getVersionColumnsColumnInfo);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructPrimaryKeyResultSet(getPrimaryKeysColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schema, table);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getImportedKeysColumnInfo);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedKeys(catalog, schema, table);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedKeys(parentCatalog, parentSchema, parentTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructTypeInfoResultSet(getTypeInfoColumnInfo);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getIndexInfoColumnInfo);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return 1003 == type;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return 1003 == type && 1007 == concurrency;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getUDTsColumnInfo);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getSuperTypesColumnInfo);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getSuperTablesColumnInfo);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getAttributesColumnInfo);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 1 == holdability;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return TWCDriver.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return TWCDriver.DRIVER_VERSION_MINOR;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructSchemasResultSet(getSchemasColumnInfo, this.connection.getMetadataView().getCatalogs(), catalog, schemaPattern);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getClientInfoPropertiesColumnInfo);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getFunctionsColumnInfo);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getFunctionColumnsColumnInfo);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return TWCResultSet.TWCResultSetFactory.constructEmptyResultSet(getPseudoColumnsColumnInfo);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private static ColumnInfo[] constructGetProceduresColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("PROCEDURE_CAT").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PROCEDURE_SCHEM").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PROCEDURE_NAME").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("null").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("null").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("null").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PROCEDURE_TYPE").setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(PROCEDURES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetProcedureColumnsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("PROCEDURE_CAT").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PROCEDURE_SCHEM").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PROCEDURE_NAME").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("COLUMN_TYPE").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(PRECISION_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("LENGTH").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SCALE").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("RADIX").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NULLABLE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("COLUMN_DEF").setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(IS_NULLABLE_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(PROCEDURE_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetTablesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("TABLE_TYPE").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_CAT_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SELF_REFERENCING_COL_NAME").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("REF_GENERATION").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetSchemasColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(SCHEMAS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TABLE_CATALOG_STR).setTable(SCHEMAS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetCatalogsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(CATALOGS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetTableTypesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("TABLE_TYPE").setTable(TABLE_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetBestRowIdentifierColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("SCOPE").setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_SIZE_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PSEUDO_COLUMN").setTable(ROW_IDENTIFIERS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetVersionColumns() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("SCOPE").setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_SIZE_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PSEUDO_COLUMN").setTable(VERSION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetPrimaryKeysColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("KEY_SEQ").setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("PK_NAME").setTable(PRIMARY_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetImportedKeysColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("PKTABLE_CAT").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PKTABLE_SCHEM").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PKTABLE_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("PKCOLUMN_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("FKTABLE_CAT").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FKTABLE_SCHEM").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FKTABLE_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("FKCOLUMN_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("KEY_SEQ").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("UPDATE_RULE").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("DELETE_RULE").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("FK_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("PK_NAME").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("DEFERRABILITY").setTable(IMPORTED_EXPORTED_KEYS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetTypeInfoColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(PRECISION_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("LITERAL_PREFIX").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("LITERAL_SUFFIX").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("CREATE_PARAMS").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NULLABLE_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("CASE_SENSITIVE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BOOLEAN).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SEARCHABLE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("UNSIGNED_ATTRIBUTE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BOOLEAN).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("FIXED_PREC_SCALE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BOOLEAN).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("AUTO_INCREMENT").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BOOLEAN).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("LOCAL_TYPE_NAME").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("MINIMUM_SCALE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("MAXIMUM_SCALE").setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetIndexInfoColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("NON_UNIQUE").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BOOLEAN).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("INDEX_QUALIFIER").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("INDEX_NAME").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("TYPE").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("ASC_OR_DESC").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("CARDINALITY").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BIGINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("PAGES").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.BIGINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("FILTER_CONDITION").setTable(INDEXES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetUDTsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TYPE_CAT_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_SCHEM_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("CLASS_NAME").setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("BASE_TYPE").setTable(USER_DEFINED_TYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetSuperTypesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TYPE_CAT_STR).setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_SCHEM_STR).setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SUPERTYPE_CAT").setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SUPERTYPE_SCHEM").setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SUPERTYPE_NAME").setTable(SUPERTYPES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetSuperTablesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(SUPERTABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(SUPERTABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(SUPERTABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SUPERTABLE_NAME").setTable(SUPERTABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetAttributesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TYPE_CAT_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_SCHEM_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("ATTR_NAME").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("ATTR_TYPE_NAME").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("ATTR_SIZE").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NULLABLE_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("ATTR_DEF").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(IS_NULLABLE_STR).setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SCOPE_CATALOG").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SCOPE_SCHEMA").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SCOPE_TABLE").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SOURCE_DATA_TYPE").setTable(ATTRIBUTES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetClientInfoPropertiesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("NAME").setTable(CLIENT_INFO_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("MAX_LEN").setTable(CLIENT_INFO_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setCatalog("").setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("DEFAULT_VALUE").setTable(CLIENT_INFO_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("DESCRIPTION").setTable(CLIENT_INFO_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetFunctionsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("FUNCTION_CAT").setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FUNCTION_SCHEM").setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FUNCTION_NAME").setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FUNCTION_TYPE").setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(FUNCTIONS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetFunctionColumnsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName("FUNCTION_CAT").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FUNCTION_SCHEM").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("FUNCTION_NAME").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("COLUMN_TYPE").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(PRECISION_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("LENGTH").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SCALE").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("RADIX").setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NULLABLE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(IS_NULLABLE_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(SPECIFIC_NAME_STR).setTable(FUNCTION_COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetPseudoColumnsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_SIZE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("COLUMN_USAGE").setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(IS_NULLABLE_STR).setTable(PSEUDOCOLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetTablePrivilegesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("GRANTOR").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("GRANTEE").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("PRIVILEGE").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("IS_GRANTABLE").setTable(TABLES_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetColumnsColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(DATA_TYPE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(TYPE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_SIZE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(BUFFER_LENGTH_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(DECIMAL_DIGITS_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NUM_PREC_RADIX_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(NULLABLE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(REMARKS_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("COLUMN_DEF").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATA_TYPE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(SQL_DATETIME_SUB_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(CHAR_OCTET_LENGTH_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(ORDINAL_POSITION_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.INTEGER).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(IS_NULLABLE_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("SCOPE_CATALOG").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SCOPE_SCHEMA").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SCOPE_TABLE").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("SOURCE_DATA_TYPE").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.SMALLINT).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("IS_AUTOINCREMENT").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("IS_GENERATEDCOLUMN").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build()};
        return columns;
    }

    private static ColumnInfo[] constructGetColumnPrivilegesColumnInfo() {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo.Builder().setColumnName(TABLE_CAT_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_SCHEM_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName(TABLE_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName(COLUMN_NAME_STR).setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("GRANTOR").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build(), new ColumnInfo.Builder().setColumnName("GRANTEE").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("PRIVILEGE").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS).build(), new ColumnInfo.Builder().setColumnName("IS_GRANTABLE").setTable(COLUMNS_TABLE_NAME).setCatalog("").setDataType(Column.Datatype.VARCHAR).setPrecision(50).setScale(0).setDisplaySize(50).setNullConstraint(ColumnInfo.NullConstraint.NULLABLE).build()};
        return columns;
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(TWCMessageUtil.getMessage("0029", s), TWCSQLState.FEATURE_NOT_SUPPORTED.getState(), TWCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }
}

