/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.ConnectionProperties;
import com.ibm.cognos.jdbc.twc.QueryExecutor;
import com.ibm.cognos.jdbc.twc.TWCConnection;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCQueryTask;
import com.ibm.cognos.jdbc.twc.jackson.databind.ObjectMapper;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TWCDriver
implements Driver,
Closeable,
TWCMessageKeys {
    static final String TWC_SPEC_RESOURCE = "/twc_metadata_spec/twc_spec.json";
    static final String DRIVER_NAME = "The Weather Company JDBC Driver";
    static final String DATABASE_PRODUCT_NAME = "The Weather Company";
    static final String UNKNOWN_STR = "unknown";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    static final Server TWC_METADATA;
    static final ObjectMapper jacksonObjectMapper;
    static final CacheManager cache;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!TWCConnectionString.isTWCSubprotocol(url)) {
            return null;
        }
        TWCConnection conn = null;
        QueryExecutor queryExecutor = null;
        try {
            TWCConnectionString connStr = new TWCConnectionString(url, info);
            queryExecutor = new QueryExecutor(connStr.getMaxStatements(), TWCQueryTask::new, connStr.getProxyHost(), connStr.getProxyPort(), connStr.getQueryTimeout());
            conn = new TWCConnection(connStr, queryExecutor, cache);
            conn.setClientInfo(connStr.getProperties());
            cache.registerConnection(connStr, conn.getConnectionUUID());
        }
        catch (Exception e) {
            if (null != conn) {
                conn.close();
            }
            if (null != queryExecutor) {
                queryExecutor.close();
            }
            throw e;
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return TWCConnectionString.isTWCSubprotocol(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        TWCConnectionString connStr = new TWCConnectionString(url, info);
        Properties props = connStr.getProperties();
        return (DriverPropertyInfo[])ConnectionProperties.getAllProperties().stream().map(property -> property.getDriverPropertyInfo(props)).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(TWCMessageUtil.getMessage("0000"), TWCSQLState.FEATURE_NOT_SUPPORTED.getState(), TWCSQLErrorCode.PARENT_LOGGER_NOT_SUPPORTED.getErrorCode());
    }

    @Override
    public void close() throws IOException {
        cache.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Server serializeTWCMetaSpec(String resourcePath) throws SQLException {
        try (InputStream in = TWCConnectionString.class.getResourceAsStream(resourcePath);){
            if (null == in) {
                throw new SQLException(TWCMessageUtil.getMessage("0030", "read"), TWCSQLState.CONNECTION_ERROR.getState(), TWCSQLErrorCode.METADATA_SPEC_MISSING.getErrorCode());
            }
            Server server = jacksonObjectMapper.readValue(in, Server.class);
            return server;
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0030", "parse"), TWCSQLState.CONNECTION_ERROR.getState(), TWCSQLErrorCode.METADATA_PARSE_ERROR.getErrorCode(), e);
        }
    }

    static {
        Matcher versionMatcher;
        jacksonObjectMapper = new ObjectMapper();
        cache = new CacheManager(TimeUnit.MINUTES.toSeconds(5L));
        String version = "";
        Package twcPackage = Server.class.getPackage();
        if (null != twcPackage) {
            version = twcPackage.getImplementationVersion();
        }
        if (null == version) {
            version = "";
        }
        if (!(versionMatcher = Pattern.compile("^(\\d+)\\.(\\d+)($|[.-])").matcher(version)).find()) {
            DRIVER_VERSION = UNKNOWN_STR;
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            DRIVER_VERSION = version;
            DRIVER_VERSION_MAJOR = Integer.parseInt(versionMatcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(versionMatcher.group(2));
        }
        try {
            TWC_METADATA = TWCDriver.serializeTWCMetaSpec(TWC_SPEC_RESOURCE);
            DriverManager.registerDriver(new TWCDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

