/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.CacheableHttpCSVToAvroProcessor;
import com.ibm.cognos.jdbc.twc.HttpInMemoryProcessor;
import com.ibm.cognos.jdbc.twc.LocalAvroProcessor;
import com.ibm.cognos.jdbc.twc.QueryProcessor;
import com.ibm.cognos.jdbc.twc.QueryResult;
import com.ibm.cognos.jdbc.twc.QueryStatus;
import com.ibm.cognos.jdbc.twc.QueryTask;
import com.ibm.cognos.jdbc.twc.TWCConnectionString;
import com.ibm.cognos.jdbc.twc.TWCEmptyResultSetFactory;
import com.ibm.cognos.jdbc.twc.TWCResultSet;
import com.ibm.cognos.jdbc.twc.TWCStatement;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Server;
import com.ibm.cognos.jdbc.twc.org.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cognos.jdbc.twc.org.slf4j.Logger;
import com.ibm.cognos.jdbc.twc.org.slf4j.LoggerFactory;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserWrapper;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

class TWCQueryTask
implements QueryTask,
TWCMessageKeys {
    private static final Logger LOGGER = LoggerFactory.getLogger(TWCQueryTask.class);
    private static final String SEMICOLON_STR = ";";
    private final String connId;
    private final Server twcMDView;
    private final String originalSQL;
    private final Statement statement;
    private final QueryStatus status;
    private final CloseableHttpClient httpClient;
    private final TWCConnectionString connStr;
    private final QueryResult result;
    private final CacheManager cacheMgr;

    TWCQueryTask(String queryId, String connectionId, Server twcMD, String sql, TWCStatement theStatement, QueryStatus taskStatus, CloseableHttpClient client, TWCConnectionString connectionString, CacheManager cacheManager) throws SQLException {
        Objects.requireNonNull(queryId, TWCMessageUtil.getMessage("0007", "queryId"));
        this.connId = Objects.requireNonNull(connectionId, TWCMessageUtil.getMessage("0007", "connectionId"));
        this.twcMDView = Objects.requireNonNull(twcMD, TWCMessageUtil.getMessage("0007", "twcMD"));
        this.originalSQL = Objects.requireNonNull(sql, TWCMessageUtil.getMessage("0007", "sql"));
        this.statement = Objects.requireNonNull(theStatement, TWCMessageUtil.getMessage("0007", "theStatement"));
        this.status = Objects.requireNonNull(taskStatus, TWCMessageUtil.getMessage("0007", "taskStatus"));
        this.httpClient = Objects.requireNonNull(client, TWCMessageUtil.getMessage("0007", "client"));
        this.connStr = Objects.requireNonNull(connectionString, TWCMessageUtil.getMessage("0007", "connectionString"));
        this.cacheMgr = Objects.requireNonNull(cacheManager, TWCMessageUtil.getMessage("0007", "cacheManager"));
        this.result = new QueryResult(taskStatus, TWCEmptyResultSetFactory.constructEmptyResultSet(queryId, connectionId, theStatement));
    }

    @Override
    public QueryResult call() throws Exception {
        this.status.start();
        try {
            if (this.status.isNotRunning()) {
                return this.result;
            }
            String cleansedSQL = this.cleanseSQL();
            LOGGER.info("QueryId: {} - Attempting to parse the provided query.", (Object)this.status.getRequestId());
            TWCSQLParserWrapper parser = new TWCSQLParserWrapper(this.status.getRequestId(), cleansedSQL, this.twcMDView, this.connStr.getCatalog(), this.connStr.getSchema(), this.connStr.getLanguage(), this.connStr.getUnits(), this.connStr.getURI(), this.connStr.isStrictMode());
            parser.parse();
            LOGGER.info("QueryId: {} - Query parsed successfully.", (Object)this.status.getRequestId());
            QueryProcessor queryProcessor = Schema.Name.HISTORICAL == parser.getSchema().getName() || Schema.Name.FORECAST == parser.getSchema().getName() ? new CacheableHttpCSVToAvroProcessor(this.httpClient, this.cacheMgr) : (Schema.Name.SYSTEM == parser.getSchema().getName() ? new HttpInMemoryProcessor(parser, this.httpClient) : new LocalAvroProcessor());
            TWCResultSet twcRS = queryProcessor.execute(this.connId, this.statement, this.status, this.connStr, parser);
            this.status.complete();
            return new QueryResult(this.status, twcRS);
        }
        catch (Exception e) {
            this.status.fail(e);
            throw e;
        }
    }

    private String cleanseSQL() {
        String cleansedSQL = this.originalSQL.trim();
        if (!cleansedSQL.endsWith(SEMICOLON_STR)) {
            cleansedSQL = cleansedSQL + SEMICOLON_STR;
        }
        return cleansedSQL;
    }
}

