/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.CacheManager;
import com.ibm.cognos.jdbc.twc.ColumnInfo;
import com.ibm.cognos.jdbc.twc.TWCResultSetMetaData;
import com.ibm.cognos.jdbc.twc.avro.AvroRowWalker;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.metadata.generated.Table;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.TWCSQLParserWrapper;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class TWCResultSet
implements ResultSet {
    private static final String GET_OBJECT_METHOD = "getObject";
    private static final String UPDATE_OBJECT_METHOD = "updateObject";
    private static final String UPDATE_BLOB_METHOD = "updateBlob";
    private static final String UPDATE_CLOB_METHOD = "updateClob";
    private static final String UPDATE_NCLOB_METHOD = "updateNClob";
    private static final String UPDATE_NCHARACTER_STREAM_METHOD = "updateNCharacterStream";
    private static final String UPDATE_ASCII_STREAM_METHOD = "updateAsciiStream";
    private static final String UPDATE_BINARY_STREAM_METHOD = "updateBinaryStream";
    private static final String UPDATE_CHARACTER_STREAM_METHOD = "updateCharacterStream";
    private final String queryId;
    private final String connUUID;
    private final ResultSetMetaData resultSetMetaData;
    private final Map<String, Integer> columnLookup;
    private final Iterator<List<Object>> results;
    private final AtomicReference<List<Object>> row = new AtomicReference();
    private final Object[] intermediateRow;
    private final Statement statement;
    private final AvroRowWalker avroRowWalker;
    private final TWCSQLParserWrapper parser;
    private final int[] rsMd2AvroMd;
    private final Object[] projectedLiterals;
    private final int[] projectedLiteralsOrdinals;
    private final CacheManager cacheMgr;
    private final List<String> avroIds;
    private final FilterConditionEvaluator eval;
    private final AtomicBoolean wasNull = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean avroRowWalkerClosed;
    private final AtomicBoolean beforeFirst = new AtomicBoolean(true);
    private final AtomicBoolean afterLast = new AtomicBoolean(false);
    private final AtomicInteger rowId = new AtomicInteger(0);

    TWCResultSet(String id, String connectionId, TWCResultSetMetaData resultMD, Iterator<List<Object>> resultsIterator, Statement theStatement, AvroRowWalker avroWalker, TWCSQLParserWrapper twcParser, int[] rsMd2AvroMdMap, Map<String, Integer> csvColsMapping, Object[] projectedLiteralValues, int[] projectedLiteralsOrdinalPositions, CacheManager cacheManager, List<String> avroFileIds) throws SQLException {
        if (null != avroWalker) {
            Objects.requireNonNull(twcParser, TWCMessageUtil.getMessage("0007", "twcParser"));
            Objects.requireNonNull(rsMd2AvroMdMap, TWCMessageUtil.getMessage("0007", "rsMd2AvroMdMap"));
            Objects.requireNonNull(csvColsMapping, TWCMessageUtil.getMessage("0007", "csvColsMapping"));
            Objects.requireNonNull(projectedLiteralValues, TWCMessageUtil.getMessage("0007", "projectedLiteralValues"));
            Objects.requireNonNull(projectedLiteralsOrdinalPositions, TWCMessageUtil.getMessage("0007", "projectedLiteralsOrdinalPositions"));
            Objects.requireNonNull(avroFileIds, TWCMessageUtil.getMessage("0007", "avroFileIds"));
        }
        if (null != avroFileIds && !avroFileIds.isEmpty()) {
            Objects.requireNonNull(cacheManager, TWCMessageUtil.getMessage("0007", "cacheManager"));
        }
        this.queryId = id;
        this.connUUID = connectionId;
        this.resultSetMetaData = Objects.requireNonNull(resultMD, TWCMessageUtil.getMessage("0007", "resultMD"));
        this.results = Objects.requireNonNull(resultsIterator, TWCMessageUtil.getMessage("0007", "resultsIterator"));
        this.statement = theStatement;
        this.columnLookup = TWCResultSet.constructColumnLookupMap(resultMD);
        this.avroRowWalker = avroWalker;
        this.parser = twcParser;
        this.rsMd2AvroMd = rsMd2AvroMdMap;
        this.projectedLiterals = projectedLiteralValues;
        this.projectedLiteralsOrdinals = projectedLiteralsOrdinalPositions;
        this.cacheMgr = cacheManager;
        this.avroIds = avroFileIds;
        this.avroRowWalkerClosed = null == avroWalker ? new AtomicBoolean(true) : new AtomicBoolean(false);
        this.intermediateRow = null == avroWalker ? null : new Object[resultMD.getColumnCount()];
        this.eval = null == avroWalker ? null : new FilterConditionEvaluator(Arrays.asList(this.intermediateRow), csvColsMapping, this.parser.getIgnoredFilterIdentifiers());
    }

    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(TWCMessageUtil.getMessage("0009", iface), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        try {
            if (!this.results.hasNext()) {
                this.row.set(null);
                this.afterLast.set(true);
                this.rowId.set(0);
                return false;
            }
            return this.retrieveNextRow();
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0024"), TWCSQLState.INCONSISTENT_CURSOR.getState(), TWCSQLErrorCode.UNKNOWN_CURSOR_STATE.getErrorCode(), e);
        }
    }

    private boolean retrieveNextRow() {
        if (null != this.intermediateRow) {
            boolean[] success = new boolean[]{true};
            this.row.getAndUpdate(previousRow -> {
                List<Object> avroRow = this.results.next();
                this.eval.setRow(avroRow);
                boolean passesCondition = this.parser.evaluateFilterExpression(this.eval);
                while (!passesCondition && this.results.hasNext()) {
                    avroRow = this.results.next();
                    this.eval.setRow(avroRow);
                    passesCondition = this.parser.evaluateFilterExpression(this.eval);
                }
                if (passesCondition) {
                    success[0] = true;
                    this.constructIntermediateRow(avroRow);
                    this.beforeFirst.set(false);
                    this.rowId.getAndIncrement();
                    return Arrays.asList(this.intermediateRow);
                }
                success[0] = false;
                this.beforeFirst.set(false);
                this.afterLast.set(true);
                this.rowId.set(0);
                this.releaseResources();
                return null;
            });
            return success[0];
        }
        this.row.set(this.results.next());
        this.beforeFirst.set(false);
        this.rowId.getAndIncrement();
        return true;
    }

    private void constructIntermediateRow(List<Object> avroRow) {
        int i;
        for (i = 0; i < this.intermediateRow.length; ++i) {
            if (-1 == this.rsMd2AvroMd[i]) continue;
            this.intermediateRow[i] = avroRow.get(this.rsMd2AvroMd[i]);
        }
        for (i = 0; i < this.projectedLiteralsOrdinals.length; ++i) {
            this.intermediateRow[this.projectedLiteralsOrdinals[i]] = this.projectedLiterals[i];
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            this.releaseResources();
        }
    }

    private void releaseResources() {
        if (this.avroRowWalkerClosed.compareAndSet(false, true)) {
            try {
                this.avroRowWalker.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String avroId : this.avroIds) {
                this.cacheMgr.deregisterAvroFile(this.connUUID, this.queryId, avroId);
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkOpen();
        return this.wasNull.get();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        return null != value ? value.toString() : null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        return TWCResultSet.toBoolean(value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnIndex)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bigDecimalValue = this.getBigDecimal(columnIndex);
        if (null != bigDecimalValue) {
            bigDecimalValue = bigDecimalValue.setScale(scale, 4);
        }
        return bigDecimalValue;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.columnValue(columnIndex));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return bos.toByteArray();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        if (null == value) {
            return null;
        }
        try {
            return Date.valueOf(LocalDate.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE));
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0026", value), TWCSQLState.DATA_CONVERSION_ERROR.getState(), TWCSQLErrorCode.INVALID_DATE.getErrorCode(), e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        if (null == value) {
            return null;
        }
        try {
            return Time.valueOf(LocalTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_TIME));
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0027", value), TWCSQLState.DATA_CONVERSION_ERROR.getState(), TWCSQLErrorCode.INVALID_TIME.getErrorCode(), e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        if (null == value) {
            return null;
        }
        try {
            return Timestamp.valueOf(LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        catch (Exception e) {
            throw new SQLException(TWCMessageUtil.getMessage("0028", value), TWCSQLState.DATA_CONVERSION_ERROR.getState(), TWCSQLErrorCode.INVALID_TIMESTAMP.getErrorCode(), e);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getBinaryStream");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Object value = this.columnValue(columnLabel);
        return null != value ? value.toString() : null;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Object value = this.columnValue(columnLabel);
        return TWCResultSet.toBoolean(value);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).byteValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).shortValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).intValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).longValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return TWCResultSet.toNumber(this.columnValue(columnLabel)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.columnLabel2columnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.columnValue(columnLabel));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return bos.toByteArray();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.columnLabel2columnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.columnLabel2columnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.columnLabel2columnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getBinaryStream");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TWCResultSet.notSupported("getCursorName");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.columnValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.columnValue(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.columnLabel2columnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getCharacterStream");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.columnValue(columnIndex);
        if (null == value) {
            return null;
        }
        return new BigDecimal(String.valueOf(value));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.columnLabel2columnIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.beforeFirst.get();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.afterLast.get();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return 1 == this.rowId.get();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw TWCResultSet.notSupported("isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw TWCResultSet.notSupported("beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        throw TWCResultSet.notSupported("afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        throw TWCResultSet.notSupported("first");
    }

    @Override
    public boolean last() throws SQLException {
        throw TWCResultSet.notSupported("last");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.rowId.get();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw TWCResultSet.notSupported("absolute");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw TWCResultSet.notSupported("relative");
    }

    @Override
    public boolean previous() throws SQLException {
        throw TWCResultSet.notSupported("previous");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw TWCResultSet.notSupported("setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException(TWCMessageUtil.getMessage("0011", rows), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.NEGATIVE_VALUE_NOT_ALLOWED.getErrorCode());
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw TWCResultSet.notSupported("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw TWCResultSet.notSupported("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw TWCResultSet.notSupported("rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw TWCResultSet.notSupported("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw TWCResultSet.notSupported("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw TWCResultSet.notSupported("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw TWCResultSet.notSupported("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw TWCResultSet.notSupported("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw TWCResultSet.notSupported("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw TWCResultSet.notSupported("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw TWCResultSet.notSupported("updateDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw TWCResultSet.notSupported("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw TWCResultSet.notSupported("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw TWCResultSet.notSupported("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw TWCResultSet.notSupported("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw TWCResultSet.notSupported("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_OBJECT_METHOD);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_OBJECT_METHOD);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw TWCResultSet.notSupported("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw TWCResultSet.notSupported("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw TWCResultSet.notSupported("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw TWCResultSet.notSupported("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw TWCResultSet.notSupported("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw TWCResultSet.notSupported("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw TWCResultSet.notSupported("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw TWCResultSet.notSupported("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw TWCResultSet.notSupported("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw TWCResultSet.notSupported("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw TWCResultSet.notSupported("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw TWCResultSet.notSupported("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw TWCResultSet.notSupported("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_OBJECT_METHOD);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_OBJECT_METHOD);
    }

    @Override
    public void insertRow() throws SQLException {
        throw TWCResultSet.notSupported("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw TWCResultSet.notSupported("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw TWCResultSet.notSupported("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw TWCResultSet.notSupported("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw TWCResultSet.notSupported("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw TWCResultSet.notSupported("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw TWCResultSet.notSupported("moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw TWCResultSet.notSupported(GET_OBJECT_METHOD);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getRef");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getArray");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw TWCResultSet.notSupported(GET_OBJECT_METHOD);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getRef");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getBlob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getArray");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(columnLabel);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(columnLabel);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getURL");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw TWCResultSet.notSupported("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw TWCResultSet.notSupported("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw TWCResultSet.notSupported("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw TWCResultSet.notSupported("updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw TWCResultSet.notSupported("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw TWCResultSet.notSupported("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw TWCResultSet.notSupported("getHoldability");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw TWCResultSet.notSupported("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw TWCResultSet.notSupported("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw TWCResultSet.notSupported("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw TWCResultSet.notSupported("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getNString");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw TWCResultSet.notSupported("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw TWCResultSet.notSupported("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_ASCII_STREAM_METHOD);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BINARY_STREAM_METHOD);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CHARACTER_STREAM_METHOD);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_BLOB_METHOD);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_CLOB_METHOD);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw TWCResultSet.notSupported(UPDATE_NCLOB_METHOD);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw TWCResultSet.notSupported(GET_OBJECT_METHOD);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw TWCResultSet.notSupported(GET_OBJECT_METHOD);
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TWCMessageUtil.getMessage("0022"), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.RESULTSET_CLOSED.getErrorCode());
        }
    }

    private int columnLabel2columnIndex(String columnLabel) throws SQLException {
        if (null == columnLabel) {
            throw new SQLException(TWCMessageUtil.getMessage("0018"), TWCSQLState.INVALID_COLUMN.getState(), TWCSQLErrorCode.NULL_NOT_VALID_COLUMN_NAME.getErrorCode());
        }
        Integer index = this.columnLookup.get(columnLabel.toUpperCase());
        if (null == index) {
            throw new SQLException(TWCMessageUtil.getMessage("0017"), TWCSQLState.INVALID_COLUMN.getState(), TWCSQLErrorCode.NULL_NOT_VALID_COLUMN_INDEX.getErrorCode());
        }
        return index;
    }

    private Object columnValue(String columnLabel) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        int index = this.columnLabel2columnIndex(columnLabel);
        Object value = this.row.get().get(index - 1);
        this.wasNull.set(null == value);
        return value;
    }

    private Object columnValue(int index) throws SQLException {
        this.checkOpen();
        this.checkValidRow();
        if (index <= 0 || index > this.resultSetMetaData.getColumnCount()) {
            throw new SQLException(TWCMessageUtil.getMessage("0016", index), TWCSQLState.INVALID_COLUMN.getState(), TWCSQLErrorCode.OUT_OF_BOUNDS_COLUMN_INDEX.getErrorCode());
        }
        Object value = this.row.get().get(index - 1);
        this.wasNull.set(null == value);
        return value;
    }

    private void checkValidRow() throws SQLException {
        if (null == this.row.get()) {
            throw new SQLException(TWCMessageUtil.getMessage("0021"), TWCSQLState.INVALID_CURSOR_POSITION.getState(), TWCSQLErrorCode.INVALID_CURSOR_ROW.getErrorCode());
        }
    }

    private static Number toNumber(Object value) throws SQLException {
        if (null == value) {
            return 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new SQLException(TWCMessageUtil.getMessage("0020", value, value.getClass().getCanonicalName()), TWCSQLState.DATA_CONVERSION_ERROR.getState(), TWCSQLErrorCode.INVALID_NUMBER.getErrorCode());
    }

    private static Boolean toBoolean(Object value) throws SQLException {
        if (null == value) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("1".equals(value)) {
                return true;
            }
            if ("0".equals(value)) {
                return false;
            }
        } else if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            if (1 == byteValue) {
                return true;
            }
            if (0 == byteValue) {
                return false;
            }
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            if (1 == shortValue) {
                return true;
            }
            if (0 == shortValue) {
                return false;
            }
        } else if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            if (1 == integerValue) {
                return true;
            }
            if (0 == integerValue) {
                return false;
            }
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            if (1L == longValue) {
                return true;
            }
            if (0L == longValue) {
                return false;
            }
        }
        throw new SQLException(TWCMessageUtil.getMessage("0082", value, value.getClass().getCanonicalName()), TWCSQLState.DATA_CONVERSION_ERROR.getState(), TWCSQLErrorCode.INVALID_BOOLEAN.getErrorCode());
    }

    private static Map<String, Integer> constructColumnLookupMap(TWCResultSetMetaData resultMD) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 1; i <= resultMD.getColumnCount(); ++i) {
            result.put(resultMD.getColumnLabel(i).toUpperCase(), i);
        }
        return Collections.unmodifiableMap(result);
    }

    private static SQLFeatureNotSupportedException notSupported(String s) {
        return new SQLFeatureNotSupportedException(TWCMessageUtil.getMessage("0023", s), TWCSQLState.FEATURE_NOT_SUPPORTED.getState(), TWCSQLErrorCode.JDBC_FEATURE_NOT_SUPPORTED.getErrorCode());
    }

    static abstract class TWCResultSetFactory {
        private static final String TABLE_STR = "TABLE";
        private static final Collector<Table, List<Column>, List<Column>> columnListCollector = Collector.of(ArrayList::new, (ll, t) -> ll.addAll(new ArrayList<Column>(new ArrayList<Column>(t.getColumns()))), (ll1, ll2) -> {
            ll1.addAll(ll2);
            return ll1;
        }, new Collector.Characteristics[0]);
        private static final Collector<Schema, List<String>, List<String>> tableListCollector = Collector.of(ArrayList::new, (ll, s) -> ll.addAll(new ArrayList(s.getTables().stream().map(Table::getName).collect(Collectors.toList()))), (ll1, ll2) -> {
            ll1.addAll(ll2);
            return ll1;
        }, new Collector.Characteristics[0]);
        private static final Collector<Catalog, List<String>, List<String>> schemaListCollector = Collector.of(ArrayList::new, (ll, c) -> ll.addAll(c.getSchemas().stream().map(s -> s.getName().value()).collect(Collectors.toList())), (ll1, ll2) -> {
            ll1.addAll(ll2);
            return ll1;
        }, new Collector.Characteristics[0]);
        private static final Collector<Schema, Map<String, List<Column>>, Map<String, List<Column>>> tableGroupingColumnListCollector = Collector.of(TreeMap::new, (map, s) -> map.putAll(new TreeMap<String, List<Column>>(s.getTables().stream().collect(Collectors.groupingBy(Table::getName, columnListCollector)))), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
        private static final Collector<Catalog, Map<String, List<String>>, Map<String, List<String>>> schemaGroupingTableListCollector = Collector.of(TreeMap::new, (map, c) -> map.putAll(new TreeMap<String, List<String>>(c.getSchemas().stream().collect(Collectors.groupingBy(s -> s.getName().value(), tableListCollector)))), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
        private static final Collector<Catalog, Map<String, Map<String, List<Column>>>, Map<String, Map<String, List<Column>>>> schemaGroupingTableGroupingColumnListCollector = Collector.of(TreeMap::new, (map, c) -> map.putAll(new TreeMap<String, Map<String, List<Column>>>(c.getSchemas().stream().collect(Collectors.groupingBy(s -> s.getName().value(), tableGroupingColumnListCollector)))), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);

        TWCResultSetFactory() {
        }

        private static boolean filterNotMatching(String value, Optional<String> pattern) {
            return pattern.isPresent() && (pattern.get().length() == 0 || !value.toUpperCase().matches(pattern.get().toUpperCase()));
        }

        private static boolean filterNotMatching(String value, List<String> patterns) {
            return !patterns.isEmpty() && !patterns.contains(value);
        }

        private static Map<String, List<String>> generateCatalogs2SchemasMap(List<Catalog> mdCatalogs) {
            return new TreeMap<String, List<String>>(mdCatalogs.stream().collect(Collectors.groupingBy(c -> c.getName().value(), schemaListCollector)));
        }

        private static Map<String, Map<String, List<String>>> generateCatalogs2Schemas2TablesMap(List<Catalog> mdCatalogs) {
            return new TreeMap<String, Map<String, List<String>>>(mdCatalogs.stream().collect(Collectors.groupingBy(c -> c.getName().value(), schemaGroupingTableListCollector)));
        }

        private static Map<String, Map<String, Map<String, List<Column>>>> generateCatalogs2Schemas2Tables2ColumnsMap(List<Catalog> mdCatalogs) {
            return new TreeMap<String, Map<String, Map<String, List<Column>>>>(mdCatalogs.stream().collect(Collectors.groupingBy(c -> c.getName().value(), schemaGroupingTableGroupingColumnListCollector)));
        }

        private static String convertJDBCMetachars(String input) {
            if (null == input) {
                return null;
            }
            return input.replaceAll("_", ".").replaceAll("%", ".*");
        }

        static TWCResultSet constructEmptyResultSet(ColumnInfo[] columns) throws SQLException {
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            Iterator<List<Object>> resultsIterator = Collections.emptyIterator();
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructTableTypesResultSet(ColumnInfo[] columns) throws SQLException {
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            rows.add(Collections.singletonList(TABLE_STR));
            Iterator<List<Object>> resultsIterator = rows.iterator();
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructColumnPrivilegesResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Optional<String> tableNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(tableNamePattern));
            Optional<String> columnNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(columnNamePattern));
            Map<String, Map<String, Map<String, List<Column>>>> catalogs2schemas2tables2columns = TWCResultSetFactory.generateCatalogs2Schemas2Tables2ColumnsMap(mdCatalogs);
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map.Entry<String, Map<String, Map<String, List<Column>>>> catalogEntry : catalogs2schemas2tables2columns.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                for (Map.Entry<String, Map<String, List<Column>>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    if (TWCResultSetFactory.filterNotMatching(schemaEntry.getKey(), schemaPatternOptional)) continue;
                    for (Map.Entry<String, List<Column>> tableEntry : schemaEntry.getValue().entrySet()) {
                        if (TWCResultSetFactory.filterNotMatching(tableEntry.getKey(), tableNamePatternOptional)) continue;
                        tableEntry.getValue().sort(Comparator.comparingInt(Column::getOrdinal));
                        for (Column column : tableEntry.getValue()) {
                            if (TWCResultSetFactory.filterNotMatching(column.getName(), columnNamePatternOptional)) continue;
                            Object[] currentRowAsArray = new Object[columns.length];
                            Arrays.fill(currentRowAsArray, null);
                            currentRowAsArray[0] = catalogEntry.getKey();
                            currentRowAsArray[1] = schemaEntry.getKey();
                            currentRowAsArray[2] = tableEntry.getKey();
                            currentRowAsArray[3] = column.getName();
                            currentRowAsArray[5] = "ALL";
                            currentRowAsArray[6] = "SELECT";
                            rows.add(Arrays.asList(currentRowAsArray));
                        }
                    }
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructPrimaryKeyResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern, String tableNamePattern) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Optional<String> tableNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(tableNamePattern));
            Map<String, Map<String, Map<String, List<Column>>>> catalogs2schemas2tables2columns = TWCResultSetFactory.generateCatalogs2Schemas2Tables2ColumnsMap(mdCatalogs);
            ArrayList rows = new ArrayList();
            for (Map.Entry<String, Map<String, Map<String, List<Column>>>> catalogEntry : catalogs2schemas2tables2columns.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                for (Map.Entry<String, Map<String, List<Column>>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    if (TWCResultSetFactory.filterNotMatching(schemaEntry.getKey(), schemaPatternOptional)) continue;
                    for (Map.Entry<String, List<Column>> tableEntry : schemaEntry.getValue().entrySet()) {
                        if (TWCResultSetFactory.filterNotMatching(tableEntry.getKey(), tableNamePatternOptional)) continue;
                        tableEntry.getValue().sort(Comparator.comparingInt(Column::getOrdinal));
                        int seqNo = 0;
                        for (Column column : tableEntry.getValue()) {
                            if (!column.getIsKey().booleanValue()) continue;
                            ArrayList<Object> currentRowAsArray = new ArrayList<Object>();
                            currentRowAsArray.add(0, catalogEntry.getKey());
                            currentRowAsArray.add(1, schemaEntry.getKey());
                            currentRowAsArray.add(2, tableEntry.getKey());
                            currentRowAsArray.add(3, column.getName());
                            currentRowAsArray.add(4, ++seqNo);
                            currentRowAsArray.add(5, tableEntry.getKey() + "_PK");
                            rows.add(currentRowAsArray);
                        }
                    }
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructColumnsResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Optional<String> tableNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(tableNamePattern));
            Optional<String> columnNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(columnNamePattern));
            Map<String, Map<String, Map<String, List<Column>>>> catalogs2schemas2tables2columns = TWCResultSetFactory.generateCatalogs2Schemas2Tables2ColumnsMap(mdCatalogs);
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map.Entry<String, Map<String, Map<String, List<Column>>>> catalogEntry : catalogs2schemas2tables2columns.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                for (Map.Entry<String, Map<String, List<Column>>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    if (TWCResultSetFactory.filterNotMatching(schemaEntry.getKey(), schemaPatternOptional)) continue;
                    for (Map.Entry<String, List<Column>> tableEntry : schemaEntry.getValue().entrySet()) {
                        if (TWCResultSetFactory.filterNotMatching(tableEntry.getKey(), tableNamePatternOptional)) continue;
                        tableEntry.getValue().sort(Comparator.comparingInt(Column::getOrdinal));
                        int ordinal = 0;
                        for (Column column : tableEntry.getValue()) {
                            ++ordinal;
                            if (TWCResultSetFactory.filterNotMatching(column.getName(), columnNamePatternOptional)) continue;
                            Object[] currentRowAsArray = new Object[columns.length];
                            Arrays.fill(currentRowAsArray, null);
                            int jdbcType = MetadataUtils.inferDatatypeAsJDBC(column.getDatatype());
                            currentRowAsArray[0] = catalogEntry.getKey();
                            currentRowAsArray[1] = schemaEntry.getKey();
                            currentRowAsArray[2] = tableEntry.getKey();
                            currentRowAsArray[3] = column.getName();
                            currentRowAsArray[4] = jdbcType;
                            currentRowAsArray[5] = MetadataUtils.inferDatatypeName(column.getDatatype(), column.getPrecision(), column.getScale(), column.getPrecision());
                            currentRowAsArray[6] = column.getPrecision();
                            switch (jdbcType) {
                                case 4: {
                                    currentRowAsArray[9] = 10;
                                    break;
                                }
                                case 8: {
                                    currentRowAsArray[9] = 2;
                                    break;
                                }
                            }
                            currentRowAsArray[10] = column.getNullable() != false ? ColumnInfo.NullConstraint.NULLABLE.getNullConstraint() : ColumnInfo.NullConstraint.NO_NULLS.getNullConstraint();
                            currentRowAsArray[15] = Column.Datatype.VARCHAR.equals((Object)column.getDatatype()) ? column.getPrecision() : null;
                            currentRowAsArray[16] = ordinal;
                            currentRowAsArray[17] = column.getNullable() != false ? "YES" : "NO";
                            currentRowAsArray[22] = "NO";
                            currentRowAsArray[23] = "NO";
                            rows.add(Arrays.asList(currentRowAsArray));
                        }
                    }
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructTablePrivilegesResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern, String tableNamePattern) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Optional<String> tableNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(tableNamePattern));
            Map<String, Map<String, List<String>>> catalogs2Schemas2Tables = TWCResultSetFactory.generateCatalogs2Schemas2TablesMap(mdCatalogs);
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : catalogs2Schemas2Tables.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                for (Map.Entry<String, List<String>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    if (TWCResultSetFactory.filterNotMatching(schemaEntry.getKey(), schemaPatternOptional)) continue;
                    schemaEntry.getValue().sort(Comparator.naturalOrder());
                    for (String tableName : schemaEntry.getValue()) {
                        if (TWCResultSetFactory.filterNotMatching(tableName, tableNamePatternOptional)) continue;
                        Object[] currentRowAsArray = new Object[columns.length];
                        Arrays.fill(currentRowAsArray, null);
                        currentRowAsArray[0] = catalogEntry.getKey();
                        currentRowAsArray[1] = schemaEntry.getKey();
                        currentRowAsArray[2] = tableName;
                        currentRowAsArray[4] = "ALL";
                        currentRowAsArray[5] = "SELECT";
                        rows.add(Arrays.asList(currentRowAsArray));
                    }
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructTablesResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Optional<String> tableNamePatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(tableNamePattern));
            ArrayList<String> typesPatterns = null != types && types.length > 0 ? Arrays.asList(types) : new ArrayList<String>();
            Map<String, Map<String, List<String>>> catalogs2Schemas2Tables = TWCResultSetFactory.generateCatalogs2Schemas2TablesMap(mdCatalogs);
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map.Entry<String, Map<String, List<String>>> catalogEntry : catalogs2Schemas2Tables.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                for (Map.Entry<String, List<String>> schemaEntry : catalogEntry.getValue().entrySet()) {
                    if (TWCResultSetFactory.filterNotMatching(schemaEntry.getKey(), schemaPatternOptional)) continue;
                    schemaEntry.getValue().sort(Comparator.naturalOrder());
                    for (String tableName : schemaEntry.getValue()) {
                        if (TWCResultSetFactory.filterNotMatching(tableName, tableNamePatternOptional) || TWCResultSetFactory.filterNotMatching(TABLE_STR, typesPatterns)) continue;
                        Object[] currentRowAsArray = new Object[columns.length];
                        Arrays.fill(currentRowAsArray, null);
                        currentRowAsArray[0] = catalogEntry.getKey();
                        currentRowAsArray[1] = schemaEntry.getKey();
                        currentRowAsArray[2] = tableName;
                        currentRowAsArray[3] = TABLE_STR;
                        rows.add(Arrays.asList(currentRowAsArray));
                    }
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructCatalogsResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs) throws SQLException {
            List catalogs = mdCatalogs.stream().map(c -> c.getName().value()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            for (String catalogName : catalogs) {
                rows.add(Collections.singletonList(catalogName));
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructSchemasResultSet(ColumnInfo[] columns, List<Catalog> mdCatalogs, String catalogPattern, String schemaPattern) throws SQLException {
            Optional<String> catalogPatternOptional = Optional.ofNullable(catalogPattern);
            Optional<String> schemaPatternOptional = Optional.ofNullable(TWCResultSetFactory.convertJDBCMetachars(schemaPattern));
            Map<String, List<String>> catalogs2Schemas = TWCResultSetFactory.generateCatalogs2SchemasMap(mdCatalogs);
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Map.Entry<String, List<String>> catalogEntry : catalogs2Schemas.entrySet()) {
                if (TWCResultSetFactory.filterNotMatching(catalogEntry.getKey(), catalogPatternOptional)) continue;
                catalogEntry.getValue().sort(Comparator.naturalOrder());
                for (String schema : catalogEntry.getValue()) {
                    if (TWCResultSetFactory.filterNotMatching(schema, schemaPatternOptional)) continue;
                    List<Object> currentRow = Arrays.asList(schema, catalogEntry.getKey());
                    rows.add(currentRow);
                }
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }

        static TWCResultSet constructTypeInfoResultSet(ColumnInfo[] columns) throws SQLException {
            List<Integer> supportedSQLDataTypes = Arrays.asList(MetadataUtils.inferDatatypeAsJDBC(Column.Datatype.DATE), MetadataUtils.inferDatatypeAsJDBC(Column.Datatype.FLOAT), MetadataUtils.inferDatatypeAsJDBC(Column.Datatype.INTEGER), MetadataUtils.inferDatatypeAsJDBC(Column.Datatype.VARCHAR));
            supportedSQLDataTypes.sort(Comparator.naturalOrder());
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            for (Integer sqlType : supportedSQLDataTypes) {
                Object[] currentRow = new Object[columns.length];
                Arrays.fill(currentRow, null);
                currentRow[0] = MetadataUtils.convertSupportedSQLTypeToString(sqlType);
                currentRow[1] = sqlType;
                currentRow[6] = ColumnInfo.NullConstraint.NULLABLE.getNullConstraint();
                currentRow[7] = false;
                currentRow[8] = 0;
                currentRow[9] = false;
                currentRow[10] = false;
                currentRow[11] = false;
                currentRow[13] = 0;
                currentRow[14] = 0;
                switch (sqlType) {
                    case 91: {
                        currentRow[2] = 0;
                        break;
                    }
                    case 4: {
                        currentRow[2] = 0;
                        currentRow[17] = 10;
                        break;
                    }
                    case 8: {
                        currentRow[2] = 0;
                        currentRow[17] = 2;
                        break;
                    }
                    case 12: {
                        currentRow[2] = 1024;
                        break;
                    }
                }
                rows.add(Arrays.asList(currentRow));
            }
            Iterator<List<Object>> resultsIterator = rows.iterator();
            TWCResultSetMetaData resultSetMeta = new TWCResultSetMetaData(Arrays.asList(columns));
            return new TWCResultSet(null, null, resultSetMeta, resultsIterator, null, null, null, null, null, null, null, null, null);
        }
    }
}

