/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc;

import com.ibm.cognos.jdbc.twc.ColumnInfo;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLErrorCode;
import com.ibm.cognos.jdbc.twc.messages.TWCSQLState;
import com.ibm.cognos.jdbc.twc.metadata.generated.Catalog;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.metadata.generated.Schema;
import com.ibm.cognos.jdbc.twc.sqlparser.BoundedColumn;
import com.ibm.cognos.jdbc.twc.sqlparser.ColumnIdentifierEntity;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class TWCResultSetMetaData
implements ResultSetMetaData {
    private final List<ColumnInfo> columnInfo;

    TWCResultSetMetaData(List<ColumnInfo> columnInformation) {
        this.columnInfo = Collections.unmodifiableList(Objects.requireNonNull(columnInformation, TWCMessageUtil.getMessage("0007", "columnInformation")));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(TWCMessageUtil.getMessage("0009", iface), TWCSQLState.JAVA_FUNCTION.getState(), TWCSQLErrorCode.INVALID_UNWRAP.getErrorCode());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnInfo.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumn(column).isSearchable();
    }

    private boolean getFalseResult(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getFalseResult(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).getNullContraint().getNullConstraint();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumn(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getColumnAlias();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumn(column).getSchemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumn(column).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumn(column).getCatalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getColumnTypeJDBC();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.getColumn(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.getFalseResult(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String result;
        ColumnInfo currentColumn = this.getColumn(column);
        String type = currentColumn.getColumnTypeName();
        switch (currentColumn.getColumnTypeJDBC()) {
            case 12: {
                result = String.class.getName();
                break;
            }
            case 91: {
                result = Date.class.getName();
                break;
            }
            case 8: {
                result = Double.class.getName();
                break;
            }
            case 4: {
                result = Integer.class.getName();
                break;
            }
            case 5: {
                result = Short.class.getName();
                break;
            }
            case -5: {
                result = Long.class.getName();
                break;
            }
            case 16: {
                result = Boolean.class.getName();
                break;
            }
            default: {
                throw new SQLException(TWCMessageUtil.getMessage("0015", type));
            }
        }
        return result;
    }

    private ColumnInfo getColumn(int column) throws SQLException {
        if (column <= 0 || column > this.columnInfo.size()) {
            throw new SQLException(TWCMessageUtil.getMessage("0016", column));
        }
        return this.columnInfo.get(column - 1);
    }

    static TWCResultSetMetaData fromBoundedColumns(Catalog catalog, Schema schema, List<BoundedColumn> boundedColumns) {
        LinkedList<ColumnInfo> columnInfoList = new LinkedList<ColumnInfo>();
        if (null == boundedColumns || boundedColumns.isEmpty()) {
            return new TWCResultSetMetaData(columnInfoList);
        }
        for (BoundedColumn boundedColumn : boundedColumns) {
            Column columnMd = boundedColumn.getColumn();
            ColumnIdentifierEntity columnIdentifier = boundedColumn.getColumnIdentifier();
            ColumnInfo.Builder builder = new ColumnInfo.Builder().setCatalog(catalog.getName().value()).setSchema(schema.getName().value()).setTable(boundedColumn.getTable().getName()).setColumnName(columnIdentifier.getColumn()).setColumnAlias(columnIdentifier.getAlias()).setDataType(columnMd.getDatatype()).setPrecision(columnMd.getPrecision()).setScale(columnMd.getScale()).setDisplaySize(columnMd.getPrecision());
            if (columnMd.getNullable().booleanValue()) {
                builder.setNullConstraint(ColumnInfo.NullConstraint.NULLABLE);
            } else {
                builder.setNullConstraint(ColumnInfo.NullConstraint.NO_NULLS);
            }
            columnInfoList.add(builder.build());
        }
        return new TWCResultSetMetaData(columnInfoList);
    }
}

