/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.metadata.generated;

import com.ibm.cognos.jdbc.twc.jackson.annotation.JsonCreator;
import com.ibm.cognos.jdbc.twc.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Scheme {
    HTTP("http:"),
    HTTPS("https:"),
    FILE("file:"),
    CLASSPATH("classpath:");

    private final String value;
    private static final Map<String, Scheme> CONSTANTS;

    private Scheme(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Scheme fromValue(String value) {
        Scheme constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Scheme>();
        for (Scheme c : Scheme.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

