/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.org.apache.avro;

import com.ibm.cognos.jdbc.twc.org.apache.avro.AvroRuntimeException;
import com.ibm.cognos.jdbc.twc.org.apache.avro.SchemaValidationStrategy;
import com.ibm.cognos.jdbc.twc.org.apache.avro.SchemaValidator;
import com.ibm.cognos.jdbc.twc.org.apache.avro.ValidateAll;
import com.ibm.cognos.jdbc.twc.org.apache.avro.ValidateCanBeRead;
import com.ibm.cognos.jdbc.twc.org.apache.avro.ValidateCanRead;
import com.ibm.cognos.jdbc.twc.org.apache.avro.ValidateLatest;
import com.ibm.cognos.jdbc.twc.org.apache.avro.ValidateMutualRead;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;

    public SchemaValidatorBuilder strategy(SchemaValidationStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = new ValidateCanRead();
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = new ValidateCanBeRead();
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = new ValidateMutualRead();
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return new ValidateLatest(this.strategy);
    }

    public SchemaValidator validateAll() {
        this.valid();
        return new ValidateAll(this.strategy);
    }

    private void valid() {
        if (null == this.strategy) {
            throw new AvroRuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }
}

