/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLLexer;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;
import java.util.Objects;

abstract class AbstractLiteralValue
implements LiteralValue,
TWCMessageKeys {
    static final String SINGLE_QUOTE_STR;
    private final String literalValue;
    private final Column.Datatype datatype;
    private final ParseTree ctx;

    protected AbstractLiteralValue(String literal, Column.Datatype type, ParseTree context) {
        Objects.requireNonNull(literal, TWCMessageUtil.getMessage("0007", "literal"));
        Objects.requireNonNull(type, TWCMessageUtil.getMessage("0007", "type"));
        Objects.requireNonNull(context, TWCMessageUtil.getMessage("0007", "context"));
        this.literalValue = literal;
        this.datatype = type;
        this.ctx = context;
    }

    @Override
    public String getLiteralValue() {
        return this.literalValue;
    }

    @Override
    public Column.Datatype getDataType() {
        return this.datatype;
    }

    @Override
    public String getTypeName() {
        return MetadataUtils.inferDatatypeName(this.getDataType(), -1, -1, -1);
    }

    @Override
    public int getTypeJDBC() {
        return MetadataUtils.inferDatatypeAsJDBC(this.getDataType());
    }

    @Override
    public boolean isDataTypeCompatible(Column.Datatype providedDataType) {
        return this.datatype.equals((Object)providedDataType);
    }

    @Override
    public boolean isNullLiteralValue() {
        return false;
    }

    @Override
    public ParseTree getContext() {
        return this.ctx;
    }

    public String toString() {
        return this.getLiteralValue();
    }

    static {
        String singleQuoteStr = TWCSQLLexer.VOCABULARY.getLiteralName(7);
        SINGLE_QUOTE_STR = singleQuoteStr.substring(1, singleQuoteStr.length() - 1);
    }
}

