/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import java.util.Objects;

class BinaryFilterExpression
extends AbstractFilterExpression
implements TWCMessageKeys {
    private final FilterIdentifierEntity leftOperand;
    private final FilterIdentifierEntity rightOperand;

    private BinaryFilterExpression(FilterIdentifierEntity leftOp, FilterExpression.ComparisonOperator op, FilterIdentifierEntity rightOp, ParseTree ctx) {
        super(op, ctx);
        Objects.requireNonNull(op, TWCMessageUtil.getMessage("0007", "op"));
        Objects.requireNonNull(leftOp, TWCMessageUtil.getMessage("0007", "leftOp"));
        Objects.requireNonNull(rightOp, TWCMessageUtil.getMessage("0007", "rightOp"));
        if (FilterExpression.ComparisonOperator.BETWEEN == op || FilterExpression.ComparisonOperator.IN == op) {
            throw new IllegalArgumentException(TWCMessageUtil.getMessage("0073", op.getSymbolicName()));
        }
        this.leftOperand = leftOp;
        this.rightOperand = rightOp;
    }

    @Override
    public FilterExpression.FilterExpressionType getFilterExpressionType() {
        return FilterExpression.FilterExpressionType.BINARY;
    }

    FilterIdentifierEntity getLeftOperand() {
        return this.leftOperand;
    }

    FilterIdentifierEntity getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof BinaryFilterExpression) {
            BinaryFilterExpression filterExpression = (BinaryFilterExpression)entity;
            if (this.getLeftOperand().isEquivalent(filterExpression.getLeftOperand()) && this.getRightOperand().isEquivalent(filterExpression.getRightOperand())) {
                return this.getFilterOperator().equals(filterExpression.getFilterOperator());
            }
            if (this.getLeftOperand().isEquivalent(filterExpression.getRightOperand()) && this.getRightOperand().isEquivalent(filterExpression.getLeftOperand())) {
                return FilterExpression.ComparisonOperator.GTE.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.LTE.equals(filterExpression.getFilterOperator()) || FilterExpression.ComparisonOperator.GT.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.LT.equals(filterExpression.getFilterOperator()) || FilterExpression.ComparisonOperator.LTE.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.GTE.equals(filterExpression.getFilterOperator()) || FilterExpression.ComparisonOperator.LT.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.GT.equals(filterExpression.getFilterOperator()) || FilterExpression.ComparisonOperator.EQUAL.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.EQUAL.equals(filterExpression.getFilterOperator()) || FilterExpression.ComparisonOperator.NE.equals(this.getFilterOperator()) && FilterExpression.ComparisonOperator.NE.equals(filterExpression.getFilterOperator());
            }
        }
        return false;
    }

    @Override
    public FilterIdentifierValuesResolver accept(FilterIdentifierValuesResolver visitor) {
        FilterExpression.ComparisonOperator operator;
        Objects.requireNonNull(visitor, TWCMessageUtil.getMessage("0007", "visitor"));
        FilterIdentifierEntity visitorFilterIdentifier = visitor.getFilterIdentifier().getFilterIdentifier();
        if (this.isFilterVisitorMatchingOperandIdentifiers(visitorFilterIdentifier, visitor.strictlyMatchFilterIdentifiers()) && (FilterExpression.ComparisonOperator.GT.equals(operator = (FilterExpression.ComparisonOperator)this.getFilterOperator()) || FilterExpression.ComparisonOperator.LT.equals(operator) || FilterExpression.ComparisonOperator.NE.equals(operator))) {
            return new FilterIdentifierValuesResolver(visitor.getFilterIdentifier(), visitor.strictlyMatchFilterIdentifiers(), true, true);
        }
        return null;
    }

    private boolean isFilterVisitorMatchingOperandIdentifiers(FilterIdentifierEntity visitorFilterIdentifier, boolean strictMatch) {
        if (strictMatch) {
            return visitorFilterIdentifier.isEquivalent(this.getLeftOperand()) && visitorFilterIdentifier.isEquivalent(this.getRightOperand());
        }
        return visitorFilterIdentifier.getColumn().compareToIgnoreCase(this.getLeftOperand().getColumn()) == 0 && visitorFilterIdentifier.getColumn().compareToIgnoreCase(this.getRightOperand().getColumn()) == 0;
    }

    @Override
    public boolean accept(FilterConditionEvaluator evaluator) {
        return evaluator.visit(this);
    }

    public String toString() {
        return this.getLeftOperand() + " " + this.getFilterOperator().getLiteralName() + " " + this.getRightOperand();
    }

    static class Builder {
        private FilterIdentifierEntity aLeftOperand;
        private FilterExpression.ComparisonOperator aFilterOperator;
        private FilterIdentifierEntity aRightOperand;
        private ParseTree aCtx;

        Builder() {
        }

        Builder setLeftOperand(FilterIdentifierEntity filterOperand) {
            this.aLeftOperand = filterOperand;
            return this;
        }

        Builder setFilterOperator(FilterExpression.ComparisonOperator filterOperator) {
            this.aFilterOperator = filterOperator;
            return this;
        }

        Builder setRightOperand(FilterIdentifierEntity filterOperand) {
            this.aRightOperand = filterOperand;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        BinaryFilterExpression build() {
            return new BinaryFilterExpression(this.aLeftOperand, this.aFilterOperator, this.aRightOperand, this.aCtx);
        }
    }
}

