/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.metadata.generated.Column;
import com.ibm.cognos.jdbc.twc.sqlparser.BinaryFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.ComplexFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.ConjunctionFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.DateLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.DisjunctionFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.DoubleLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpressionVisitor;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierEntity;
import com.ibm.cognos.jdbc.twc.sqlparser.LiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.LongLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.NegationFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.StringLiteralValue;
import com.ibm.cognos.jdbc.twc.sqlparser.UnaryFilterExpression;
import com.ibm.cognos.jdbc.twc.util.MetadataUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FilterConditionEvaluator
implements FilterExpressionVisitor<Boolean>,
TWCMessageKeys {
    private List<Object> row;
    private Map<String, Integer> filterIdentifier2RowIdx;
    private List<String> ignoredFilterIdentifiers;

    public FilterConditionEvaluator(List<Object> theRow, Map<String, Integer> columnName2RowPosMap, List<String> ignoredIdentifiers) {
        this.row = Objects.requireNonNull(theRow, TWCMessageUtil.getMessage("0007", "theRow"));
        this.filterIdentifier2RowIdx = Objects.requireNonNull(columnName2RowPosMap, TWCMessageUtil.getMessage("0007", "columnName2RowPosMap"));
        this.ignoredFilterIdentifiers = Objects.requireNonNull(ignoredIdentifiers, TWCMessageUtil.getMessage("0007", "ignoredIdentifiers"));
    }

    public void setRow(List<Object> theRow) {
        this.row = Objects.requireNonNull(theRow, TWCMessageUtil.getMessage("0007", "theRow"));
    }

    public void setFilterIdentifier2RowIdxMap(Map<String, Integer> columnName2RowPosMap) {
        this.filterIdentifier2RowIdx = Objects.requireNonNull(columnName2RowPosMap, TWCMessageUtil.getMessage("0007", "columnName2RowPosMap"));
    }

    @Override
    public Boolean visit(BinaryFilterExpression binaryFE) {
        FilterIdentifierEntity leftOperand = binaryFE.getLeftOperand();
        FilterIdentifierEntity rightOperand = binaryFE.getRightOperand();
        if (this.ignoredFilterIdentifiers.contains(leftOperand.getColumn().toUpperCase()) || this.ignoredFilterIdentifiers.contains(rightOperand.getColumn().toUpperCase())) {
            return true;
        }
        int leftValueIdx = this.filterIdentifier2RowIdx.get(leftOperand.getColumn());
        int rightValueIdx = this.filterIdentifier2RowIdx.get(rightOperand.getColumn());
        Object leftValue = this.row.get(leftValueIdx);
        Object rightValue = this.row.get(rightValueIdx);
        return FilterConditionEvaluator.compareValues(leftValue, rightValue, (FilterExpression.ComparisonOperator)binaryFE.getFilterOperator(), leftOperand.getDataType());
    }

    @Override
    public Boolean visit(UnaryFilterExpression unaryFE) {
        FilterIdentifierEntity operand = unaryFE.getOperand();
        if (this.ignoredFilterIdentifiers.contains(operand.getColumn().toUpperCase())) {
            return true;
        }
        List<LiteralValue> literals = unaryFE.getValues();
        int operandValueIdx = this.filterIdentifier2RowIdx.get(operand.getColumn());
        Object value = this.row.get(operandValueIdx);
        return FilterConditionEvaluator.compareValueLiterals(value, literals, (FilterExpression.ComparisonOperator)unaryFE.getFilterOperator(), operand.getDataType());
    }

    @Override
    public Boolean visit(NegationFilterExpression negationFE) {
        return !negationFE.getFilterExpression().accept(this);
    }

    @Override
    public Boolean visit(ComplexFilterExpression complexFE) {
        Iterator<FilterExpression> it = complexFE.getFilterExpressions().iterator();
        FilterExpression current = it.next();
        boolean result = current.accept(this);
        while (it.hasNext()) {
            FilterExpression logicalFE = it.next();
            current = it.next();
            if ((!result || !(logicalFE instanceof ConjunctionFilterExpression)) && (result || !(logicalFE instanceof DisjunctionFilterExpression))) continue;
            result = current.accept(this);
        }
        return result;
    }

    static boolean compareValues(Object leftValue, Object rightValue, FilterExpression.ComparisonOperator op, Column.Datatype dataType) {
        switch (dataType) {
            case INTEGER: {
                return FilterConditionEvaluator.compareSimpleValues((Integer)leftValue, (Integer)rightValue, op);
            }
            case FLOAT: {
                return FilterConditionEvaluator.compareSimpleValues((Double)leftValue, (Double)rightValue, op);
            }
            case DATE: {
                return FilterConditionEvaluator.compareDates((Date)leftValue, (Date)rightValue, op);
            }
            case VARCHAR: {
                return FilterConditionEvaluator.compareSimpleValues((String)leftValue, (String)rightValue, op);
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0076", MetadataUtils.inferDatatypeName(dataType, -1, -1, -1)));
    }

    static boolean compareValueLiterals(Object value, List<LiteralValue> literals, FilterExpression.ComparisonOperator op, Column.Datatype dataType) {
        switch (dataType) {
            case INTEGER: {
                return FilterConditionEvaluator.compareIntToLiterals((Integer)value, literals, op);
            }
            case FLOAT: {
                return FilterConditionEvaluator.compareDoubleToLiterals((Double)value, literals, op);
            }
            case DATE: {
                return FilterConditionEvaluator.compareDateToLiterals((Date)value, literals, op);
            }
            case VARCHAR: {
                return FilterConditionEvaluator.compareStringToLiterals((String)value, literals, op);
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0077", MetadataUtils.inferDatatypeName(dataType, -1, -1, -1)));
    }

    static <T> boolean compareSimpleValues(Comparable<T> leftValue, T rightValue, FilterExpression.ComparisonOperator op) {
        if (null == leftValue || null == rightValue) {
            return false;
        }
        switch (op) {
            case EQUAL: {
                return leftValue.compareTo(rightValue) == 0;
            }
            case NE: {
                return leftValue.compareTo(rightValue) != 0;
            }
            case GT: {
                return leftValue.compareTo(rightValue) > 0;
            }
            case GTE: {
                return leftValue.compareTo(rightValue) >= 0;
            }
            case LT: {
                return leftValue.compareTo(rightValue) < 0;
            }
            case LTE: {
                return leftValue.compareTo(rightValue) <= 0;
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0078", op.getLiteralName(), leftValue.getClass().getSimpleName().toUpperCase()));
    }

    static boolean compareDates(Date leftValue, Date rightValue, FilterExpression.ComparisonOperator op) {
        if (null == leftValue || null == rightValue) {
            return false;
        }
        LocalDate leftDate = leftValue.toLocalDate();
        LocalDate rightDate = rightValue.toLocalDate();
        switch (op) {
            case EQUAL: {
                return leftDate.isEqual(rightDate);
            }
            case NE: {
                return !leftDate.isEqual(rightDate);
            }
            case GT: {
                return leftDate.isAfter(rightDate);
            }
            case GTE: {
                return leftDate.isEqual(rightDate) || leftDate.isAfter(rightDate);
            }
            case LT: {
                return leftDate.isBefore(rightDate);
            }
            case LTE: {
                return leftDate.isEqual(rightDate) || leftDate.isBefore(rightDate);
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0078", op.getLiteralName(), "DATE"));
    }

    static boolean compareIntToLiterals(Integer value, List<LiteralValue> literals, FilterExpression.ComparisonOperator op) {
        if (null == value) {
            return FilterExpression.ComparisonOperator.EQUAL.equals(op) && literals.get(0).isNullLiteralValue();
        }
        if (FilterExpression.ComparisonOperator.NE.equals(op) && literals.get(0).isNullLiteralValue()) {
            return true;
        }
        if (literals.get(0).isNullLiteralValue()) {
            return false;
        }
        LongLiteralValue longLiteral = (LongLiteralValue)literals.get(0);
        switch (op) {
            case EQUAL: {
                return (long)value.intValue() == longLiteral.getLongValue();
            }
            case NE: {
                return (long)value.intValue() != longLiteral.getLongValue();
            }
            case GT: {
                return (long)value.intValue() > longLiteral.getLongValue();
            }
            case GTE: {
                return (long)value.intValue() >= longLiteral.getLongValue();
            }
            case LT: {
                return (long)value.intValue() < longLiteral.getLongValue();
            }
            case LTE: {
                return (long)value.intValue() <= longLiteral.getLongValue();
            }
            case BETWEEN: {
                LongLiteralValue secondLongLiteral = (LongLiteralValue)literals.get(1);
                return (long)value.intValue() >= longLiteral.getLongValue() && (long)value.intValue() <= secondLongLiteral.getLongValue();
            }
            case IN: {
                int counter = 0;
                Iterator<LiteralValue> it = literals.iterator();
                while (it.hasNext() && (long)value.intValue() != ((LongLiteralValue)it.next()).getLongValue()) {
                    ++counter;
                }
                return counter != literals.size();
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0079", op.getLiteralName(), "INTEGER"));
    }

    static boolean compareDoubleToLiterals(Double value, List<LiteralValue> literals, FilterExpression.ComparisonOperator op) {
        if (null == value) {
            return FilterExpression.ComparisonOperator.EQUAL.equals(op) && literals.get(0).isNullLiteralValue();
        }
        if (FilterExpression.ComparisonOperator.NE.equals(op) && literals.get(0).isNullLiteralValue()) {
            return true;
        }
        if (literals.get(0).isNullLiteralValue()) {
            return false;
        }
        DoubleLiteralValue doubleLiteral = (DoubleLiteralValue)literals.get(0);
        switch (op) {
            case EQUAL: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) == 0;
            }
            case NE: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) != 0;
            }
            case GT: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) > 0;
            }
            case GTE: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) >= 0;
            }
            case LT: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) < 0;
            }
            case LTE: {
                return Double.compare(value, doubleLiteral.getDoubleValue()) <= 0;
            }
            case BETWEEN: {
                DoubleLiteralValue secondDoubleLiteral = (DoubleLiteralValue)literals.get(1);
                return Double.compare(value, doubleLiteral.getDoubleValue()) >= 0 && Double.compare(value, secondDoubleLiteral.getDoubleValue()) <= 0;
            }
            case IN: {
                int counter = 0;
                Iterator<LiteralValue> it = literals.iterator();
                while (it.hasNext() && Double.compare(value, ((DoubleLiteralValue)it.next()).getDoubleValue()) != 0) {
                    ++counter;
                }
                return counter != literals.size();
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0079", op.getLiteralName(), "DOUBLE"));
    }

    static boolean compareDateToLiterals(Date value, List<LiteralValue> literals, FilterExpression.ComparisonOperator op) {
        if (null == value) {
            return FilterExpression.ComparisonOperator.EQUAL.equals(op) && literals.get(0).isNullLiteralValue();
        }
        if (FilterExpression.ComparisonOperator.NE.equals(op) && literals.get(0).isNullLiteralValue()) {
            return true;
        }
        if (literals.get(0).isNullLiteralValue()) {
            return false;
        }
        LocalDate dateValue = value.toLocalDate();
        DateLiteralValue dateLiteral = (DateLiteralValue)literals.get(0);
        switch (op) {
            case EQUAL: {
                return dateValue.isEqual(dateLiteral.getDateValue());
            }
            case NE: {
                return !dateValue.isEqual(dateLiteral.getDateValue());
            }
            case GT: {
                return dateValue.isAfter(dateLiteral.getDateValue());
            }
            case GTE: {
                return dateValue.isEqual(dateLiteral.getDateValue()) || dateValue.isAfter(dateLiteral.getDateValue());
            }
            case LT: {
                return dateValue.isBefore(dateLiteral.getDateValue());
            }
            case LTE: {
                return dateValue.isEqual(dateLiteral.getDateValue()) || dateValue.isBefore(dateLiteral.getDateValue());
            }
            case BETWEEN: {
                DateLiteralValue secondDateLiteral = (DateLiteralValue)literals.get(1);
                return !(!dateValue.isEqual(dateLiteral.getDateValue()) && !dateValue.isAfter(dateLiteral.getDateValue()) || !dateValue.isEqual(secondDateLiteral.getDateValue()) && !dateValue.isBefore(secondDateLiteral.getDateValue()));
            }
            case IN: {
                int counter = 0;
                Iterator<LiteralValue> it = literals.iterator();
                while (it.hasNext() && !dateValue.isEqual(((DateLiteralValue)it.next()).getDateValue())) {
                    ++counter;
                }
                return counter != literals.size();
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0079", op.getLiteralName(), "DATE"));
    }

    static boolean compareStringToLiterals(String value, List<LiteralValue> literals, FilterExpression.ComparisonOperator op) {
        if (null == value) {
            return FilterExpression.ComparisonOperator.EQUAL.equals(op) && literals.get(0).isNullLiteralValue();
        }
        if (FilterExpression.ComparisonOperator.NE.equals(op) && literals.get(0).isNullLiteralValue()) {
            return true;
        }
        if (literals.get(0).isNullLiteralValue()) {
            return false;
        }
        StringLiteralValue stringLiteral = (StringLiteralValue)literals.get(0);
        switch (op) {
            case EQUAL: {
                return value.compareTo(stringLiteral.getLiteralValue()) == 0;
            }
            case NE: {
                return value.compareTo(stringLiteral.getLiteralValue()) != 0;
            }
            case GT: {
                return value.compareTo(stringLiteral.getLiteralValue()) > 0;
            }
            case GTE: {
                return value.compareTo(stringLiteral.getLiteralValue()) >= 0;
            }
            case LT: {
                return value.compareTo(stringLiteral.getLiteralValue()) < 0;
            }
            case LTE: {
                return value.compareTo(stringLiteral.getLiteralValue()) <= 0;
            }
            case BETWEEN: {
                StringLiteralValue secondStringLiteral = (StringLiteralValue)literals.get(1);
                return value.compareTo(stringLiteral.getLiteralValue()) >= 0 && value.compareTo(secondStringLiteral.getLiteralValue()) <= 0;
            }
            case IN: {
                int counter = 0;
                Iterator<LiteralValue> it = literals.iterator();
                while (it.hasNext() && value.compareTo(it.next().getLiteralValue()) != 0) {
                    ++counter;
                }
                return counter != literals.size();
            }
        }
        throw new UnsupportedOperationException(TWCMessageUtil.getMessage("0079", op.getLiteralName(), "STRING"));
    }
}

