/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import com.ibm.cognos.jdbc.twc.sqlparser.generated.TWCSQLLexer;

interface FilterExpression
extends Entity {
    public Operator getFilterOperator();

    public boolean isUnary();

    public FilterExpressionType getFilterExpressionType();

    public FilterIdentifierValuesResolver accept(FilterIdentifierValuesResolver var1);

    public boolean accept(FilterConditionEvaluator var1);

    public static enum FilterExpressionType {
        UNARY,
        BINARY,
        CONJUNCTION,
        DISJUNCTION,
        NEGATION,
        COMPLEX;

    }

    public static enum LogicalOperator implements Operator
    {
        AND(18, TWCSQLLexer.VOCABULARY.getSymbolicName(18), TWCSQLLexer.VOCABULARY.getSymbolicName(18)),
        OR(19, TWCSQLLexer.VOCABULARY.getSymbolicName(19), TWCSQLLexer.VOCABULARY.getSymbolicName(19)),
        NOT(20, TWCSQLLexer.VOCABULARY.getSymbolicName(20), TWCSQLLexer.VOCABULARY.getSymbolicName(20));

        private final int type;
        private final String symbolicName;
        private final String literalName;

        private LogicalOperator(int typeId, String symbol, String literal) {
            this.type = typeId;
            this.symbolicName = symbol;
            this.literalName = literal;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getSymbolicName() {
            return this.symbolicName;
        }

        @Override
        public String getLiteralName() {
            return this.literalName;
        }
    }

    public static enum ComparisonOperator implements Operator
    {
        EQUAL(30, TWCSQLLexer.VOCABULARY.getSymbolicName(30), TWCSQLLexer.VOCABULARY.getLiteralName(30)),
        NE(31, TWCSQLLexer.VOCABULARY.getSymbolicName(31), TWCSQLLexer.VOCABULARY.getLiteralName(31)),
        GT(32, TWCSQLLexer.VOCABULARY.getSymbolicName(32), TWCSQLLexer.VOCABULARY.getLiteralName(32)),
        GTE(33, TWCSQLLexer.VOCABULARY.getSymbolicName(33), TWCSQLLexer.VOCABULARY.getLiteralName(33)),
        LT(34, TWCSQLLexer.VOCABULARY.getSymbolicName(34), TWCSQLLexer.VOCABULARY.getLiteralName(34)),
        LTE(35, TWCSQLLexer.VOCABULARY.getSymbolicName(35), TWCSQLLexer.VOCABULARY.getLiteralName(35)),
        BETWEEN(21, TWCSQLLexer.VOCABULARY.getSymbolicName(21), TWCSQLLexer.VOCABULARY.getSymbolicName(21)),
        IN(22, TWCSQLLexer.VOCABULARY.getSymbolicName(22), TWCSQLLexer.VOCABULARY.getSymbolicName(22));

        private final int type;
        private final String symbolicName;
        private final String literalName;

        private ComparisonOperator(int typeId, String symbol, String literal) {
            this.type = typeId;
            this.symbolicName = symbol;
            this.literalName = literal.startsWith("'") && literal.endsWith("'") ? literal.substring(1, literal.length() - 1) : literal;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getSymbolicName() {
            return this.symbolicName;
        }

        @Override
        public String getLiteralName() {
            return this.literalName;
        }
    }

    public static interface Operator {
        public int getType();

        public String getSymbolicName();

        public String getLiteralName();
    }
}

