/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.twc.sqlparser;

import com.ibm.cognos.jdbc.twc.messages.TWCMessageKeys;
import com.ibm.cognos.jdbc.twc.messages.TWCMessageUtil;
import com.ibm.cognos.jdbc.twc.org.antlr.v4.runtime.tree.ParseTree;
import com.ibm.cognos.jdbc.twc.sqlparser.AbstractFilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.Entity;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterConditionEvaluator;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterExpression;
import com.ibm.cognos.jdbc.twc.sqlparser.FilterIdentifierValuesResolver;
import java.util.Objects;

class NegationFilterExpression
extends AbstractFilterExpression
implements TWCMessageKeys {
    private final FilterExpression filterExpression;

    private NegationFilterExpression(FilterExpression filter, ParseTree ctx) {
        super(FilterExpression.LogicalOperator.NOT, ctx);
        Objects.requireNonNull(filter, TWCMessageUtil.getMessage("0007", "filter"));
        this.filterExpression = filter;
    }

    FilterExpression getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public boolean isEquivalent(Entity entity) {
        if (entity instanceof NegationFilterExpression) {
            return this.getFilterExpression().isEquivalent(((NegationFilterExpression)entity).getFilterExpression());
        }
        return false;
    }

    @Override
    public FilterExpression.FilterExpressionType getFilterExpressionType() {
        return FilterExpression.FilterExpressionType.NEGATION;
    }

    @Override
    public FilterIdentifierValuesResolver accept(FilterIdentifierValuesResolver visitor) {
        Objects.requireNonNull(visitor, TWCMessageUtil.getMessage("0007", "visitor"));
        FilterIdentifierValuesResolver valuesResolver = this.filterExpression.accept(visitor);
        if (null == valuesResolver) {
            return null;
        }
        if (valuesResolver.representsContradiction()) {
            valuesResolver.setContradictory(!valuesResolver.isContradictory());
        } else {
            valuesResolver.reverseIntervals();
        }
        return valuesResolver;
    }

    @Override
    public boolean accept(FilterConditionEvaluator evaluator) {
        return evaluator.visit(this);
    }

    public String toString() {
        return NOT_STR + " " + OPEN_PARENTHESIS_STR + this.getFilterExpression() + CLOSE_PARENTHESIS_STR;
    }

    static class Builder {
        FilterExpression aFilterExpression;
        ParseTree aCtx;

        Builder() {
        }

        Builder setFilterExpression(FilterExpression filterExpression) {
            this.aFilterExpression = filterExpression;
            return this;
        }

        Builder setContext(ParseTree ctx) {
            this.aCtx = ctx;
            return this;
        }

        NegationFilterExpression build() {
            return new NegationFilterExpression(this.aFilterExpression, this.aCtx);
        }
    }
}

