/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.connection;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jmd.connection.IJMDConnection;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import com.ibm.cognos.jmd.exception.JMDDecodeException;
import com.ibm.cognos.jmd.exception.JMDEncodeException;
import com.ibm.cognos.jmd.exception.JMDInvalidConnectionException;
import com.ibm.cognos.jmd.util.ICodec;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Handler;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="JDBCConnection")
@XmlType(propOrder={"url", "certified"})
@JsonIgnoreProperties(value={"traceHandler", "connection"})
public class JDBCConnection
implements IJMDConnection {
    Handler traceHandler;
    protected Connection connection;
    protected boolean certified;
    protected String url;

    public JDBCConnection() {
    }

    public JDBCConnection(Connection c) throws JMDConnectionException {
        try {
            if (c == null || c.isClosed()) {
                throw new JMDInvalidConnectionException();
            }
        }
        catch (Exception e) {
            throw new JMDConnectionException(e);
        }
        this.connection = c;
        this.setCertified();
        try {
            this.url = this.connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            this.url = "";
        }
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        this.traceOn();
        return this.connection;
    }

    @Override
    public void releaseConnection() {
        this.traceOff();
    }

    @Override
    public void closeConnection() throws JMDConnectionException {
        this.releaseConnection();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new JMDConnectionException(e);
            }
            this.connection = null;
        }
    }

    @Override
    public void close() throws JMDConnectionException {
        this.closeConnection();
    }

    @Override
    public String encode(ICodec codec) throws JMDEncodeException {
        return codec.encode(this);
    }

    @Override
    public void decode(ICodec codec, String theText) throws JMDDecodeException {
        JDBCConnection o = (JDBCConnection)codec.decode(JDBCConnection.class, theText);
        this.certified = o.certified;
        this.url = o.url;
    }

    protected void setCertified() {
        this.certified = this.connection != null && this.connection instanceof IAdaptorConnection;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public boolean isCertified() {
        return this.certified;
    }

    public void setCertified(boolean isCertified) {
        this.certified = isCertified;
    }

    @Override
    public void setTraceHandler(Handler handler) {
        this.traceHandler = handler;
    }

    protected void traceOn() {
        IAdaptorConnection c;
        if (this.traceHandler != null && this.isCertified() && (c = (IAdaptorConnection)this.connection) != null && !c.isTracing()) {
            c.startTrace(this.traceHandler, true, ".*");
        }
    }

    protected void traceOff() {
        IAdaptorConnection c;
        if (this.isCertified() && (c = (IAdaptorConnection)this.connection) != null && c.isTracing()) {
            c.stopTrace();
        }
    }
}

