/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.connection;

import com.ibm.cognos.jdbc.adaptor.ConnectionFactory;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jdbc.adaptor.util.UncertifiedAdaptorException;
import com.ibm.cognos.jmd.connection.JDBCConnection;
import com.ibm.cognos.jmd.exception.JMDAuthorizationException;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import com.ibm.cognos.jmd.exception.JMDDatabaseServerVersionNotSupported;
import com.ibm.cognos.jmd.exception.JMDDecodeException;
import com.ibm.cognos.jmd.exception.JMDInvalidConnectionException;
import com.ibm.cognos.jmd.exception.JMDJdbcDriverVersionNotSupported;
import com.ibm.cognos.jmd.util.ICodec;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="JDBCConnectionSpecification")
@XmlType(propOrder={"driverClass", "uncertifiedAllowed", "properties"})
public class JDBCConnectionSpecification
extends JDBCConnection {
    private static final Object PASSWORD = "password";
    private static final Object OBFUCATED_PWD = "********";
    private String driverClass;
    private Properties properties;
    private boolean uncertifiedAllowed;

    public JDBCConnectionSpecification() {
    }

    public JDBCConnectionSpecification(String theUrl, String theDriverClass, Properties theProperties, boolean allowUncertifiedConnections, Handler handler) throws JMDConnectionException {
        this.setUrl(theUrl);
        this.setDriverClass(theDriverClass);
        this.setProperties(theProperties);
        this.setUncertifiedAllowed(allowUncertifiedConnections);
        this.setTraceHandler(handler);
    }

    public JDBCConnectionSpecification(String theUrl, String theDriverClass, Properties theProperties, boolean allowUncertifiedConnections) throws JMDConnectionException {
        this(theUrl, theDriverClass, theProperties, allowUncertifiedConnections, null);
    }

    public JDBCConnectionSpecification(String theUrl, String theDriverClass, Properties theProperties) throws JMDConnectionException {
        this(theUrl, theDriverClass, theProperties, false, null);
    }

    @Override
    public Connection getConnection() throws JMDConnectionException {
        if (this.connection == null) {
            this.open();
        }
        return super.getConnection();
    }

    @Override
    public void decode(ICodec codec, String theText) throws JMDDecodeException {
        JDBCConnectionSpecification o = (JDBCConnectionSpecification)codec.decode(JDBCConnectionSpecification.class, theText);
        this.certified = o.certified;
        this.driverClass = o.driverClass;
        this.properties = o.properties;
        this.uncertifiedAllowed = o.uncertifiedAllowed;
        this.url = o.url;
    }

    private void open() throws JMDConnectionException {
        Driver driver;
        try {
            driver = (Driver)Class.forName(this.driverClass).newInstance();
        }
        catch (Exception e) {
            throw new JMDInvalidConnectionException(e);
        }
        try {
            if (!driver.acceptsURL(this.url)) {
                throw new JMDInvalidConnectionException();
            }
        }
        catch (Exception e) {
            throw new JMDConnectionException(e);
        }
        try {
            this.connection = ConnectionFactory.createAndWrapConnection((Driver)driver, (String)this.url, (Properties)this.properties, (boolean)this.uncertifiedAllowed);
            if (this.connection instanceof IAdaptorConnection) {
                this.checkConnectionBlacklist(this.connection);
            }
        }
        catch (SQLInvalidAuthorizationSpecException ae) {
            throw new JMDAuthorizationException(ae);
        }
        catch (UncertifiedAdaptorException u) {
            throw u;
        }
        catch (Exception e) {
            throw new JMDConnectionException(e);
        }
        this.setCertified();
    }

    private void checkConnectionBlacklist(Connection connection) throws JMDJdbcDriverVersionNotSupported, JMDDatabaseServerVersionNotSupported {
        Map info = ((IAdaptorConnection)connection).getExtraInformation();
        if (info != null && info.containsKey("blacklistDriver")) {
            throw new JMDJdbcDriverVersionNotSupported();
        }
        if (info != null && info.containsKey("blacklistServer")) {
            throw new JMDDatabaseServerVersionNotSupported();
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String newDriverClass) {
        this.driverClass = newDriverClass;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newProperties) {
        this.properties = newProperties;
    }

    public boolean isUncertifiedAllowed() {
        return this.uncertifiedAllowed;
    }

    public void setUncertifiedAllowed(boolean newUncertifiedAllowed) {
        this.uncertifiedAllowed = newUncertifiedAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("url: ");
        result.append(this.url);
        result.append(", driverClass: ");
        result.append(this.driverClass);
        if (this.properties != null) {
            result.append(", properties: ");
            result.append(this.propertiesToString());
        }
        result.append(", uncertifiedAllowed: ");
        result.append(this.uncertifiedAllowed);
        return result.toString();
    }

    private String propertiesToString() {
        if (this.properties.containsKey(PASSWORD)) {
            Properties tmp = (Properties)this.properties.clone();
            tmp.put(PASSWORD, OBFUCATED_PWD);
            return tmp.toString();
        }
        return this.properties.toString();
    }
}

