/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.CachedRowset;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.util.Counters;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class AbstractJDBCRequest {
    private HashMap<String, String> jdbcPatternCache = new HashMap();
    private static final String EMPTY_STRING = "";
    private static final String JDBC_ANY_STRING = "%";
    private static final String JDBC_ANY_CHAR = "_";
    private String JDBC_ESCAPE_CHAR;
    protected static final int JDBC_MAJOR_3 = 3;
    protected static final int JDBC_MAJOR_4 = 4;
    private String escapedAnyJDBCString;
    private String escapedAnyJDBCChar;
    private String escapedEscapeChar;
    protected boolean eod = false;
    DatabaseMetaData metadata;
    CachedRowset cachedData;
    protected int jdbcMajor;
    protected int jdbcMinor;
    protected Counters events;

    public AbstractJDBCRequest(Counters stats, DatabaseMetaData dmd, CachedRowset data) throws JMDImportException {
        this.metadata = dmd;
        this.cachedData = data;
        this.events = stats;
        try {
            this.JDBC_ESCAPE_CHAR = this.metadata.getSearchStringEscape();
        }
        catch (SQLException e) {
            throw new JMDImportException(e);
        }
        this.escapedEscapeChar = this.JDBC_ESCAPE_CHAR + this.JDBC_ESCAPE_CHAR;
        this.escapedAnyJDBCString = this.JDBC_ESCAPE_CHAR + JDBC_ANY_STRING;
        this.escapedAnyJDBCChar = this.JDBC_ESCAPE_CHAR + JDBC_ANY_CHAR;
        try {
            this.jdbcMajor = this.metadata.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            this.jdbcMajor = 3;
        }
        try {
            this.jdbcMinor = this.metadata.getJDBCMinorVersion();
        }
        catch (SQLException e) {
            this.jdbcMinor = 0;
        }
    }

    public abstract CachedRow getNextRow() throws JMDImportException;

    protected String filterAsJDBCPattern(Filter filter) throws JMDImportException {
        if (!this.jdbcPatternCache.containsKey(filter.getExpression())) {
            String pattern = filter.getExpression();
            String jdbcURL = null;
            try {
                jdbcURL = this.metadata.getURL();
            }
            catch (SQLException e) {
                jdbcURL = EMPTY_STRING;
            }
            if (pattern != null) {
                if (jdbcURL != null && !jdbcURL.contains("jdbc:domsql:")) {
                    pattern = pattern.replace(this.JDBC_ESCAPE_CHAR, this.escapedEscapeChar);
                    pattern = pattern.replace(JDBC_ANY_STRING, this.escapedAnyJDBCString);
                    pattern = pattern.replace(JDBC_ANY_CHAR, this.escapedAnyJDBCChar);
                }
                pattern = pattern.replaceAll("\ufffds", JDBC_ANY_STRING);
                if ((pattern = pattern.replaceAll("\ufffdc", JDBC_ANY_CHAR)).equals(JDBC_ANY_STRING)) {
                    pattern = null;
                }
            }
            this.jdbcPatternCache.put(filter.getExpression(), pattern);
        }
        return this.jdbcPatternCache.get(filter.getExpression());
    }

    protected String convertEmptyStringToNull(String s) {
        if (s != null && s.trim().equals(EMPTY_STRING)) {
            return null;
        }
        return s;
    }
}

