/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.IResultSetIterator;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.SelectionCriteria;

public abstract class AbstractResultSetIterator
implements IResultSetIterator {
    protected static final String EMPTY_STRING = "";
    private CachedRow nextRow;
    int numberOfFilters;
    protected SelectionCriteria selectionCriteria;
    private boolean initialized = false;

    public AbstractResultSetIterator(SelectionCriteria theSelectionCriteria) {
        this.selectionCriteria = theSelectionCriteria;
        this.numberOfFilters = this.selectionCriteria.getObjectType().getNumberOfFilters();
    }

    private void initialize() throws JMDImportException {
        this.skipNonMatchingRows();
        this.initialized = true;
    }

    @Override
    public boolean hasNext() throws JMDImportException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.nextRow != null;
    }

    @Override
    public CachedRow next() throws JMDImportException {
        if (!this.initialized) {
            this.initialize();
        }
        CachedRow currentRow = this.nextRow;
        this.skipNonMatchingRows();
        return currentRow;
    }

    private void skipNonMatchingRows() throws JMDImportException {
        while ((this.nextRow = this.getNextRow()) != null) {
            boolean isMatch = true;
            for (int i = 0; i < this.numberOfFilters && isMatch; ++i) {
                String item = this.nextRow.getString(i);
                if (item == null) {
                    item = EMPTY_STRING;
                }
                if (((Filter)this.selectionCriteria.getFilterList().get(i)).asPattern().matcher(item).matches()) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return;
        }
    }

    protected abstract CachedRow getNextRow() throws JMDImportException;
}

