/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import com.ibm.cognos.jmd.util.ObjectPool;
import com.ibm.cognos.jmd.util.Utility;

public abstract class AbstractRowHandler {
    protected ObjectPool<Attribute> attributePool = new ObjectPool();
    IJMDModel model;
    SelectionCriteria selectionCriteria;
    String[] pathParts = new String[5];
    String[] lastAncestorPathParts = new String[5];
    JMDModelObject lastAncestor;

    public AbstractRowHandler(IJMDModel mod, SelectionCriteria sc) {
        this.model = mod;
        this.selectionCriteria = sc;
        this.lastAncestor = null;
    }

    public abstract void handleRow(CachedRow var1);

    protected JMDModelObject addToModel(JMDModelObject object, CachedRow row) {
        int pathLength = object.getObjectType().getPathLength();
        for (int i = 0; i < pathLength; ++i) {
            this.pathParts[i] = row.getString(i);
        }
        if (this.pathsMatch(object)) {
            return this.lastAncestor.mergeChildByName(object);
        }
        System.arraycopy(this.pathParts, 0, this.lastAncestorPathParts, 0, 5);
        JMDModelObject result = this.model.add(object, this.pathParts);
        this.lastAncestor = result.getParent();
        return result;
    }

    private boolean pathsMatch(JMDModelObject object) {
        if (this.lastAncestor == null) {
            return false;
        }
        int depth = object.getObjectType().getDepth() - 1;
        if (depth != this.lastAncestor.getObjectType().getDepth()) {
            return false;
        }
        if (this.pathParts.equals(this.lastAncestorPathParts)) {
            return true;
        }
        for (int i = 0; i < depth; ++i) {
            if (Utility.isSame(this.pathParts[i], this.lastAncestorPathParts[i])) continue;
            return false;
        }
        return true;
    }

    protected void setAttributes(JMDModelObject mo, CachedRow row) {
        int[] attributeMap = JDBCColumnMaps.getAttributeMap(mo.getObjectType());
        for (AttributeType attributeType : this.selectionCriteria.getAttributeTypes()) {
            Object value;
            int column = attributeMap[attributeType.ordinal()];
            if (column == -1 || (value = row.get(column)) == null && attributeType != AttributeType.NAME) continue;
            this.setAttribute(mo, new Attribute(attributeType, value));
        }
    }

    protected void setAttribute(JMDModelObject mo, Attribute a) {
        mo.getAttributes().add(this.attributePool.pool(a));
    }

    protected void makeKeyName(CachedRow row, int nameCol, int catalogCol, int schemaCol, int tableCol) {
        if (row.getString(nameCol) == null) {
            StringBuffer id = new StringBuffer();
            id.append(row.getString(catalogCol));
            id.append(row.getString(schemaCol));
            id.append(row.getString(tableCol));
            row.set(nameCol, id.toString());
        }
    }
}

