/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractJDBCRequest;
import com.ibm.cognos.jmd.importer.AbstractResultSetIterator;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.IResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import com.ibm.cognos.jmd.util.ObjectPool;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractedNestedJDBCRequest
extends AbstractJDBCRequest {
    protected ObjectPool<Object> objectPool = new ObjectPool();
    IResultSetIterator iterator;
    ResultSet rs;

    AbstractedNestedJDBCRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(resultSetCache.getCounters(), dmd, resultSetCache.getCachedRowset(selectionCriteria.getObjectType()));
        this.createIterator(resultSetCache, selectionCriteria);
    }

    @Override
    public CachedRow getNextRow() throws JMDImportException {
        CachedRow row = null;
        if (!this.eod) {
            try {
                if (this.rs != null && this.rs.next()) {
                    return this.createAndAddRowToCache();
                }
                this.closeResultSet();
                while (this.iterator.hasNext()) {
                    this.createResultSetFromIteratorRow(this.iterator.next());
                    if (this.rs != null && this.rs.next()) {
                        return this.createAndAddRowToCache();
                    }
                    this.closeResultSet();
                }
                this.eod = true;
            }
            catch (SQLException e) {
                this.closeResultSet();
                throw this.wrapException(e);
            }
        }
        return row;
    }

    private void closeResultSet() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = null;
        }
    }

    protected AbstractResultSetIterator createTableNameIterator(ResultSetCache cache, SelectionCriteria sc) throws JMDImportException {
        FilterList filters = new FilterList();
        filters.addAll(sc.getFilterList());
        filters.add(new Filter("\ufffds"));
        return cache.getIterator(new SelectionCriteria(ObjectType.TABLE, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    protected abstract CachedRow createAndAddRowToCache() throws SQLException;

    protected abstract void createIterator(ResultSetCache var1, SelectionCriteria var2) throws JMDImportException;

    protected abstract void createResultSetFromIteratorRow(CachedRow var1) throws SQLException;

    protected abstract JMDImportException wrapException(Exception var1);
}

