/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDCatalogException;
import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.ObjectType;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CatalogRequest
extends AbstractJDBCRequest {
    private static final String API_NAME = "getCatalogs()";
    private static final String API_NAME_ROWS = "getCatalogs() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int NUMBER_OF_CACHED_COLUMNS = 1;
    public static final int JDBC_TABLE_CAT = 1;
    ResultSet rs;

    CatalogRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache) throws JMDImportException {
        super(resultSetCache.getCounters(), dmd, resultSetCache.getCachedRowset(ObjectType.CATALOG));
        try {
            this.events.incrementCounter(API_NAME);
            this.rs = this.metadata.getCatalogs();
        }
        catch (SQLException e) {
            throw new JMDCatalogException(e);
        }
    }

    @Override
    public CachedRow getNextRow() throws JMDCatalogException {
        CachedRow row = null;
        if (!this.eod) {
            try {
                if (this.rs.next()) {
                    this.events.incrementCounter(API_NAME_ROWS);
                    row = new CachedRow(1);
                    row.set(0, this.convertEmptyStringToNull(this.rs.getString(1)));
                    this.cachedData.add(row);
                } else {
                    this.rs.close();
                    this.eod = true;
                }
            }
            catch (SQLException e) {
                throw new JMDCatalogException(e);
            }
        }
        return row;
    }
}

