/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.importer.AbstractRowHandler;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.SelectionCriteria;

public class FunctionColumnRowHandler
extends AbstractRowHandler {
    private static final String UNNAMED_FUNCTIONCOLUMN = "UNNAMED-FUNCTIONCOLUMN #%d";
    private static final int RETURN_VALUE_ORDINAL_POSITION = 0;
    private String lastSignatureName = null;
    private int nullNameCounter;

    public FunctionColumnRowHandler(IJMDModel mod, SelectionCriteria sc) {
        super(mod, sc);
    }

    @Override
    public void handleRow(CachedRow row) {
        ObjectType objectType;
        String signatureName = row.getString(3);
        if (!signatureName.equals(this.lastSignatureName)) {
            this.nullNameCounter = 0;
            this.lastSignatureName = signatureName;
        }
        Attribute.FunctionColumnType functionColumnType = null;
        if (row.getInt(11) == 0) {
            objectType = ObjectType.RETURN_VALUE;
        } else {
            switch (row.getInt(10)) {
                case 4: {
                    objectType = ObjectType.RETURN_VALUE;
                    break;
                }
                case 5: {
                    objectType = ObjectType.FUNCTION_ROWSET;
                    break;
                }
                case 1: {
                    objectType = ObjectType.FUNCTION_COLUMN;
                    functionColumnType = Attribute.FunctionColumnType.INPUT;
                    break;
                }
                case 3: {
                    objectType = ObjectType.FUNCTION_COLUMN;
                    functionColumnType = Attribute.FunctionColumnType.OUTPUT;
                    break;
                }
                case 2: {
                    objectType = ObjectType.FUNCTION_COLUMN;
                    functionColumnType = Attribute.FunctionColumnType.INPUT_OUTPUT;
                    break;
                }
                default: {
                    objectType = ObjectType.FUNCTION_COLUMN;
                    functionColumnType = Attribute.FunctionColumnType.UNKNOWN;
                }
            }
        }
        int[] attributeMap = JDBCColumnMaps.getAttributeMap(objectType);
        JMDModelObject mo = new JMDModelObject(objectType, new Attribute[0]);
        for (AttributeType attributeType : this.selectionCriteria.getAttributeTypes()) {
            int column = attributeMap[attributeType.ordinal()];
            if (column == -1) continue;
            Object value = row.get(column);
            if (attributeType == AttributeType.NAME && value == null) {
                value = String.format(UNNAMED_FUNCTIONCOLUMN, ++this.nullNameCounter);
            } else if (attributeType == AttributeType.TYPE) {
                value = functionColumnType;
            }
            if (value == null) continue;
            this.setAttribute(mo, new Attribute(attributeType, value));
        }
        this.addToModel(mo, row);
    }
}

