/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDFunctionException;
import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class FunctionsRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getFunctions()";
    private static final String API_NAME_ROWS = "getFunctions() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int FUNCTIONNAME_COLUMN = 2;
    public static final int SIGNATURENAME_COLUMN = 3;
    public static final int FUNCTIONDESCRIPTION_COLUMN = 4;
    public static final int NUMBER_OF_CACHED_COLUMNS = 5;
    public static final int JDBC_FUNCTION_CAT = 1;
    public static final int JDBC_FUNCTION_SCHEM = 2;
    public static final int JDBC_FUNCTION_NAME = 3;
    public static final int JDBC_SPECIFIC_NAME = 6;
    public static final int JDBC_REMARKS = 4;
    String schemaPattern;
    String functionNamePattern;

    FunctionsRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        this.functionNamePattern = this.filterAsJDBCPattern((Filter)filters.get(2));
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(5);
        row.set(0, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(1))));
        row.set(1, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(2))));
        row.set(2, (Object)this.objectPool.pool(this.rs.getString(3)));
        row.set(3, (Object)this.objectPool.pool(this.rs.getString(6)));
        row.set(4, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(4))));
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        String catalog = row.getString(0);
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getFunctions(catalog, this.schemaPattern, this.functionNamePattern);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDFunctionException(e);
    }
}

