/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDIndexException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;

public class IndexInfoRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getIndexInfo()";
    private static final String API_NAME_ROWS = "getIndexInfo() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int TABLENAME_COLUMN = 2;
    public static final int INDEXNAME_COLUMN = 3;
    public static final int INDEXCOLUMNNAME_COLUMN = 4;
    public static final int SORT_ORDER_COLUMN = 5;
    public static final int UNIQUE_COLUMN = 6;
    public static final int TYPE_COLUMN = 7;
    public static final int CARDINALITY_COLUMN = 8;
    public static final int NUMBER_OF_CACHED_COLUMNS = 9;
    public static final int JDBC_TABLE_CAT = 1;
    public static final int JDBC_TABLE_SCHEM = 2;
    public static final int JDBC_TABLE_NAME = 3;
    public static final int JDBC_INDEX_NAME = 6;
    public static final int JDBC_COLUMN_NAME = 9;
    public static final int JDBC_ASC_OR_DESC = 10;
    public static final int JDBC_NON_UNIQUE = 4;
    public static final int JDBC_TYPE = 7;
    public static final int JDBC_CARDINALITY = 11;
    public static final String EXACT = "exact";
    private boolean approximate = true;

    IndexInfoRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        Set<String> options = selectionCriteria.getOptions();
        if (options.contains(EXACT)) {
            this.approximate = false;
        }
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(9);
        row.set(0, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(1))));
        row.set(1, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(2))));
        row.set(2, (Object)this.objectPool.pool(this.rs.getString(3)));
        row.set(3, (Object)this.objectPool.pool(this.rs.getString(6)));
        row.set(4, (Object)this.objectPool.pool(this.rs.getString(9)));
        row.set(5, (Object)this.objectPool.pool(this.rs.getString(10)));
        row.set(6, this.objectPool.pool(!this.rs.getBoolean(4)));
        row.set(7, this.objectPool.pool(this.rs.getInt(7)));
        int i = this.rs.getInt(11);
        if (this.rs.wasNull()) {
            row.set(8, null);
        } else {
            row.set(8, this.objectPool.pool(i));
        }
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        this.iterator = this.createTableNameIterator(resultSetCache, selectionCriteria);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getIndexInfo(row.getString(0), row.getString(1), row.getString(2), false, this.approximate);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDIndexException(e);
    }
}

