/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jdbc.adaptor.AdaptorJDBCTypes;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import java.lang.reflect.Field;
import java.util.HashMap;

public class JDBCColumnMaps {
    public static final int NA = -1;
    public static final int NONE = 0;
    private static final String UNKNOWN = "UNKNOWN";
    private static final int[][] ATTRIBUTE_COLUMN_MAP = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 6, 7, 8, -1}, {2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 8, -1, 4, 5, 6, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 8, -1, 4, 5, 6, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1}, {3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 11, -1, 5, 9, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1}, {4, 12, -1, 5, 9, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1}, {-1, 11, -1, 5, 9, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 12, -1, 5, 9, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1}, {5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private static int[] attributeMasks = null;
    private static HashMap<Integer, String> typeNames;

    public static final int[] getAttributeMap(ObjectType type) {
        return ATTRIBUTE_COLUMN_MAP[type.ordinal()];
    }

    public static final int getAttributeMask(ObjectType type) {
        if (attributeMasks == null) {
            JDBCColumnMaps.computeAttributeMasks();
        }
        return attributeMasks[type.ordinal()];
    }

    private static synchronized void computeAttributeMasks() {
        if (attributeMasks == null) {
            int[] masks = new int[ObjectType.values().length];
            for (ObjectType type : ObjectType.values()) {
                int typeOrd = type.ordinal();
                masks[typeOrd] = 0;
                for (AttributeType attribute : AttributeType.values()) {
                    if (ATTRIBUTE_COLUMN_MAP[typeOrd][attribute.ordinal()] == -1) continue;
                    masks[typeOrd] = AttributeType.pack(masks[typeOrd], attribute);
                }
            }
            attributeMasks = masks;
        }
    }

    private static synchronized void populateTypeNames() {
        if (typeNames == null) {
            HashMap<Integer, String> names = new HashMap<Integer, String>();
            for (Field f : AdaptorJDBCTypes.class.getDeclaredFields()) {
                try {
                    names.put(f.getInt(null), f.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            typeNames = names;
        }
    }

    public static String getAdaptorTypeAsString(Integer type) {
        String name;
        if (typeNames == null) {
            JDBCColumnMaps.populateTypeNames();
        }
        if ((name = typeNames.get(type)) == null) {
            name = UNKNOWN;
        }
        return name;
    }
}

