/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.importer.IJMDImporter;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.AttributeTypeList;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.IJMDSelector;
import com.ibm.cognos.jmd.selector.JMDSelector;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.util.ArrayList;

public class JDBCImportOptimizer {
    private static boolean oneStatementMode(int maxActiveStatements) {
        return maxActiveStatements != 0 && maxActiveStatements < 3;
    }

    public static IJMDImporter.CachingLevel optimizeCachingLevel(int maxActiveStatements, IJMDImporter.CachingLevel cachingLevel) {
        if (JDBCImportOptimizer.oneStatementMode(maxActiveStatements) && cachingLevel == IJMDImporter.CachingLevel.MINIMUM) {
            return IJMDImporter.CachingLevel.BEST;
        }
        return cachingLevel;
    }

    public static IJMDSelector optimizeSelections(IJMDSelector selector, int jdbcMajor, int maxActiveStatements, IJMDImporter.CachingLevel cachingLevel) {
        IJMDSelector optimized = new JMDSelector();
        optimized.getSelectionCriteria().addAll(selector.getSelectionCriteria());
        optimized = JDBCImportOptimizer.optimizeAttributeSelections(selector, jdbcMajor);
        optimized = JDBCImportOptimizer.expandOrSelections(optimized);
        optimized = JDBCImportOptimizer.expandTableSelections(cachingLevel, optimized);
        if (JDBCImportOptimizer.oneStatementMode(maxActiveStatements)) {
            optimized = JDBCImportOptimizer.expandCatalogSelections(optimized);
        }
        optimized = JDBCImportOptimizer.mergeTableTypeSelections(cachingLevel, optimized);
        optimized.sortSelections();
        optimized.removeRedundantSelections();
        return optimized;
    }

    private static IJMDSelector optimizeAttributeSelections(IJMDSelector selector, int jdbcMajor) {
        JMDSelector optimized = new JMDSelector();
        for (SelectionCriteria selection : selector.getSelectionCriteria()) {
            ObjectType type = selection.getObjectType();
            if (type == ObjectType.FUNCTION && jdbcMajor < 4) continue;
            int fullMask = JDBCColumnMaps.getAttributeMask(type);
            switch (type) {
                case INDEX: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.INDEX_COLUMN);
                    break;
                }
                case PRIMARY_KEY: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.PRIMARY_KEY_COLUMN);
                    break;
                }
                case IMPORTED_KEY: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.IMPORTED_KEY_COLUMN);
                    break;
                }
                case EXPORTED_KEY: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.EXPORTED_KEY_COLUMN);
                    break;
                }
                case PROCEDURE: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.PROCEDURE_SIGNATURE);
                    break;
                }
                case FUNCTION: {
                    fullMask |= JDBCColumnMaps.getAttributeMask(ObjectType.FUNCTION_SIGNATURE);
                    break;
                }
            }
            int packedAttributes = AttributeType.pack(selection.getAttributeTypes());
            SelectionCriteria sco = new SelectionCriteria(type, AttributeType.unpack(packedAttributes & fullMask), selection.getFilterList());
            sco.setOptions(selection.getOptions());
            optimized.getSelectionCriteria().add(sco);
        }
        return optimized;
    }

    private static IJMDSelector mergeTableTypeSelections(IJMDImporter.CachingLevel cachingLevel, IJMDSelector selector) {
        if (cachingLevel == IJMDImporter.CachingLevel.MINIMUM) {
            return selector;
        }
        JMDSelector optimized = new JMDSelector();
        ArrayList<SelectionCriteria> selectionCriteria = selector.getSelectionCriteria();
        int size = selectionCriteria.size();
        for (int i = 0; i < size; ++i) {
            SelectionCriteria sci = selectionCriteria.get(i);
            if (sci.getObjectType() != ObjectType.TABLE) {
                optimized.addSelection(sci);
                continue;
            }
            ArrayList<SelectionCriteria> criteriaToMerge = null;
            ArrayList filtersToMerge = null;
            boolean sameAttributes = true;
            int sciMask = 0;
            for (int j = i + 1; j < size; ++j) {
                SelectionCriteria scj = selectionCriteria.get(j);
                if (!JDBCImportOptimizer.areMergableTableSelections(sci, scj)) continue;
                if (criteriaToMerge == null) {
                    criteriaToMerge = new ArrayList<SelectionCriteria>();
                    criteriaToMerge.add(sci);
                    filtersToMerge = new FilterList();
                    filtersToMerge.add(sci.getFilterList().get(3));
                    sciMask = AttributeType.pack(sci.getAttributeTypes());
                }
                criteriaToMerge.add(scj);
                filtersToMerge.add(scj.getFilterList().get(3));
                sameAttributes = sameAttributes && sciMask == AttributeType.pack(scj.getAttributeTypes());
            }
            if (criteriaToMerge == null) {
                optimized.addSelection(sci);
                continue;
            }
            FilterList filters = new FilterList();
            filters.addAll(sci.getFilterList());
            filters.set(filters.size() - 1, new Filter((FilterList)filtersToMerge));
            SelectionCriteria newCriteria = new SelectionCriteria(ObjectType.TABLE, new AttributeTypeList(), filters);
            optimized.addSelection(newCriteria);
            if (sameAttributes) {
                newCriteria.setAttributeTypes(sci.getAttributeTypes());
            } else {
                optimized.getSelectionCriteria().addAll(criteriaToMerge);
            }
            selectionCriteria.removeAll(criteriaToMerge);
            --i;
            size -= criteriaToMerge.size();
        }
        return optimized;
    }

    private static boolean areMergableTableSelections(SelectionCriteria sca, SelectionCriteria scb) {
        return scb.getObjectType() == ObjectType.TABLE && ((Filter)sca.getFilterList().get(0)).equals(scb.getFilterList().get(0)) && ((Filter)sca.getFilterList().get(1)).equals(scb.getFilterList().get(1)) && ((Filter)sca.getFilterList().get(2)).equals(scb.getFilterList().get(2));
    }

    private static IJMDSelector expandOrSelections(IJMDSelector selector) {
        JMDSelector optimized = new JMDSelector();
        for (SelectionCriteria sc : selector.getSelectionCriteria()) {
            if (sc.getFilterList().hasOr()) {
                for (FilterList list : sc.getFilterList().asFiltersListsWithoutOrConstructs()) {
                    optimized.addSelection(new SelectionCriteria(sc.getObjectType(), sc.getAttributeTypes(), list));
                }
                continue;
            }
            optimized.addSelection(sc);
        }
        return optimized;
    }

    private static IJMDSelector expandTableSelections(IJMDImporter.CachingLevel cachingLevel, IJMDSelector selector) {
        if (cachingLevel == IJMDImporter.CachingLevel.MINIMUM) {
            return selector;
        }
        int size = selector.getSelectionCriteria().size();
        for (int i = 0; i < size; ++i) {
            SelectionCriteria sc = selector.getSelectionCriteria().get(i);
            ObjectType t = sc.getObjectType();
            if (t != ObjectType.EXPORTED_KEY && t != ObjectType.IMPORTED_KEY && t != ObjectType.INDEX && t != ObjectType.PRIMARY_KEY) continue;
            FilterList flist = new FilterList();
            flist.addAll(sc.getFilterList());
            flist.add(new Filter("\ufffds"));
            selector.addSelection(new SelectionCriteria(ObjectType.TABLE, new AttributeTypeList(), flist));
        }
        return selector;
    }

    private static IJMDSelector expandCatalogSelections(IJMDSelector selector) {
        int size = selector.getSelectionCriteria().size();
        for (int i = 0; i < size; ++i) {
            SelectionCriteria sc = selector.getSelectionCriteria().get(i);
            ObjectType t = sc.getObjectType();
            Filter catalogFilter = (Filter)sc.getFilterList().get(0);
            if (t != ObjectType.FUNCTION && t != ObjectType.FUNCTION_COLUMN && t != ObjectType.PROCEDURE && t != ObjectType.PROCEDURE_COLUMN && t != ObjectType.TABLE || !catalogFilter.hasWildCards()) continue;
            FilterList flist = new FilterList();
            flist.add(catalogFilter);
            selector.addSelection(new SelectionCriteria(ObjectType.CATALOG, new AttributeTypeList(), flist));
        }
        return selector;
    }
}

