/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jmd.connection.IJMDConnection;
import com.ibm.cognos.jmd.connection.JDBCConnection;
import com.ibm.cognos.jmd.exception.JMDBulkImportException;
import com.ibm.cognos.jmd.exception.JMDException;
import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.IJMDImporter;
import com.ibm.cognos.jmd.importer.IJMDProgressCallback;
import com.ibm.cognos.jmd.importer.JDBCImportOptimizer;
import com.ibm.cognos.jmd.importer.RequestHandler;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeList;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.IJMDSelector;
import com.ibm.cognos.jmd.selector.JMDSelector;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import com.ibm.cognos.jmd.util.Counters;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class JDBCImporter
implements IJMDImporter {
    public static final String STR_NUM_TABLES = "NumberOfTables";
    public static final int JDBC_MAJOR_3 = 3;
    public static final int JDBC_MAJOR_4 = 4;
    public static final int UNLIMITED_STATEMENTS = 0;
    public static final int MAX_JDBC_STATEMENT_NESTING = 3;
    private static Set<String> tableTypes = new HashSet<String>();
    private ResultSetCache resultSetCache = new ResultSetCache();
    ExecutorService workerPool;

    @Override
    public void execute(IJMDConnection connection, IJMDSelector selector, IJMDModel model, List<JMDException> exceptionList, IJMDImporter.CachingLevel cachingLevel, int degreeOfParallelism) throws JMDException {
        int maxStatements;
        int jdbcMajor;
        DatabaseMetaData metadata;
        try {
            metadata = connection.getConnection().getMetaData();
        }
        catch (SQLException sql) {
            throw new JMDException(sql);
        }
        try {
            jdbcMajor = metadata.getJDBCMajorVersion();
        }
        catch (SQLException e) {
            jdbcMajor = 3;
        }
        try {
            maxStatements = metadata.getMaxStatements();
        }
        catch (SQLException e) {
            maxStatements = 1;
        }
        this.resultSetCache.setCachingLevel(JDBCImportOptimizer.optimizeCachingLevel(maxStatements, cachingLevel));
        IJMDSelector selections = JDBCImportOptimizer.optimizeSelections(selector, jdbcMajor, maxStatements, cachingLevel);
        for (SelectionCriteria selection : selections.getSelectionCriteria()) {
            try {
                RequestHandler handler = new RequestHandler(model, this.resultSetCache, metadata, selection);
                handler.run();
            }
            catch (JMDImportException e1) {
                if (exceptionList == null) {
                    throw e1;
                }
                exceptionList.add(e1);
            }
            catch (Exception e2) {
                JMDImportException j = new JMDImportException(e2);
                if (exceptionList == null) {
                    throw j;
                }
                exceptionList.add(j);
            }
        }
        connection.releaseConnection();
    }

    @Override
    public Counters getCounters() {
        return this.resultSetCache.getCounters();
    }

    private static boolean isSqlServerUrl(String url) {
        return url.contains("jdbc:sqlserver:");
    }

    private static boolean isDatabaseDefined(String url) {
        String s = url.toUpperCase();
        return s.contains("DATABASE=") || s.contains("DATABASENAME=");
    }

    public static IJMDModel getCatalogsSchemas(IJMDConnection connection, List<JMDException> exceptions) throws JMDException {
        boolean removeTables = false;
        String url = ((JDBCConnection)connection).getUrl();
        JMDSelector selector = new JMDSelector();
        if (JDBCImporter.isSqlServerUrl(url) && !JDBCImporter.isDatabaseDefined(url)) {
            selector.addCatalogSelection("\ufffds", AttributeType.ALL);
            IJMDModel model = JDBCImporter.importModel(connection, selector, exceptions, removeTables);
            String tableTypeFilter = JDBCImporter.generateTableTypeFilter(connection, exceptions);
            selector = new JMDSelector();
            ArrayList<JMDModelObject> catalogs = model.getRoot().getChildren();
            for (JMDModelObject catalog : catalogs) {
                String dbCatalogs = catalog.getAttributes().getString(AttributeType.NAME);
                selector.addTableSelection(dbCatalogs, "\ufffds", "\ufffds", tableTypeFilter, AttributeType.ALL);
            }
            removeTables = true;
        } else if (JDBCImporter.isSqlServerUrl(url) || url.contains("jdbc:domsql:") || url.contains("jdbc:sfdc:")) {
            String tableTypeFilter = JDBCImporter.generateTableTypeFilter(connection, exceptions);
            selector.addTableSelection("\ufffds", "\ufffds", "\ufffds", tableTypeFilter, AttributeType.NAME);
            removeTables = true;
        } else {
            selector.addCatalogSelection("\ufffds", AttributeType.ALL);
            selector.addSchemaSelection("\ufffds", "\ufffds", AttributeType.ALL);
        }
        return JDBCImporter.importModel(connection, selector, exceptions, removeTables);
    }

    private static IJMDModel importModel(IJMDConnection connection, IJMDSelector selector, List<JMDException> exceptions, boolean removeTables) throws JMDException {
        JMDModel model;
        block4: {
            block3: {
                model = new JMDModel();
                JDBCImporter importer = new JDBCImporter();
                importer.execute(connection, selector, model, exceptions, IJMDImporter.CachingLevel.BEST, 1);
                if (removeTables) {
                    JDBCImporter.removeTables(model);
                }
                if (!JDBCImporter.containsObjectTypes(model.getRoot(), ObjectType.SCHEMA)) break block3;
                ArrayList<JMDModelObject> catalogs = model.getRoot().getChildren();
                Iterator it = catalogs.iterator();
                while (it.hasNext()) {
                    JMDModelObject catalog = (JMDModelObject)it.next();
                    if (catalog.hasChildren()) continue;
                    it.remove();
                }
                break block4;
            }
            if (!JDBCImporter.containsObjectTypes(model.getRoot(), ObjectType.CATALOG)) break block4;
            ArrayList<JMDModelObject> catalogs = model.getRoot().getChildren();
            for (JMDModelObject catalog : catalogs) {
                JMDModelObject emptySchema = new JMDModelObject();
                emptySchema.setObjectType(ObjectType.SCHEMA);
                AttributeList attributes = new AttributeList();
                Attribute name = new Attribute(AttributeType.NAME, null);
                attributes.add(name);
                emptySchema.setAttributes(attributes);
                catalog.addChild(emptySchema);
            }
        }
        return model;
    }

    private static void removeTables(IJMDModel model) {
        ArrayList<JMDModelObject> catalogs = model.getRoot().getChildren();
        if (catalogs == null) {
            return;
        }
        for (JMDModelObject catalog : catalogs) {
            ArrayList<JMDModelObject> schemas = catalog.getChildren();
            for (JMDModelObject schema : schemas) {
                ArrayList<JMDModelObject> tables = schema.getChildren();
                Iterator it = tables.iterator();
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
            }
        }
    }

    public static IJMDModel getTables(String catalog, String schema, IJMDConnection connection, List<JMDException> exceptions) throws JMDException {
        ImportSpec importSpec = new ImportSpec();
        importSpec.setCatalog(catalog);
        importSpec.setSchema(schema);
        importSpec.setConnection(connection);
        importSpec.setExceptions(exceptions);
        importSpec.setImportOption(ImportOption.TABLES);
        return JDBCImporter.importTables(importSpec);
    }

    public static IJMDModel importTables(ImportSpec importSpec) throws JMDException {
        return JDBCImporter.importTablesWithFeedback(importSpec, null);
    }

    public static IJMDModel importTablesWithFeedback(ImportSpec importSpec, Map<String, Object> feedback) throws JMDException {
        String catalog = importSpec.getCatalog();
        String schema = importSpec.getSchema();
        String table = importSpec.getTable();
        Set<String> excludeTables = importSpec.getExcludeTables();
        Set<String> includeTables = importSpec.getIncludeTables();
        double bulkLoadThreshold = importSpec.getBulkLoadThreshold();
        IJMDConnection connection = importSpec.getConnection();
        IJMDProgressCallback callback = importSpec.getCallback();
        List<JMDException> exceptions = importSpec.getExceptions();
        ImportOption option = importSpec.getImportOption();
        ImportMode importMode = importSpec.getImportMode();
        String tableTypeFilter = JDBCImporter.generateTableTypeFilter(connection, exceptions);
        JMDSelector selector = new JMDSelector();
        selector.addTableSelection(catalog, schema, table, tableTypeFilter, AttributeType.ALL);
        String url = ((JDBCConnection)connection).getUrl();
        if (JDBCImporter.handleSynonyms(url)) {
            selector.addSynonymSelection(catalog, schema, table, "SYNONYM", AttributeType.NAME, AttributeType.DESCRIPTION, AttributeType.TABLE_TYPE, AttributeType.EXTERNAL_HOST_REF, AttributeType.TARGET_CATALOG, AttributeType.TARGET_SCHEMA, AttributeType.TARGET_REFOBJECT_NAME);
        }
        JMDModel model = new JMDModel();
        if (callback != null && callback.isCancelled()) {
            return model;
        }
        JDBCImporter importer = new JDBCImporter();
        importer.execute(connection, selector, model, exceptions, IJMDImporter.CachingLevel.BEST, 1);
        if (!JDBCImporter.containsObjectTypes(model.getRoot(), ObjectType.TABLE) && !JDBCImporter.containsObjectTypes(model.getRoot(), ObjectType.SYNONYM)) {
            return model;
        }
        if (JDBCImporter.handleSynonyms(url)) {
            JDBCImporter.removeUnrelatedSynonyms(model);
        }
        int numTables = JDBCImporter.countTables(model);
        if (feedback != null) {
            feedback.put(STR_NUM_TABLES, numTables);
        }
        int numRemainingTables = numTables;
        if (includeTables != null) {
            JDBCImporter.inOrExcludeTables(model, includeTables, true);
            numRemainingTables = JDBCImporter.countTables(model);
        } else if (excludeTables != null && !excludeTables.isEmpty()) {
            JDBCImporter.inOrExcludeTables(model, excludeTables, false);
            numRemainingTables = JDBCImporter.countTables(model);
        }
        if (option.equals((Object)ImportOption.TABLES)) {
            return model;
        }
        switch (JDBCImporter.getImportMode(importMode, connection, numTables, numRemainingTables, bulkLoadThreshold)) {
            case BULK_FALLBACK: {
                try {
                    return JDBCImporter.fastImport(importSpec, model, importer);
                }
                catch (Exception e) {
                    exceptions.clear();
                    exceptions.add(new JMDBulkImportException(e));
                }
            }
            case ITERATIVE: {
                return JDBCImporter.slowImport(importSpec, model, importer);
            }
        }
        return JDBCImporter.fastImport(importSpec, model, importer);
    }

    public static void removeUnrelatedSynonyms(IJMDModel model) {
        ArrayList<JMDModelObject> tables = JDBCImporter.getSchemaChildren(model);
        String catalog = model.getRoot().getChildren().get(0).getAttributes().getString(AttributeType.NAME);
        String schema = model.getRoot().getChildren().get(0).getChildren().get(0).getAttributes().getString(AttributeType.NAME);
        HashMap tableNames = new HashMap();
        tables.forEach(elem -> tableNames.put(elem.getAttributes().getString(AttributeType.NAME), elem));
        ArrayList<String> ldc = new ArrayList<String>();
        Iterator imetadata = tables.iterator();
        block0: while (imetadata.hasNext()) {
            ldc.clear();
            JMDModelObject e = (JMDModelObject)imetadata.next();
            while (ObjectType.SYNONYM.equals((Object)e.getObjectType()) && JDBCImporter.isSameSchema(catalog, schema, e)) {
                String ref = e.getAttributes().getString(AttributeType.TARGET_REFOBJECT_NAME);
                if (ldc.contains(ref)) {
                    imetadata.remove();
                    continue block0;
                }
                ldc.add(ref);
                e = (JMDModelObject)tableNames.get(ref);
                if (e != null) continue;
                imetadata.remove();
                continue block0;
            }
        }
    }

    private static boolean isSameSchema(String catalog, String schema, JMDModelObject e) {
        String cat = e.getAttributes().getString(AttributeType.TARGET_CATALOG);
        if (cat != null && !cat.equals(catalog)) {
            return false;
        }
        String sch = e.getAttributes().getString(AttributeType.TARGET_SCHEMA);
        return sch == null || sch.equals(schema);
    }

    private static boolean handleSynonyms(String url) {
        return url.contains("jdbc:sqlserver:") || url.contains("jdbc:oracle:");
    }

    private static ImportMode getImportMode(ImportMode importMode, IJMDConnection connection, int numTables, int numRemainingTables, double bulkLoadThreshold) {
        if (!ImportMode.AUTOMATIC.equals((Object)importMode)) {
            return importMode;
        }
        if (((JDBCConnection)connection).getUrl().contains("jdbc:domsql:")) {
            return ImportMode.ITERATIVE;
        }
        if (numTables == numRemainingTables) {
            return ImportMode.BULK;
        }
        if ((double)numRemainingTables / (double)numTables < bulkLoadThreshold) {
            return ImportMode.ITERATIVE;
        }
        return ImportMode.BULK_FALLBACK;
    }

    private static String generateTableTypeFilter(IJMDConnection connection, List<JMDException> exceptions) throws JMDException {
        Connection jdbcConn = connection.getConnection();
        StringBuilder filter = new StringBuilder();
        if (jdbcConn instanceof IAdaptorConnection) {
            IAdaptorConnection jdbcAdaptorConn = (IAdaptorConnection)jdbcConn;
            try {
                BaseDatabaseMetadataAdaptor md = (BaseDatabaseMetadataAdaptor)jdbcAdaptorConn.getMetaData();
                String url = ((JDBCConnection)connection).getUrl();
                ResultSet rs = md.getTableTypes();
                while (rs.next()) {
                    String commonType;
                    String nativeType = rs.getString(1);
                    if (url.contains("jdbc:oracle:") && nativeType.equals("SYNONYM") || !tableTypes.contains(commonType = md.getEffectiveTableType(nativeType = nativeType.trim()))) continue;
                    if (filter.length() > 0) {
                        filter.append("\ufffdo");
                    }
                    filter.append(nativeType);
                }
                if (url.contains("jdbc:db2:")) {
                    filter.append("\ufffdo");
                    filter.append("SYNONYM");
                }
            }
            catch (SQLException e) {
                JMDException ex = new JMDException(e);
                if (exceptions == null) {
                    throw ex;
                }
                exceptions.add(ex);
                filter = new StringBuilder();
                filter.append("\ufffds");
            }
        } else {
            filter.append("\ufffds");
        }
        return filter.toString();
    }

    private static IJMDModel fastImport(ImportSpec importSpec, IJMDModel model, JDBCImporter importer) throws JMDException {
        String catalog = importSpec.getCatalog();
        String schema = importSpec.getSchema();
        String table = importSpec.getTable();
        IJMDConnection connection = importSpec.getConnection();
        IJMDProgressCallback callback = importSpec.getCallback();
        List<JMDException> exceptions = importSpec.getExceptions();
        ImportOption option = importSpec.getImportOption();
        HashSet<String> tableSet = new HashSet<String>();
        ArrayList<JMDModelObject> tables = JDBCImporter.getSchemaChildren(model);
        for (JMDModelObject jMDModelObject : tables) {
            tableSet.add(jMDModelObject.getAttributes().getString(AttributeType.NAME));
        }
        if (callback != null) {
            if (callback.isCancelled()) {
                return model;
            }
            callback.estimate(tables.size());
        }
        IJMDSelector selector = JDBCImporter.generateSelector(catalog, schema, table, option, model, null, null, null);
        importer.execute(connection, selector, model, exceptions, IJMDImporter.CachingLevel.BEST, 1);
        ArrayList<JMDModelObject> tables2 = JDBCImporter.getSchemaChildren(model);
        for (JMDModelObject elem : tables2) {
            String tableName = elem.getAttributes().getString(AttributeType.NAME);
            String tableObjectType = elem.getAttributes().getString(AttributeType.TABLE_TYPE);
            if (!tableSet.contains(tableName) || tableObjectType == null || !tableObjectType.equals("SYNONYM")) continue;
            String targetCatalog = elem.getAttributes().getString(AttributeType.TARGET_CATALOG);
            String targetSchema = elem.getAttributes().getString(AttributeType.TARGET_SCHEMA);
            String targetRefObjectName = elem.getAttributes().getString(AttributeType.TARGET_REFOBJECT_NAME);
            if (callback != null) {
                if (callback.isCancelled()) {
                    return model;
                }
                callback.update(tableName);
            }
            IJMDSelector selector2 = JDBCImporter.generateSelector(catalog, schema, tableName, option, model, targetCatalog, targetSchema, targetRefObjectName);
            importer.execute(connection, selector2, model, exceptions, IJMDImporter.CachingLevel.BEST, 1);
        }
        if (!JDBCImporter.containsObjectTypes(model.getRoot(), ObjectType.TABLE)) {
            return model;
        }
        ArrayList<JMDModelObject> metadata = JDBCImporter.getSchemaChildren(model);
        Iterator imetadata = metadata.iterator();
        while (imetadata.hasNext()) {
            JMDModelObject jMDModelObject = (JMDModelObject)imetadata.next();
            if (tableSet.contains(jMDModelObject.getAttributes().getString(AttributeType.NAME))) continue;
            imetadata.remove();
        }
        return model;
    }

    private static IJMDModel slowImport(ImportSpec importSpec, IJMDModel model, JDBCImporter importer) throws JMDException {
        String catalog = importSpec.getCatalog();
        String schema = importSpec.getSchema();
        IJMDConnection connection = importSpec.getConnection();
        IJMDProgressCallback callback = importSpec.getCallback();
        List<JMDException> exceptions = importSpec.getExceptions();
        ImportOption option = importSpec.getImportOption();
        ArrayList<JMDModelObject> tables = JDBCImporter.getSchemaChildren(model);
        if (callback != null) {
            callback.estimate(tables.size());
        }
        for (JMDModelObject elem : tables) {
            String table = elem.getAttributes().getString(AttributeType.NAME);
            String targetCatalog = elem.getAttributes().getString(AttributeType.TARGET_CATALOG);
            String targetSchema = elem.getAttributes().getString(AttributeType.TARGET_SCHEMA);
            String targetRefObjectName = elem.getAttributes().getString(AttributeType.TARGET_REFOBJECT_NAME);
            if (callback != null) {
                if (callback.isCancelled()) {
                    return model;
                }
                callback.update(table);
            }
            IJMDSelector selector = JDBCImporter.generateSelector(catalog, schema, table, option, model, targetCatalog, targetSchema, targetRefObjectName);
            importer.execute(connection, selector, model, exceptions, IJMDImporter.CachingLevel.BEST, 1);
        }
        return model;
    }

    private static IJMDSelector generateSelector(String catalog, String schema, String table, ImportOption option, IJMDModel model, String targetCatalog, String targetSchema, String targetRefObjectName) {
        JMDSelector selector = new JMDSelector();
        switch (option) {
            case TABLES_COLUMNS: {
                selector.addColumnSelection(catalog, schema, table, "\ufffds", AttributeType.ALL);
                break;
            }
            case SYNONYMS_COLUMNS: {
                if (targetRefObjectName == null) break;
                selector.addSynonymColumnSelection(catalog, schema, table, "\ufffds", targetCatalog, targetSchema, targetRefObjectName, AttributeType.ALL);
                break;
            }
            case TABLES_COLUMNS_KEYS_INDEXES: {
                selector.addColumnSelection(catalog, schema, table, "\ufffds", AttributeType.ALL);
                if (targetRefObjectName != null) {
                    selector.addSynonymColumnSelection(catalog, schema, table, "\ufffds", targetCatalog, targetSchema, targetRefObjectName, AttributeType.ALL);
                }
                selector.addPrimaryKeySelection(catalog, schema, table, AttributeType.ALL);
                selector.addImportedKeySelection(catalog, schema, table, AttributeType.ALL);
                selector.addIndexSelection(catalog, schema, table, AttributeType.ALL);
                break;
            }
            default: {
                selector.addColumnSelection(catalog, schema, table, "\ufffds", AttributeType.ALL);
                if (targetRefObjectName != null) {
                    selector.addSynonymColumnSelection(catalog, schema, table, "\ufffds", targetCatalog, targetSchema, targetRefObjectName, AttributeType.ALL);
                }
                selector.addPrimaryKeySelection(catalog, schema, table, AttributeType.ALL);
                selector.addImportedKeySelection(catalog, schema, table, AttributeType.ALL);
            }
        }
        return selector;
    }

    private static boolean containsObjectTypes(JMDModelObject object, ObjectType ... types) {
        ObjectType[] objectTypes;
        ObjectType thisType = object.getObjectType();
        for (ObjectType a : objectTypes = types) {
            if (thisType.getDepth() != a.getDepth()) continue;
            return thisType.equals((Object)a);
        }
        ArrayList<JMDModelObject> children = object.getChildren();
        if (children == null) {
            return false;
        }
        for (JMDModelObject child : children) {
            if (!JDBCImporter.containsObjectTypes(child, types)) continue;
            return true;
        }
        return false;
    }

    private static void inOrExcludeTables(IJMDModel model, Set<String> inOrExcludedTables, boolean bIncl) {
        ArrayList<JMDModelObject> metadata = JDBCImporter.getSchemaChildren(model);
        Iterator imetadata = metadata.iterator();
        while (imetadata.hasNext()) {
            JMDModelObject elem = (JMDModelObject)imetadata.next();
            boolean bContains = inOrExcludedTables.contains(elem.getAttributes().getString(AttributeType.NAME));
            if (bIncl) {
                if (bContains) continue;
                imetadata.remove();
                continue;
            }
            if (!bContains) continue;
            imetadata.remove();
        }
    }

    private static ArrayList<JMDModelObject> getSchemaChildren(IJMDModel model) {
        return model.getRoot().getChildren().get(0).getChildren().get(0).getChildren();
    }

    private static int countTables(IJMDModel model) {
        return JDBCImporter.getSchemaChildren(model).size();
    }

    static {
        tableTypes.add("TABLE");
        tableTypes.add("VIEW");
        tableTypes.add("SYNONYM");
        tableTypes.add("SYSTEM TABLE");
        tableTypes.add("SYSTEM VIEW");
        tableTypes.add("VIRTUAL_VIEW");
    }

    public static class ImportSpec {
        private String catalog = "\ufffds";
        private String schema = "\ufffds";
        private String table = "\ufffds";
        private Set<String> excludeTables = null;
        private Set<String> includeTables = null;
        private double bulkLoadThreshold = 0.25;
        private IJMDConnection connection = null;
        private IJMDProgressCallback callback = null;
        private List<JMDException> exceptions = null;
        private ImportOption importOption = ImportOption.TABLES_COLUMNS_KEYS;
        private ImportMode importMode = ImportMode.AUTOMATIC;

        public String getCatalog() {
            return this.catalog;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public Set<String> getExcludeTables() {
            return this.excludeTables;
        }

        public void setExcludeTables(Set<String> excludeTables) {
            this.excludeTables = excludeTables;
        }

        public void setIncludeTables(Set<String> inclTables) {
            this.includeTables = inclTables;
        }

        public Set<String> getIncludeTables() {
            return this.includeTables;
        }

        public double getBulkLoadThreshold() {
            return this.bulkLoadThreshold;
        }

        public void setBulkLoadThreshold(double bulkLoadThreshold) {
            this.bulkLoadThreshold = bulkLoadThreshold;
        }

        public IJMDConnection getConnection() {
            return this.connection;
        }

        public void setConnection(IJMDConnection connection) {
            this.connection = connection;
        }

        public IJMDProgressCallback getCallback() {
            return this.callback;
        }

        public void setCallback(IJMDProgressCallback callback) {
            this.callback = callback;
        }

        public List<JMDException> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(List<JMDException> exceptions) {
            this.exceptions = exceptions;
        }

        public ImportOption getImportOption() {
            return this.importOption;
        }

        public void setImportOption(ImportOption importOption) {
            this.importOption = importOption;
        }

        public ImportMode getImportMode() {
            return this.importMode;
        }

        public void setImportMode(ImportMode importMode) {
            this.importMode = importMode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("catalog: ");
            result.append(this.catalog);
            result.append(", schema: ");
            result.append(this.schema);
            result.append(", table: ");
            result.append(this.table);
            if (this.excludeTables != null) {
                result.append(", excludeTables: ");
                result.append(this.excludeTables.toString());
            }
            if (this.includeTables != null) {
                result.append(", includeTables: ");
                result.append(this.includeTables.toString());
            }
            result.append(", importMode: ");
            result.append(this.importMode.name());
            result.append(", importOption: ");
            result.append(this.importOption.name());
            if (this.connection != null) {
                result.append(", connection: {");
                result.append(this.connection.toString());
                result.append("}");
            }
            return result.toString();
        }
    }

    public static enum ImportMode {
        AUTOMATIC,
        BULK,
        BULK_FALLBACK,
        ITERATIVE;

    }

    public static enum ImportOption {
        TABLES,
        TABLES_COLUMNS,
        SYNONYMS_COLUMNS,
        TABLES_COLUMNS_KEYS,
        TABLES_COLUMNS_KEYS_INDEXES;

    }
}

