/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDUDTException;
import com.ibm.cognos.jmd.importer.AbstractJDBCRequest;
import com.ibm.cognos.jmd.importer.AbstractResultSetIterator;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.CatalogRequest;
import com.ibm.cognos.jmd.importer.ColumnRequest;
import com.ibm.cognos.jmd.importer.ExportedKeysRequest;
import com.ibm.cognos.jmd.importer.FunctionColumnsRequest;
import com.ibm.cognos.jmd.importer.FunctionsRequest;
import com.ibm.cognos.jmd.importer.ImportedKeysRequest;
import com.ibm.cognos.jmd.importer.IndexInfoRequest;
import com.ibm.cognos.jmd.importer.PrimaryKeysRequest;
import com.ibm.cognos.jmd.importer.ProcedureColumnsRequest;
import com.ibm.cognos.jmd.importer.ProceduresRequest;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.importer.SchemaRequest;
import com.ibm.cognos.jmd.importer.SynonymColumnRequest;
import com.ibm.cognos.jmd.importer.SynonymRequest;
import com.ibm.cognos.jmd.importer.TableRequest;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;

public class JDBCResultSetIterator
extends AbstractResultSetIterator {
    AbstractJDBCRequest request;

    public JDBCResultSetIterator(SelectionCriteria theSelectionCriteria, DatabaseMetaData dmd, ResultSetCache resultSetCache) throws JMDImportException {
        super(theSelectionCriteria);
        switch (this.selectionCriteria.getObjectType()) {
            case CATALOG: {
                this.request = new CatalogRequest(dmd, resultSetCache);
                break;
            }
            case SCHEMA: {
                this.request = new SchemaRequest(dmd, resultSetCache);
                break;
            }
            case TABLE: {
                this.request = new TableRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case SYNONYM: {
                this.request = new SynonymRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case COLUMN: {
                this.request = new ColumnRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case SYNONYM_COLUMN: {
                this.request = new SynonymColumnRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case PROCEDURE: {
                this.request = new ProceduresRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case PROCEDURE_COLUMN: {
                this.request = new ProcedureColumnsRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case FUNCTION: {
                this.request = new FunctionsRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case FUNCTION_COLUMN: {
                this.request = new FunctionColumnsRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case INDEX: {
                this.request = new IndexInfoRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case PRIMARY_KEY: {
                this.request = new PrimaryKeysRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case IMPORTED_KEY: {
                this.request = new ImportedKeysRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case EXPORTED_KEY: {
                this.request = new ExportedKeysRequest(dmd, resultSetCache, this.selectionCriteria);
                break;
            }
            case UDT: {
                throw new JMDImportException(new JMDUDTException());
            }
            default: {
                throw new JMDImportException();
            }
        }
    }

    @Override
    protected CachedRow getNextRow() throws JMDImportException {
        return this.request.getNextRow();
    }
}

