/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.importer.AbstractRowHandler;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.SelectionCriteria;

public class ProcedureColumnRowHandler
extends AbstractRowHandler {
    private static final String UNNAMED_PROCEDURECOLUMN = "UNNAMED-PROCEDURECOLUMN #%d";
    private String lastSignatureName = null;
    private int nullNameCounter;

    public ProcedureColumnRowHandler(IJMDModel mod, SelectionCriteria sc) {
        super(mod, sc);
    }

    @Override
    public void handleRow(CachedRow row) {
        ObjectType objectType;
        String signatureName = row.getString(3);
        if (!signatureName.equals(this.lastSignatureName)) {
            this.nullNameCounter = 0;
            this.lastSignatureName = signatureName;
        }
        Attribute.ProcedureColumnType procedureColumnType = null;
        switch (row.getInt(10)) {
            case 5: {
                objectType = ObjectType.STATUS_CODE;
                break;
            }
            case 3: {
                objectType = ObjectType.PROCEDURE_ROWSET;
                break;
            }
            case 1: {
                objectType = ObjectType.PROCEDURE_COLUMN;
                procedureColumnType = Attribute.ProcedureColumnType.INPUT;
                break;
            }
            case 4: {
                objectType = ObjectType.PROCEDURE_COLUMN;
                procedureColumnType = Attribute.ProcedureColumnType.OUTPUT;
                break;
            }
            case 2: {
                objectType = ObjectType.PROCEDURE_COLUMN;
                procedureColumnType = Attribute.ProcedureColumnType.INPUT_OUTPUT;
                break;
            }
            default: {
                objectType = ObjectType.PROCEDURE_COLUMN;
                procedureColumnType = Attribute.ProcedureColumnType.UNKNOWN;
            }
        }
        int[] attributeMap = JDBCColumnMaps.getAttributeMap(objectType);
        JMDModelObject mo = new JMDModelObject(objectType, new Attribute[0]);
        for (AttributeType attributeType : this.selectionCriteria.getAttributeTypes()) {
            int column = attributeMap[attributeType.ordinal()];
            if (column == -1) continue;
            Object value = row.get(column);
            if (attributeType == AttributeType.NAME && value == null) {
                value = String.format(UNNAMED_PROCEDURECOLUMN, ++this.nullNameCounter);
            } else if (attributeType == AttributeType.TYPE) {
                value = procedureColumnType;
            }
            if (value == null) continue;
            this.setAttribute(mo, new Attribute(attributeType, value));
        }
        this.addToModel(mo, row);
    }
}

