/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDProcedureParameterException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class ProcedureColumnsRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getProcedureColumns()";
    private static final String API_NAME_ROWS = "getProcedureColumns() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int PROCEDURENAME_COLUMN = 2;
    public static final int SIGNATURENAME_COLUMN = 3;
    public static final int PARAMETERNAME_COLUMN = 4;
    public static final int DATATYPE_COLUMN = 5;
    public static final int PRECISION_COLUMN = 6;
    public static final int SCALE_COLUMN = 7;
    public static final int NULLABLE_COLUMN = 8;
    public static final int VENDORTYPE_COLUMN = 9;
    public static final int TYPE_COLUMN = 10;
    public static final int DESCRIPTION_COLUMN = 11;
    public static final int NUMBER_OF_CACHED_COLUMNS = 12;
    public static final int JDBC_PROCEDURE_CAT = 1;
    public static final int JDBC_PROCEDURE_SCHEM = 2;
    public static final int JDBC_PROCEDURE_NAME = 3;
    public static final int JDBC_SPECIFIC_NAME = 20;
    public static final int JDBC_COLUMN_NAME = 4;
    public static final int JDBC_COLUMN_TYPE = 5;
    public static final int JDBC_DATA_TYPE = 6;
    public static final int JDBC_TYPE_NAME = 7;
    public static final int JDBC_PRECISION = 8;
    public static final int JDBC_SCALE = 10;
    public static final int JDBC_IS_NULLABLE = 19;
    public static final int JDBC_REMARKS = 13;
    String schemaPattern;
    String procedureNamePattern;

    ProcedureColumnsRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        this.procedureNamePattern = this.filterAsJDBCPattern((Filter)filters.get(2));
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(12);
        row.set(0, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(1))));
        row.set(1, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(2))));
        row.set(2, (Object)this.objectPool.pool(this.rs.getString(3)));
        if (this.jdbcMajor >= 4) {
            row.set(3, (Object)this.objectPool.pool(this.rs.getString(20)));
        } else {
            row.set(3, row.get(2));
        }
        row.set(4, (Object)this.objectPool.pool(this.rs.getString(4)));
        row.set(5, JDBCColumnMaps.getAdaptorTypeAsString(this.rs.getInt(6)));
        row.set(6, this.objectPool.pool(this.rs.getInt(8)));
        int i = this.rs.getInt(10);
        if (this.rs.wasNull()) {
            row.set(7, null);
        } else {
            row.set(7, this.objectPool.pool(i));
        }
        row.set(8, (Object)this.objectPool.pool(this.rs.getString(19)));
        row.set(9, (Object)this.objectPool.pool(this.rs.getString(7)));
        row.set(11, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(13))));
        row.set(10, this.objectPool.pool(this.rs.getInt(5)));
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        String catalog = row.getString(0);
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getProcedureColumns(catalog, this.schemaPattern, this.procedureNamePattern, null);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDProcedureParameterException(e);
    }
}

