/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDProcedureException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.Attribute;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class ProceduresRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getProcedures()";
    private static final String API_NAME_ROWS = "getProcedures() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int PROCEDURENAME_COLUMN = 2;
    public static final int SIGNATURENAME_COLUMN = 3;
    public static final int PROCEDUREDESCRIPTION_COLUMN = 4;
    public static final int PROCEDURERETURNSVALUE_COLUMN = 5;
    public static final int NUMBER_OF_CACHED_COLUMNS = 6;
    public static final int JDBC_PROCEDURE_CAT = 1;
    public static final int JDBC_PROCEDURE_SCHEM = 2;
    public static final int JDBC_PROCEDURE_NAME = 3;
    public static final int JDBC_SPECIFIC_NAME = 9;
    public static final int JDBC_REMARKS = 7;
    public static final int JDBC_PROCEDURE_TYPE = 8;
    String schemaPattern;
    String procedureNamePattern;

    ProceduresRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        this.procedureNamePattern = this.filterAsJDBCPattern((Filter)filters.get(2));
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(6);
        row.set(0, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(1))));
        row.set(1, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(2))));
        row.set(2, (Object)this.objectPool.pool(this.rs.getString(3)));
        if (this.jdbcMajor >= 4) {
            row.set(3, (Object)this.objectPool.pool(this.rs.getString(9)));
        } else {
            row.set(3, row.get(2));
        }
        row.set(4, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(7))));
        switch (this.rs.getInt(8)) {
            case 1: {
                row.set(5, (Object)Attribute.ProcedureReturnsValue.NO);
                break;
            }
            case 2: {
                row.set(5, (Object)Attribute.ProcedureReturnsValue.YES);
                break;
            }
            default: {
                row.set(5, (Object)Attribute.ProcedureReturnsValue.UNKNOWN);
            }
        }
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        String catalog = row.getString(0);
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getProcedures(catalog, this.schemaPattern, this.procedureNamePattern);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDProcedureException(e);
    }
}

