/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractResultSetIterator;
import com.ibm.cognos.jmd.importer.AbstractRowHandler;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.DefaultRowHandler;
import com.ibm.cognos.jmd.importer.ExportedKeyRowHandler;
import com.ibm.cognos.jmd.importer.FunctionColumnRowHandler;
import com.ibm.cognos.jmd.importer.ImportedKeyRowHandler;
import com.ibm.cognos.jmd.importer.IndexRowHandler;
import com.ibm.cognos.jmd.importer.PrimaryKeyRowHandler;
import com.ibm.cognos.jmd.importer.ProcedureColumnRowHandler;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;

public class RequestHandler {
    private SelectionCriteria selectionCriteria;
    ResultSetCache resultCache;
    DatabaseMetaData metadata;
    IJMDModel model;

    RequestHandler(IJMDModel mod, ResultSetCache cache, DatabaseMetaData dmd, SelectionCriteria selector) {
        this.selectionCriteria = selector;
        this.resultCache = cache;
        this.metadata = dmd;
        this.model = mod;
    }

    public void run() throws JMDImportException {
        block14: {
            AbstractResultSetIterator iterator = this.resultCache.getIterator(this.selectionCriteria, this.metadata);
            if (!iterator.hasNext()) break block14;
            if (this.selectionCriteria.getAttributeTypes().isEmpty()) {
                while (iterator.next() != null) {
                }
            } else {
                CachedRow row;
                AbstractRowHandler rowHandler;
                ObjectType type = this.selectionCriteria.getObjectType();
                switch (type) {
                    case PROCEDURE: {
                        rowHandler = new DefaultRowHandler(this.model, new SelectionCriteria(ObjectType.PROCEDURE_SIGNATURE, this.selectionCriteria.getAttributeTypes(), this.selectionCriteria.getFilterList()));
                        break;
                    }
                    case FUNCTION: {
                        rowHandler = new DefaultRowHandler(this.model, new SelectionCriteria(ObjectType.FUNCTION_SIGNATURE, this.selectionCriteria.getAttributeTypes(), this.selectionCriteria.getFilterList()));
                        break;
                    }
                    case PROCEDURE_COLUMN: {
                        rowHandler = new ProcedureColumnRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    case FUNCTION_COLUMN: {
                        rowHandler = new FunctionColumnRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    case INDEX: {
                        rowHandler = new IndexRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    case PRIMARY_KEY: {
                        rowHandler = new PrimaryKeyRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    case IMPORTED_KEY: {
                        rowHandler = new ImportedKeyRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    case EXPORTED_KEY: {
                        rowHandler = new ExportedKeyRowHandler(this.model, this.selectionCriteria);
                        break;
                    }
                    default: {
                        rowHandler = new DefaultRowHandler(this.model, this.selectionCriteria);
                    }
                }
                while ((row = iterator.next()) != null) {
                    ((AbstractRowHandler)rowHandler).handleRow(row);
                }
            }
        }
    }
}

