/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractResultSetIterator;
import com.ibm.cognos.jmd.importer.CachedResultSetIterator;
import com.ibm.cognos.jmd.importer.CachedRowset;
import com.ibm.cognos.jmd.importer.IJMDImporter;
import com.ibm.cognos.jmd.importer.JDBCResultSetIterator;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.JMDSelector;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import com.ibm.cognos.jmd.util.Counters;
import com.ibm.cognos.jmd.util.ICountable;
import java.sql.DatabaseMetaData;
import java.util.HashMap;

public class ResultSetCache
implements ICountable {
    private static final String CACHED = " (cached)";
    private Counters eventCounters = new Counters();
    private JMDSelector selections = new JMDSelector();
    private HashMap<ObjectType, CachedRowset> cache = new HashMap();
    IJMDImporter.CachingLevel cachingLevel = IJMDImporter.CachingLevel.BEST;

    public CachedRowset getCachedRowset(ObjectType type) {
        if (!this.cache.containsKey((Object)type)) {
            this.cache.put(type, new CachedRowset());
        }
        CachedRowset rs = this.cache.get((Object)type);
        rs.setEnabled(this.isResultSetCacheable(type));
        return rs;
    }

    public AbstractResultSetIterator getIterator(SelectionCriteria selectionCriteria, DatabaseMetaData dmd) throws JMDImportException {
        AbstractResultSetIterator iterator;
        if (this.selections.isRedundantSelection(selectionCriteria, false)) {
            String name = selectionCriteria.getObjectType().toString() + CACHED;
            this.eventCounters.incrementCounter(name);
            iterator = new CachedResultSetIterator(selectionCriteria, this);
        } else {
            String name = selectionCriteria.getObjectType().toString();
            this.eventCounters.incrementCounter(name);
            iterator = new JDBCResultSetIterator(selectionCriteria, dmd, this);
            if (this.isResultSetCacheable(selectionCriteria.getObjectType())) {
                this.selections.addSelection(selectionCriteria);
            }
        }
        return iterator;
    }

    @Override
    public Counters getCounters() {
        return this.eventCounters;
    }

    public void setCachingLevel(IJMDImporter.CachingLevel level) {
        this.cachingLevel = level;
    }

    private boolean isResultSetCacheable(ObjectType type) {
        boolean rc;
        switch (this.cachingLevel) {
            case MINIMUM: {
                rc = false;
                break;
            }
            case MAXIMUM: {
                rc = true;
                break;
            }
            default: {
                rc = type == ObjectType.TABLE || type == ObjectType.CATALOG || type == ObjectType.SYNONYM;
            }
        }
        return rc;
    }
}

