/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDSchemaException;
import com.ibm.cognos.jmd.importer.AbstractJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.ObjectType;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SchemaRequest
extends AbstractJDBCRequest {
    private static final String API_NAME = "getSchemas()";
    private static final String API_NAME_ROWS = "getSchemas() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int NUMBER_OF_CACHED_COLUMNS = 2;
    public static final int JDBC_TABLE_CATALOG = 2;
    public static final int JDBC_TABLE_SCHEM = 1;
    ResultSet rs;

    SchemaRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache) throws JMDImportException {
        super(resultSetCache.getCounters(), dmd, resultSetCache.getCachedRowset(ObjectType.SCHEMA));
        try {
            this.events.incrementCounter(API_NAME);
            this.rs = this.metadata.getSchemas();
        }
        catch (SQLException e) {
            throw new JMDSchemaException(e);
        }
    }

    @Override
    public CachedRow getNextRow() throws JMDSchemaException {
        CachedRow row = null;
        if (!this.eod) {
            try {
                if (this.rs.next()) {
                    this.events.incrementCounter(API_NAME_ROWS);
                    row = new CachedRow(2);
                    row.set(0, this.convertEmptyStringToNull(this.rs.getString(2)));
                    row.set(1, this.convertEmptyStringToNull(this.rs.getString(1)));
                    this.cachedData.add(row);
                } else {
                    this.rs.close();
                    this.eod = true;
                }
            }
            catch (SQLException e) {
                throw new JMDSchemaException(e);
            }
        }
        return row;
    }
}

