/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDColumnException;
import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.JDBCColumnMaps;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class SynonymColumnRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getColumns()";
    private static final String API_NAME_ROWS = "getColumns() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int TABLENAME_COLUMN = 2;
    public static final int COLUMNNAME_COLUMN = 3;
    public static final int DATATYPE_COLUMN = 4;
    public static final int VENDORTYPE_COLUMN = 5;
    public static final int PRECISION_COLUMN = 6;
    public static final int SCALE_COLUMN = 7;
    public static final int COLUMNDESCRIPTION_COLUMN = 8;
    public static final int NULLABLE_COLUMN = 9;
    public static final int NUMBER_OF_CACHED_COLUMNS = 10;
    public static final int JDBC_TABLE_CAT = 1;
    public static final int JDBC_TABLE_SCHEM = 2;
    public static final int JDBC_TABLE_NAME = 3;
    public static final int JDBC_COLUMN_NAME = 4;
    public static final int JDBC_DATA_TYPE = 5;
    public static final int JDBC_TYPE_NAME = 6;
    public static final int JDBC_COLUMN_SIZE = 7;
    public static final int JDBC_DECIMAL_DIGITS = 9;
    public static final int JDBC_IS_NULLABLE = 18;
    public static final int JDBC_REMARKS = 12;
    String catalog;
    String schemaPattern;
    String tableNamePattern;
    String columnNamePattern;
    String targetCatalogName;
    String targetSchemaName;
    String originalNamePattern;

    SynonymColumnRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.catalog = ((Filter)filters.get(0)).getExpression();
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        if (this.catalog.equals("\ufffds")) {
            this.catalog = null;
        }
        this.schemaPattern = ((Filter)filters.get(1)).getExpression();
        this.originalNamePattern = ((Filter)filters.get(2)).getExpression();
        this.tableNamePattern = this.filterAsJDBCPattern((Filter)filters.get(6));
        this.columnNamePattern = this.filterAsJDBCPattern((Filter)filters.get(3));
        this.targetCatalogName = ((Filter)filters.get(4)).getExpression();
        this.targetSchemaName = this.filterAsJDBCPattern((Filter)filters.get(5));
        if (this.targetCatalogName == null) {
            this.targetCatalogName = this.catalog;
        }
        if (this.targetSchemaName == null) {
            this.targetSchemaName = this.schemaPattern;
        }
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(10);
        row.set(0, this.catalog);
        row.set(1, this.schemaPattern);
        row.set(2, this.originalNamePattern);
        row.set(3, (Object)this.objectPool.pool(this.rs.getString(4)));
        row.set(4, JDBCColumnMaps.getAdaptorTypeAsString(this.rs.getInt(5)));
        row.set(5, (Object)this.objectPool.pool(this.rs.getString(6)));
        row.set(6, this.objectPool.pool(this.rs.getInt(7)));
        int i = this.rs.getInt(9);
        if (this.rs.wasNull()) {
            row.set(7, null);
        } else {
            row.set(7, this.objectPool.pool(i));
        }
        row.set(9, (Object)this.objectPool.pool(this.rs.getString(18)));
        row.set(8, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(12))));
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getColumns(this.targetCatalogName, this.targetSchemaName, this.tableNamePattern, this.columnNamePattern);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDColumnException(e);
    }
}

