/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDTableException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class SynonymRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getSynonyms()";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int SYNONYMNAME_COLUMN = 2;
    public static final int SYNONYMTYPE_COLUMN = 3;
    public static final int SYNONYMDESCRIPTION_COLUMN = 4;
    public static final int SYNONYM_EXTERNAL_HOST_REF = 5;
    public static final int SYNONYM_TARGET_CATALOG = 6;
    public static final int SYNONYM_TARGET_SCHEMA = 7;
    public static final int SYNONYM_TARGET_REFOBJECT_NAME = 8;
    public static final int NUMBER_OF_CACHED_COLUMNS = 9;
    public static final int getSynonyms_parentCatalog = 1;
    public static final int getSynonyms_parentSchema = 2;
    public static final int getSynonyms_synonymName = 3;
    public static final int getSynonyms_externalHostRef = 4;
    public static final int getSynonyms_targetCatalog = 5;
    public static final int getSynonyms_targetSchema = 6;
    public static final int getSynonyms_targetRefObjectName = 7;
    public static final int getSynonyms_description = 8;
    String[] tableTypes;
    String schemaPattern;
    String tableNamePattern;

    SynonymRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        this.tableNamePattern = this.filterAsJDBCPattern((Filter)filters.get(2));
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        String jdbcURL;
        CachedRow row = new CachedRow(9);
        try {
            jdbcURL = this.metadata.getURL();
        }
        catch (SQLException e) {
            jdbcURL = "";
        }
        if (jdbcURL.contains("jdbc:sqlserver:") || jdbcURL.contains("jdbc:oracle:")) {
            if (this.rs != null) {
                row.set(0, this.rs.getString(1));
                row.set(1, this.rs.getString(2));
                row.set(2, this.rs.getString(3));
                row.set(3, "SYNONYM");
                String strSynonymDescription = this.rs.getString(8);
                if (strSynonymDescription != null && strSynonymDescription.length() != 0) {
                    row.set(4, strSynonymDescription);
                }
                row.set(5, this.rs.getString(4));
                row.set(6, this.rs.getString(5));
                row.set(7, this.rs.getString(6));
                row.set(8, this.rs.getString(7));
            }
            this.cachedData.add(row);
        }
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        String jdbcURL;
        String catalog = row.getString(0);
        this.events.incrementCounter(API_NAME);
        try {
            jdbcURL = this.metadata.getURL();
        }
        catch (SQLException e) {
            jdbcURL = "";
        }
        if ((jdbcURL.contains("jdbc:sqlserver:") || jdbcURL.contains("jdbc:oracle:")) && this.metadata instanceof IAdaptorDBMetadata) {
            String[] synonym_tableTypes = new String[]{"SYNONYM", "ALIAS", "NICKNAME"};
            this.rs = ((IAdaptorDBMetadata)this.metadata).getSynonyms(catalog, this.schemaPattern, this.tableNamePattern, synonym_tableTypes);
        }
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDTableException(e);
    }
}

