/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmd.importer;

import com.ibm.cognos.jmd.exception.JMDImportException;
import com.ibm.cognos.jmd.exception.JMDTableException;
import com.ibm.cognos.jmd.importer.AbstractedNestedJDBCRequest;
import com.ibm.cognos.jmd.importer.CachedRow;
import com.ibm.cognos.jmd.importer.NullResultSetIterator;
import com.ibm.cognos.jmd.importer.ResultSetCache;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.ObjectType;
import com.ibm.cognos.jmd.selector.Filter;
import com.ibm.cognos.jmd.selector.FilterList;
import com.ibm.cognos.jmd.selector.SelectionCriteria;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class TableRequest
extends AbstractedNestedJDBCRequest {
    private static final String API_NAME = "getTables()";
    private static final String API_NAME_ROWS = "getTables() rows";
    public static final int CATALOGNAME_COLUMN = 0;
    public static final int SCHEMANAME_COLUMN = 1;
    public static final int TABLENAME_COLUMN = 2;
    public static final int TABLETYPE_COLUMN = 3;
    public static final int TABLEDESCRIPTION_COLUMN = 4;
    public static final int NUMBER_OF_CACHED_COLUMNS = 5;
    public static final int JDBC_TABLE_CAT = 1;
    public static final int JDBC_TABLE_SCHEM = 2;
    public static final int JDBC_TABLE_NAME = 3;
    public static final int JDBC_TABLE_TYPE = 4;
    public static final int JDBC_REMARKS = 5;
    String[] tableTypes;
    String schemaPattern;
    String tableNamePattern;

    TableRequest(DatabaseMetaData dmd, ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        super(dmd, resultSetCache, selectionCriteria);
        FilterList filters = selectionCriteria.getFilterList();
        this.setTableTypes(dmd, (Filter)filters.get(3));
        this.schemaPattern = this.filterAsJDBCPattern((Filter)filters.get(1));
        this.tableNamePattern = this.filterAsJDBCPattern((Filter)filters.get(2));
    }

    private void setTableTypes(DatabaseMetaData dmd, Filter f) {
        if (f.matchesAll()) {
            this.tableTypes = null;
        } else if (f.hasWildCards()) {
            try {
                Pattern pattern = f.asPattern();
                ArrayList<String> ttypes = new ArrayList<String>();
                ResultSet ttrs = dmd.getTableTypes();
                while (ttrs.next()) {
                    String ttype = ttrs.getString(1);
                    if (!pattern.matcher(ttype).matches()) continue;
                    ttypes.add(ttype);
                }
                this.tableTypes = ttypes.toArray(new String[ttypes.size()]);
            }
            catch (SQLException e) {
                this.tableTypes = null;
            }
        } else {
            ArrayList<String> ttypes = new ArrayList<String>();
            for (Filter sub : f.subFilters()) {
                ttypes.add(sub.getExpression());
            }
            this.tableTypes = ttypes.toArray(new String[ttypes.size()]);
        }
    }

    @Override
    protected CachedRow createAndAddRowToCache() throws SQLException {
        this.events.incrementCounter(API_NAME_ROWS);
        CachedRow row = new CachedRow(5);
        row.set(0, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(1))));
        row.set(1, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(2))));
        row.set(2, (Object)this.objectPool.pool(this.rs.getString(3)));
        row.set(3, (Object)this.objectPool.pool(this.rs.getString(4)));
        row.set(4, (Object)this.objectPool.pool(this.convertEmptyStringToNull(this.rs.getString(5))));
        this.cachedData.add(row);
        return row;
    }

    @Override
    protected void createIterator(ResultSetCache resultSetCache, SelectionCriteria selectionCriteria) throws JMDImportException {
        FilterList filters = selectionCriteria.getFilterList();
        this.iterator = ((Filter)filters.get(0)).getExpression().equals("\ufffds") ? new NullResultSetIterator(1) : resultSetCache.getIterator(new SelectionCriteria(ObjectType.CATALOG, new AttributeType[]{AttributeType.NAME}, filters), this.metadata);
    }

    @Override
    protected void createResultSetFromIteratorRow(CachedRow row) throws SQLException {
        String catalog = row.getString(0);
        this.events.incrementCounter(API_NAME);
        this.rs = this.metadata.getTables(catalog, this.schemaPattern, this.tableNamePattern, this.tableTypes);
    }

    @Override
    protected JMDImportException wrapException(Exception e) {
        return new JMDTableException(e);
    }
}

